/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy;

import guideme.internal.shaded.lucene.facet.FacetUtils;
import guideme.internal.shaded.lucene.facet.taxonomy.FacetLabel;
import guideme.internal.shaded.lucene.facet.taxonomy.OrdinalsReader;
import guideme.internal.shaded.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import guideme.internal.shaded.lucene.facet.taxonomy.TaxonomyReader;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.util.IntsRef;
import java.io.IOException;

public class TaxonomyFacetLabels {
    private final TaxonomyReader taxoReader;
    private final String indexFieldName;

    public TaxonomyFacetLabels(TaxonomyReader taxoReader, String indexFieldName) {
        this.taxoReader = taxoReader;
        this.indexFieldName = indexFieldName;
    }

    public FacetLabelReader getFacetLabelReader(LeafReaderContext readerContext) throws IOException {
        SortedNumericDocValues ordinalValues = FacetUtils.loadOrdinalValues(readerContext.reader(), this.indexFieldName);
        if (ordinalValues == null) {
            ordinalValues = DocValues.emptySortedNumeric();
        }
        return new FacetLabelReader(ordinalValues);
    }

    public class FacetLabelReader {
        private final SortedNumericDocValues ordinalValues;
        private final OrdinalsReader.OrdinalsSegmentReader ordinalsSegmentReader;
        private final IntsRef decodedOrds;
        private int currentDocId = -1;
        private boolean currentDocHasValues;
        private int currentPos;
        private int currentDocOrdinalCount;
        private ParallelTaxonomyArrays.IntArray parents;

        public FacetLabelReader(SortedNumericDocValues ordinalValues) {
            this.ordinalValues = ordinalValues;
            this.ordinalsSegmentReader = null;
            this.decodedOrds = null;
        }

        @Deprecated
        public FacetLabelReader(OrdinalsReader ordsReader, LeafReaderContext readerContext) throws IOException {
            this.ordinalsSegmentReader = ordsReader.getReader(readerContext);
            this.decodedOrds = new IntsRef();
            this.ordinalValues = null;
        }

        public FacetLabel nextFacetLabel(int docId) throws IOException {
            int ord;
            if (this.currentDocId != docId) {
                if (docId < this.currentDocId) {
                    throw new IllegalArgumentException("docs out of order: previous docId=" + this.currentDocId + " current docId=" + docId);
                }
                this.currentDocId = docId;
                if (this.ordinalsSegmentReader != null) {
                    this.ordinalsSegmentReader.get(docId, this.decodedOrds);
                    this.currentPos = this.decodedOrds.offset;
                } else {
                    this.currentDocHasValues = this.ordinalValues.advanceExact(docId);
                    if (this.currentDocHasValues) {
                        this.currentDocOrdinalCount = this.ordinalValues.docValueCount();
                        this.currentPos = 0;
                    }
                }
            }
            if (this.ordinalsSegmentReader != null) {
                int endPos = this.decodedOrds.offset + this.decodedOrds.length;
                assert (this.currentPos <= endPos);
                if (this.currentPos == endPos) {
                    return null;
                }
                ord = this.decodedOrds.ints[this.currentPos++];
            } else {
                if (!this.currentDocHasValues) {
                    return null;
                }
                assert (this.currentPos <= this.currentDocOrdinalCount);
                if (this.currentPos == this.currentDocOrdinalCount) {
                    return null;
                }
                ord = (int)this.ordinalValues.nextValue();
                ++this.currentPos;
            }
            return TaxonomyFacetLabels.this.taxoReader.getPath(ord);
        }

        private boolean isDescendant(int ord, int ancestorOrd) {
            while (ord != -1 && ord != 0) {
                if (this.parents.get(ord) == ancestorOrd) {
                    return true;
                }
                ord = this.parents.get(ord);
            }
            return false;
        }

        public FacetLabel nextFacetLabel(int docId, String facetDimension) throws IOException {
            if (facetDimension == null) {
                throw new IllegalArgumentException("Input facet dimension cannot be null");
            }
            int parentOrd = TaxonomyFacetLabels.this.taxoReader.getOrdinal(new FacetLabel(facetDimension));
            if (parentOrd == -1) {
                throw new IllegalArgumentException("Category ordinal not found for facet dimension: " + facetDimension);
            }
            if (this.currentDocId != docId) {
                if (docId < this.currentDocId) {
                    throw new IllegalArgumentException("docs out of order: previous docId=" + this.currentDocId + " current docId=" + docId);
                }
                this.currentDocId = docId;
                if (this.ordinalsSegmentReader != null) {
                    this.ordinalsSegmentReader.get(docId, this.decodedOrds);
                    this.currentPos = this.decodedOrds.offset;
                } else {
                    this.currentDocHasValues = this.ordinalValues.advanceExact(docId);
                    if (this.currentDocHasValues) {
                        this.currentDocOrdinalCount = this.ordinalValues.docValueCount();
                        this.currentPos = 0;
                    }
                }
            }
            if (this.ordinalsSegmentReader != null) {
                int endPos = this.decodedOrds.offset + this.decodedOrds.length;
                assert (this.currentPos <= endPos);
                if (this.currentPos == endPos) {
                    return null;
                }
                if (this.parents == null) {
                    this.parents = TaxonomyFacetLabels.this.taxoReader.getParallelTaxonomyArrays().parents();
                }
                do {
                    int ord;
                    if (!this.isDescendant(ord = this.decodedOrds.ints[this.currentPos++], parentOrd)) continue;
                    return TaxonomyFacetLabels.this.taxoReader.getPath(ord);
                } while (this.currentPos < endPos);
            } else {
                if (!this.currentDocHasValues) {
                    return null;
                }
                assert (this.currentPos <= this.currentDocOrdinalCount);
                if (this.currentPos == this.currentDocOrdinalCount) {
                    return null;
                }
                if (this.parents == null) {
                    this.parents = TaxonomyFacetLabels.this.taxoReader.getParallelTaxonomyArrays().parents();
                }
                do {
                    int ord = (int)this.ordinalValues.nextValue();
                    ++this.currentPos;
                    if (!this.isDescendant(ord, parentOrd)) continue;
                    return TaxonomyFacetLabels.this.taxoReader.getPath(ord);
                } while (this.currentPos < this.currentDocOrdinalCount);
            }
            return null;
        }
    }
}

