/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.classic;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.queryparser.classic.ParseException;
import guideme.internal.shaded.lucene.queryparser.classic.QueryParser;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.BoostQuery;
import guideme.internal.shaded.lucene.search.MultiPhraseQuery;
import guideme.internal.shaded.lucene.search.PhraseQuery;
import guideme.internal.shaded.lucene.search.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultiFieldQueryParser
extends QueryParser {
    protected String[] fields;
    protected Map<String, Float> boosts;

    public MultiFieldQueryParser(String[] fields, Analyzer analyzer, Map<String, Float> boosts) {
        this(fields, analyzer);
        this.boosts = boosts;
    }

    public MultiFieldQueryParser(String[] fields, Analyzer analyzer) {
        super(null, analyzer);
        this.fields = fields;
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i = 0; i < this.fields.length; ++i) {
                Float boost;
                Query q = super.getFieldQuery(this.fields[i], queryText, true);
                if (q == null) continue;
                if (this.boosts != null && (boost = this.boosts.get(this.fields[i])) != null) {
                    q = new BoostQuery(q, boost.floatValue());
                }
                q = this.applySlop(q, slop);
                clauses.add(q);
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q = super.getFieldQuery(field, queryText, true);
        q = this.applySlop(q, slop);
        return q;
    }

    private Query applySlop(Query q, int slop) {
        if (q instanceof PhraseQuery) {
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            PhraseQuery pq = (PhraseQuery)q;
            Term[] terms = pq.getTerms();
            int[] positions = pq.getPositions();
            for (int i = 0; i < terms.length; ++i) {
                builder.add(terms[i], positions[i]);
            }
            q = builder.build();
        } else if (q instanceof MultiPhraseQuery) {
            MultiPhraseQuery mpq = (MultiPhraseQuery)q;
            if (slop != mpq.getSlop()) {
                q = new MultiPhraseQuery.Builder(mpq).setSlop(slop).build();
            }
        } else if (q instanceof BoostQuery) {
            Query subQuery = ((BoostQuery)q).getQuery();
            subQuery = this.applySlop(subQuery, slop);
            q = new BoostQuery(subQuery, ((BoostQuery)q).getBoost());
        }
        return q;
    }

    private Query applyBoost(Query q, String field) {
        Float boost;
        if (this.boosts != null && (boost = this.boosts.get(field)) != null) {
            q = new BoostQuery(q, boost.floatValue());
        }
        return q;
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            Query[] fieldQueries = new Query[this.fields.length];
            int maxTerms = 0;
            for (int i = 0; i < this.fields.length; ++i) {
                Query q = super.getFieldQuery(this.fields[i], queryText, quoted);
                if (q == null) continue;
                maxTerms = q instanceof BooleanQuery ? Math.max(maxTerms, ((BooleanQuery)q).clauses().size()) : Math.max(1, maxTerms);
                fieldQueries[i] = q;
            }
            for (int termNum = 0; termNum < maxTerms; ++termNum) {
                ArrayList<Query> termClauses = new ArrayList<Query>();
                for (int i = 0; i < this.fields.length; ++i) {
                    Float boost;
                    if (fieldQueries[i] == null) continue;
                    Query q = null;
                    if (fieldQueries[i] instanceof BooleanQuery) {
                        List<BooleanClause> nestedClauses = ((BooleanQuery)fieldQueries[i]).clauses();
                        if (termNum < nestedClauses.size()) {
                            q = nestedClauses.get(termNum).getQuery();
                        }
                    } else if (termNum == 0) {
                        q = fieldQueries[i];
                    }
                    if (q == null) continue;
                    if (this.boosts != null && (boost = this.boosts.get(this.fields[i])) != null) {
                        q = new BoostQuery(q, boost.floatValue());
                    }
                    termClauses.add(q);
                }
                if (maxTerms > 1) {
                    if (termClauses.size() <= 0) continue;
                    BooleanQuery.Builder builder = this.newBooleanQuery();
                    for (Query termClause : termClauses) {
                        builder.add(termClause, BooleanClause.Occur.SHOULD);
                    }
                    clauses.add(builder.build());
                    continue;
                }
                clauses.addAll(termClauses);
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q = super.getFieldQuery(field, queryText, quoted);
        return q;
    }

    @Override
    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(this.getFuzzyQuery(this.fields[i], termStr, minSimilarity));
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q = super.getFuzzyQuery(field, termStr, minSimilarity);
        return this.applyBoost(q, field);
    }

    @Override
    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(this.getPrefixQuery(this.fields[i], termStr));
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q = super.getPrefixQuery(field, termStr);
        return this.applyBoost(q, field);
    }

    @Override
    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(this.getWildcardQuery(this.fields[i], termStr));
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q = super.getWildcardQuery(field, termStr);
        return this.applyBoost(q, field);
    }

    @Override
    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(this.getRangeQuery(this.fields[i], part1, part2, startInclusive, endInclusive));
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q = super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
        return this.applyBoost(q, field);
    }

    @Override
    protected Query getRegexpQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(this.getRegexpQuery(this.fields[i], termStr));
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q = super.getRegexpQuery(field, termStr);
        return this.applyBoost(q, field);
    }

    protected Query getMultiFieldQuery(List<Query> queries) throws ParseException {
        if (queries.isEmpty()) {
            return null;
        }
        BooleanQuery.Builder query = this.newBooleanQuery();
        for (Query sub : queries) {
            query.add(sub, BooleanClause.Occur.SHOULD);
        }
        return query.build();
    }

    public static Query parse(String[] queries, String[] fields, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() <= 0) continue;
            bQuery.add(q, BooleanClause.Occur.SHOULD);
        }
        return bQuery.build();
    }

    public static Query parse(String query, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (fields.length != flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(query);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() <= 0) continue;
            bQuery.add(q, flags[i]);
        }
        return bQuery.build();
    }

    public static Query parse(String[] queries, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() <= 0) continue;
            bQuery.add(q, flags[i]);
        }
        return bQuery.build();
    }
}

