/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.html;

import guideme.libs.micromark.Token;
import guideme.libs.micromark.html.HtmlContext;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class HtmlExtension {
    @Nullable
    public final DocumentHandler enterDocument;
    @Nullable
    public final DocumentHandler exitDocument;
    public final Map<String, Handler> enter;
    public final Map<String, Handler> exit;

    private HtmlExtension(@Nullable DocumentHandler enterDocument, @Nullable DocumentHandler exitDocument, Map<String, Handler> enter, Map<String, Handler> exit) {
        this.enterDocument = enterDocument;
        this.exitDocument = exitDocument;
        this.enter = enter;
        this.exit = exit;
    }

    public static Builder builder() {
        return new Builder();
    }

    @FunctionalInterface
    public static interface DocumentHandler {
        public void handle(HtmlContext var1);
    }

    public static class Builder {
        private DocumentHandler enterDocument;
        private DocumentHandler exitDocument;
        private final Map<String, Handler> enter = new HashMap<String, Handler>();
        private final Map<String, Handler> exit = new HashMap<String, Handler>();

        private Builder() {
        }

        public Builder enterDocument(DocumentHandler handler) {
            this.enterDocument = handler;
            return this;
        }

        public Builder exitDocument(DocumentHandler handler) {
            this.exitDocument = handler;
            return this;
        }

        public Builder enter(String type, Handler handler) {
            this.enter.put(type, handler);
            return this;
        }

        public Builder enter(String type, Runnable handler) {
            this.enter.put(type, (context, token) -> handler.run());
            return this;
        }

        public Builder exit(String type, Handler handler) {
            this.exit.put(type, handler);
            return this;
        }

        public Builder exit(String type, Runnable handler) {
            this.exit.put(type, (context, token) -> handler.run());
            return this;
        }

        public Builder addAll(HtmlExtension extension) {
            this.enter.putAll(extension.enter);
            this.exit.putAll(extension.exit);
            return this;
        }

        public HtmlExtension build() {
            return new HtmlExtension(this.enterDocument, this.exitDocument, this.enter, this.exit);
        }
    }

    @FunctionalInterface
    public static interface Handler {
        public void handle(HtmlContext var1, Token var2);
    }
}

