/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.traversableleaves.mixin;

import com.dreu.traversableleaves.config.TLConfig;
import com.dreu.traversableleaves.interfaces.ITraversableBlock;
import com.dreu.traversableleaves.interfaces.ITraversableEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
public class EntityMixin {
    private Entity self() {
        return (Entity)this;
    }

    @ModifyVariable(method={"moveRelative"}, at=@At(value="HEAD"), index=2, argsOnly=true)
    private Vec3 modifyMoveRelativeVec3(Vec3 originalVec) {
        ITraversableEntity iTraversableEntity;
        Entity entity = this.self();
        if (entity instanceof ITraversableEntity && (iTraversableEntity = (ITraversableEntity)entity).isStuckInLeaves()) {
            iTraversableEntity.setStuckInLeaves(false);
            float armorMultiplier = TLConfig.MOVEMENT_MULTIPLIER + iTraversableEntity.getArmorBonus();
            return originalVec.m_82542_((double)armorMultiplier, 1.0, (double)armorMultiplier);
        }
        return originalVec;
    }

    @Redirect(method={"checkInsideBlocks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;entityInside(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)V"))
    private void redirectEntityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.shouldTraverse(blockState, level, blockPos, entity)) {
                ((ITraversableEntity)livingEntity).setStuckInLeaves(true);
                livingEntity.m_183634_();
                if (livingEntity.m_20164_()) {
                    livingEntity.m_20256_(livingEntity.m_20184_().m_82542_(1.0, 0.5, 1.0));
                }
                this.createAmbience(entity, blockPos, blockState);
            }
        }
        blockState.m_60682_(level, blockPos, entity);
    }

    private boolean shouldTraverse(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        Player player;
        ITraversableBlock block;
        Block block2 = blockState.m_60734_();
        return !(!(block2 instanceof ITraversableBlock) || !(block = (ITraversableBlock)block2).isTraversable() || entity instanceof Player && (player = (Player)entity).m_7500_() && player.m_150110_().f_35935_ || entity.m_20182_().f_82480_ >= blockState.m_60734_().m_5939_(blockState, (BlockGetter)level, blockPos, CollisionContext.m_82749_()).m_83297_(Direction.Axis.Y) + (double)blockPos.m_123342_());
    }

    private void createAmbience(Entity entity, BlockPos blockPos, BlockState blockState) {
        if (!entity.m_20182_().equals((Object)new Vec3(entity.f_19790_, entity.f_19791_, entity.f_19792_))) {
            if (entity.m_9236_().m_46467_() % 15L == 1L) {
                entity.m_5496_(blockState.m_60827_().m_56776_(), 0.1f, 0.6f);
            }
            if (entity.m_9236_().m_46467_() % 4L == 1L) {
                double d0 = (double)blockPos.m_123341_() + entity.m_9236_().f_46441_.m_188500_();
                double d1 = (double)blockPos.m_123342_() + 1.0;
                double d2 = (double)blockPos.m_123343_() + entity.m_9236_().f_46441_.m_188500_();
                entity.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }
}

