/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.traversableleaves.network;

import com.dreu.traversableleaves.TraversableLeaves;
import com.dreu.traversableleaves.config.TLConfig;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class SyncConfigS2CPacket {
    public SyncConfigS2CPacket(FriendlyByteBuf buf) {
        int i;
        TLConfig.TL_ENTITIES.clear();
        TLConfig.TL_BLOCKS.clear();
        TLConfig.MOVEMENT_MULTIPLIER = buf.readFloat();
        TLConfig.ARMOR_SCALE_FACTOR = buf.readFloat();
        TLConfig.IS_ENTITIES_WHITELIST = buf.readBoolean();
        TLConfig.CAN_CLIMB = buf.readBoolean();
        int bounds = buf.readInt();
        for (i = 0; i < bounds; ++i) {
            TLConfig.TL_BLOCKS.add(new ResourceLocation(buf.readCharSequence(buf.readInt(), StandardCharsets.UTF_8).toString()));
        }
        bounds = buf.readInt();
        for (i = 0; i < bounds; ++i) {
            TLConfig.TL_ENTITIES.add(new ResourceLocation(buf.readCharSequence(buf.readInt(), StandardCharsets.UTF_8).toString()));
        }
    }

    public SyncConfigS2CPacket() {
        if (!TraversableLeaves.configHasBeenPopulated) {
            TLConfig.parse();
            TLConfig.populate();
            TraversableLeaves.configHasBeenPopulated = true;
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(TLConfig.MOVEMENT_MULTIPLIER);
        buf.writeFloat(TLConfig.ARMOR_SCALE_FACTOR);
        buf.writeBoolean(TLConfig.IS_ENTITIES_WHITELIST);
        buf.writeBoolean(TLConfig.CAN_CLIMB);
        buf.writeInt(TLConfig.TL_BLOCKS.size());
        for (ResourceLocation block : TLConfig.TL_BLOCKS) {
            buf.writeInt(block.toString().length());
            buf.writeCharSequence((CharSequence)block.toString(), StandardCharsets.UTF_8);
        }
        buf.writeInt(TLConfig.TL_ENTITIES.size());
        for (ResourceLocation entity : TLConfig.TL_ENTITIES) {
            buf.writeInt(entity.toString().length());
            buf.writeCharSequence((CharSequence)entity.toString(), StandardCharsets.UTF_8);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TraversableLeaves.configHasBeenPopulated = false;
        });
        context.get().setPacketHandled(true);
    }
}

