/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookHistory;
import vazkii.patchouli.client.book.gui.GuiBookIndex;
import vazkii.patchouli.client.book.gui.GuiBookWriter;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookResize;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.client.gui.GuiAdvancementsExt;
import vazkii.patchouli.common.book.Book;

public class GuiBookLanding
extends GuiBook {
    @Nullable
    BookTextRenderer text;
    int loadedCategories = 0;
    final List<Button> pamphletEntryButtons = new ArrayList<Button>();
    List<BookEntry> entriesInPamphlet;

    public GuiBookLanding(Book book) {
        super(book, (Component)Component.m_237115_((String)book.name));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.text = new BookTextRenderer(this, (Component)Component.m_237115_((String)this.book.landingText), 15, 43);
        boolean disableBar = !this.book.showProgress || !this.book.advancementsEnabled();
        int x = this.bookLeft + (disableBar ? 25 : 20);
        int y = this.bookTop + 180 - (disableBar ? 25 : 62);
        int dist = 15;
        int pos = 0;
        if (this.maxScale > 2) {
            this.m_142416_(new GuiButtonBookResize(this, x + pos++ * dist, y, this::handleButtonResize));
        }
        this.m_142416_(new GuiButtonBook((GuiBook)this, x + pos++ * dist, y, 330, 31, 11, 11, this::handleButtonHistory, new Component[]{Component.m_237115_((String)"patchouli.gui.lexicon.button.history")}));
        if (this.book.advancementsTab != null) {
            this.m_142416_(new GuiButtonBook((GuiBook)this, x + pos++ * dist, y, 330, 20, 11, 11, this::handleButtonAdvancements, new Component[]{Component.m_237115_((String)"patchouli.gui.lexicon.button.advancements")}));
        }
        if (Minecraft.m_91087_().f_91074_.m_7500_()) {
            this.m_142416_(new GuiButtonBook((GuiBook)this, x + pos++ * dist, y, 308, 9, 11, 11, this::handleButtonEdit, new Component[]{Component.m_237115_((String)"patchouli.gui.lexicon.button.editor"), Component.m_237115_((String)"patchouli.gui.lexicon.button.editor.info").m_130940_(ChatFormatting.GRAY)}));
        }
        if (this.book.getContents().pamphletCategory == null) {
            int i = 0;
            ArrayList<BookCategory> categories = new ArrayList<BookCategory>(this.book.getContents().categories.values());
            Collections.sort(categories);
            for (BookCategory category : categories) {
                if (category.getParentCategory() != null || category.shouldHide()) continue;
                this.addCategoryButton(i, category);
                ++i;
            }
            this.addCategoryButton(i, null);
            this.loadedCategories = i + 1;
        } else {
            this.entriesInPamphlet = new ArrayList<BookEntry>(this.book.getContents().entries.values());
            this.entriesInPamphlet.removeIf(BookEntry::shouldHide);
            Collections.sort(this.entriesInPamphlet);
            this.buildEntryButtons();
            this.loadedCategories = 0;
        }
    }

    private void addCategoryButton(int i, BookCategory category) {
        int x = 151 + i % 4 * 24;
        int y = 43 + i / 4 * 24;
        if (category == null) {
            this.m_142416_(new GuiButtonCategory(this, x, y, this.book.getIcon(), (Component)Component.m_237115_((String)"patchouli.gui.lexicon.index"), this::handleButtonIndex));
        } else {
            this.m_142416_(new GuiButtonCategory(this, x, y, category, this::handleButtonCategory));
        }
    }

    @Override
    void drawForegroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.text != null) {
            this.text.render(graphics, mouseX, mouseY);
        }
        int topSeparator = 30;
        int bottomSeparator = topSeparator + 25 + 24 * ((this.loadedCategories - 1) / 4 + 1);
        this.drawHeader(graphics);
        if (this.book.getContents().pamphletCategory == null) {
            this.drawCenteredStringNoShadow(graphics, I18n.m_118938_((String)"patchouli.gui.lexicon.categories", (Object[])new Object[0]), 199, 18, this.book.headerColor);
            GuiBookLanding.drawSeparator(graphics, this.book, 141, topSeparator);
            if (this.loadedCategories <= 16) {
                GuiBookLanding.drawSeparator(graphics, this.book, 141, bottomSeparator);
            }
        }
        if (this.book.getContents().isErrored()) {
            int x = 199;
            int y = bottomSeparator + 12;
            this.drawCenteredStringNoShadow(graphics, I18n.m_118938_((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), x, y, 0xFF0000);
            this.drawCenteredStringNoShadow(graphics, I18n.m_118938_((String)"patchouli.gui.lexicon.loading_error_hover", (Object[])new Object[0]), x, y + 10, 0x777777);
            if (this.isMouseInRelativeRange(mouseX, mouseY, x -= 58, y -= 4, 116, 20)) {
                this.makeErrorTooltip();
            }
        }
        this.drawProgressBar(graphics, this.book, mouseX, mouseY, e -> true);
    }

    @Override
    void onPageChanged() {
        this.buildEntryButtons();
    }

    private void buildEntryButtons() {
        this.removeDrawablesIn(this.pamphletEntryButtons);
        this.pamphletEntryButtons.clear();
        this.maxSpreads = 1;
        this.addEntryButtons(141, 18, 0, 11);
    }

    private void addEntryButtons(int x, int y, int start, int count) {
        if (!this.book.getContents().isErrored()) {
            for (int i = 0; i < count && i + start < this.entriesInPamphlet.size(); ++i) {
                GuiButtonEntry button = new GuiButtonEntry(this, this.bookLeft + x, this.bookTop + y + i * 11, this.entriesInPamphlet.get(start + i), this::handleButtonPamphletEntry);
                this.m_142416_(button);
                this.pamphletEntryButtons.add(button);
            }
        }
    }

    private void drawHeader(GuiGraphics graphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBookLanding.drawFromTexture(graphics, this.book, -8, 12, 0, 180, 140, 31);
        int color = this.book.nameplateColor;
        graphics.m_280614_(this.f_96547_, this.book.getBookItem().m_41786_(), 13, 16, color, false);
        MutableComponent toDraw = this.book.getSubtitle().m_130948_(this.book.getFontStyle());
        graphics.m_280614_(this.f_96547_, (Component)toDraw, 24, 24, color, false);
    }

    private void makeErrorTooltip() {
        ArrayList<Component> lines = new ArrayList<Component>();
        for (Throwable e = this.book.getContents().getException(); e != null; e = e.getCause()) {
            String msg = e.getMessage();
            if (msg == null || msg.isEmpty()) continue;
            lines.add((Component)Component.m_237113_((String)e.getMessage()));
        }
        if (!lines.isEmpty()) {
            lines.add((Component)Component.m_237115_((String)"patchouli.gui.lexicon.loading_error_log").m_130940_(ChatFormatting.GREEN));
            this.setTooltip(lines);
        }
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.text != null && this.text.click(mouseX, mouseY, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    public void handleButtonIndex(Button button) {
        this.displayLexiconGui(new GuiBookIndex(this.book), true);
    }

    public void handleButtonCategory(Button button) {
        this.displayLexiconGui(new GuiBookCategory(this.book, ((GuiButtonCategory)button).getCategory()), true);
    }

    private void handleButtonHistory(Button button) {
        this.displayLexiconGui(new GuiBookHistory(this.book), true);
    }

    private void handleButtonAdvancements(Button button) {
        this.f_96541_.m_91152_((Screen)new GuiAdvancementsExt(this.f_96541_.f_91074_.f_108617_.m_105145_(), this, this.book.advancementsTab));
    }

    private void handleButtonEdit(Button button) {
        if (GuiBookLanding.m_96638_()) {
            long time = System.currentTimeMillis();
            this.book.reloadContents((Level)this.f_96541_.f_91073_, true);
            this.book.reloadLocks(false);
            this.displayLexiconGui(new GuiBookLanding(this.book), false);
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237110_((String)"patchouli.gui.lexicon.reloaded", (Object[])new Object[]{System.currentTimeMillis() - time}), false);
        } else {
            this.displayLexiconGui(new GuiBookWriter(this.book), true);
        }
    }

    public void handleButtonResize(Button button) {
        PersistentData.data.bookGuiScale = PersistentData.data.bookGuiScale >= this.maxScale ? 0 : Math.max(2, PersistentData.data.bookGuiScale + 1);
        PersistentData.save();
        this.displayLexiconGui(this, false);
    }

    public void handleButtonPamphletEntry(Button button) {
        GuiBookEntry.displayOrBookmark(this, ((GuiButtonEntry)button).getEntry());
    }
}

