/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.model;

import com.blackgear.vanillabackport.client.level.entities.animation.BatAnimation;
import com.blackgear.vanillabackport.common.level.entities.bat.BatAnimator;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BatModel
extends HierarchicalModel<Bat> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart rightWingTip;
    private final ModelPart leftWingTip;
    private final ModelPart feet;

    public BatModel(ModelPart root) {
        super(RenderType::m_110452_);
        this.root = root;
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.rightWing = this.body.m_171324_("right_wing");
        this.rightWingTip = this.rightWing.m_171324_("right_wing_tip");
        this.leftWing = this.body.m_171324_("left_wing");
        this.leftWingTip = this.leftWing.m_171324_("left_wing_tip");
        this.feet = this.body.m_171324_("feet");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-2.0f, -3.0f, -1.0f, 4.0f, 3.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(1, 15).m_171481_(-2.5f, -4.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.m_171419_((float)-1.5f, (float)-2.0f, (float)0.0f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(8, 15).m_171481_(-0.1f, -3.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.m_171419_((float)1.1f, (float)-3.0f, (float)0.0f));
        PartDefinition rightWing = body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(-2.0f, -2.0f, 0.0f, 2.0f, 7.0f, 0.0f), PartPose.m_171419_((float)-1.5f, (float)0.0f, (float)0.0f));
        rightWing.m_171599_("right_wing_tip", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-6.0f, -2.0f, 0.0f, 6.0f, 8.0f, 0.0f), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(12, 7).m_171481_(0.0f, -2.0f, 0.0f, 2.0f, 7.0f, 0.0f), PartPose.m_171419_((float)1.5f, (float)0.0f, (float)0.0f));
        leftWing.m_171599_("left_wing_tip", CubeListBuilder.m_171558_().m_171514_(16, 8).m_171481_(0.0f, -2.0f, 0.0f, 6.0f, 8.0f, 0.0f), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("feet", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 2.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setupAnim(Bat entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.m_27452_()) {
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        }
        if (entity instanceof BatAnimator) {
            BatAnimator animator = (BatAnimator)entity;
            this.m_233381_(animator.flyAnimationState(), BatAnimation.BAT_FLYING, ageInTicks);
            this.m_233381_(animator.restAnimationState(), BatAnimation.BAT_RESTING, ageInTicks);
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

