/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.animationcontroller;

import com.mojang.blaze3d.platform.Window;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoint;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationKeyframe;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.RangeSlider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class KeyframeManagerScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final int KEY_MOVE_KEYFRAME_LEFT = 263;
    protected static final int KEY_MOVE_KEYFRAME_RIGHT = 262;
    protected static final int KEY_DELETE_KEYFRAME = 261;
    protected static final int KEY_ADD_KEYFRAME = 75;
    protected static final int KEY_TOGGLE_RECORDING = 82;
    protected static final int KEY_TOGGLE_PAUSE_RECORDING = 84;
    protected static final int KEY_TOGGLE_PLAYING = 80;
    protected static final DrawableColor TIMELINE_COLOR = DrawableColor.of(new Color(0, 122, 204));
    protected static final DrawableColor TIMELINE_PADDING_COLOR = DrawableColor.of(new Color(3, 83, 138));
    protected static final DrawableColor KEYFRAME_COLOR = DrawableColor.of(new Color(255, 255, 255));
    protected static final DrawableColor KEYFRAME_COLOR_SELECTED = DrawableColor.of(new Color(180, 37, 196));
    protected static final DrawableColor PROGRESS_COLOR = DrawableColor.of(new Color(255, 0, 0));
    protected static final DrawableColor PREVIEW_COLOR_NORMAL = DrawableColor.of(new Color(33, 176, 58));
    protected static final DrawableColor RECORDING_COLOR = DrawableColor.of(new Color(196, 37, 37));
    protected static final DrawableColor RECORDING_PAUSED_COLOR = DrawableColor.of(new Color(219, 108, 4));
    protected static final DrawableColor OFFSET_MODE_CROSSHAIR_COLOR = DrawableColor.of(new Color(219, 108, 4));
    protected static final int TIMELINE_HEIGHT = 50;
    protected static final int TIMELINE_Y_PADDING = 20;
    protected static final int KEYFRAME_LINE_WIDTH = 2;
    protected static final int KEYFRAME_LINE_HEIGHT = 30;
    protected static final int PROGRESS_LINE_WIDTH = 2;
    protected static final int MIN_TIMELINE_DURATION = 1000;
    protected static final int TIMELINE_EXTENSION_STEP = 2000;
    protected static final long TIMELINE_PADDING_DURATION = 2000L;
    protected static final int KEYFRAME_DRAG_CRUMPLE_ZONE = 3;
    protected static final long RECORDING_BLINK_INTERVAL = 600L;
    protected static final int NOTIFICATION_PADDING = 10;
    protected static final Component KEYFRAME_ADDED_TEXT = Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.keyframe_added").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().success_text_color.getColorInt()));
    protected static final Component KEYFRAME_DELETED_TEXT = Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.keyframe_deleted").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
    protected static final Component PLAYING_STARTED_TEXT = Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.playing_started").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().success_text_color.getColorInt()));
    protected static final Component PLAYING_STOPPED_TEXT = Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.playing_stopped").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
    protected final AnimationControllerElement controller;
    protected final Consumer<AnimationControllerMetadata> resultCallback;
    protected final List<AnimationKeyframe> workingKeyframes;
    protected final PreviewElement previewElement;
    protected final PreviewEditorElement previewEditorElement;
    protected boolean isDraggingProgress = false;
    protected boolean isPlaying = false;
    protected long playStartTime = -1L;
    protected long currentPlayOrRecordPosition = 0L;
    protected final List<AnimationKeyframe> selectedKeyframes = new ArrayList<AnimationKeyframe>();
    protected int draggingKeyframeIndex = -1;
    protected AnimationKeyframe lastCtrlClickedFrameForDeselect = null;
    protected boolean framesGotMoved = false;
    protected int timelineX;
    protected int timelineWidth;
    protected int timelineY;
    protected long timelineDuration = 1000L;
    protected int initialDragClickX = 0;
    protected boolean hasMovedFromClickPosition = false;
    protected boolean isRecording = false;
    protected boolean isRecordingPaused = false;
    protected long recordStartTime = -1L;
    protected double recordingSpeed = 1.0;
    protected double cachedRecordingSpeed;
    protected final Map<Integer, Integer> cachedWidgetRowCurrentX = new HashMap<Integer, Integer>();
    protected long lastRecordingBlinkTime = -1L;
    protected boolean recordingBlinkState = true;
    protected final List<Notification> activeNotifications = new ArrayList<Notification>();
    protected boolean isShowingSmoothingInput = false;
    protected String lastSmoothingInputValue = null;
    protected boolean isShowingTimestampInput = false;
    protected boolean isOffsetMode = false;
    protected final Stack<List<AnimationKeyframe>> undoStack = new Stack();
    protected final Stack<List<AnimationKeyframe>> redoStack = new Stack();
    protected CycleButton<ElementAnchorPoint> anchorButton;
    protected CycleButton<CommonCycles.CycleEnabledDisabled> stickyButton;
    protected ExtendedButton undoButton;
    protected ExtendedButton redoButton;
    protected ExtendedButton deleteKeyframeButton;
    protected ExtendedButton playButton;
    protected ExtendedButton startStopRecordingButton;
    protected RangeSlider recordingSpeedSlider;
    protected ExtendedButton smoothingButton;
    protected ExtendedEditBox smoothingDistanceInput;
    protected ExtendedEditBox timestampInput;
    protected int lastGuiScaleCorrectionWidth = 0;
    protected int lastGuiScaleCorrectionHeight = 0;

    public KeyframeManagerScreen(AnimationControllerElement controller, Consumer<AnimationControllerMetadata> resultCallback) {
        super((Component)Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager"));
        this.controller = controller;
        this.isOffsetMode = this.controller.offsetMode;
        this.resultCallback = resultCallback;
        this.workingKeyframes = new ArrayList<AnimationKeyframe>(controller.keyframes.stream().map(AnimationKeyframe::clone).toList());
        this.workingKeyframes.sort(Comparator.comparingLong(k -> k.timestamp));
        for (AnimationKeyframe kf : this.workingKeyframes) {
            this.timelineDuration = Math.max(this.timelineDuration, kf.timestamp);
        }
        this.timelineDuration += 2000L;
        this.previewElement = new PreviewElement(controller.builder);
        this.previewElement.baseWidth = 50;
        this.previewElement.baseHeight = 50;
        this.previewElement.posOffsetX = 0;
        this.previewElement.posOffsetY = 0;
        this.previewElement.stayOnScreen = false;
        this.previewElement.stickyAnchor = true;
        this.previewElement.anchorPoint = ElementAnchorPoints.MID_CENTERED;
        if (!this.workingKeyframes.isEmpty()) {
            this.applyKeyframeValuesToElement(this.workingKeyframes.get(0), this.previewElement);
        }
        this.previewEditorElement = new PreviewEditorElement(this.previewElement, new LayoutEditorScreen(Layout.buildUniversal()));
        this.saveState();
    }

    protected void m_7856_() {
        boolean tooFarRight;
        this.timelineX = 50;
        this.timelineWidth = this.f_96543_ - 100;
        this.timelineY = this.f_96544_ - 50 - 20;
        this.cachedWidgetRowCurrentX.clear();
        int buttonBaseWidth = 60;
        ExtendedButton cancelButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(10, 10, buttonBaseWidth, 20, (Component)Component.m_237115_((String)"gui.cancel"), button -> this.resultCallback.accept(null)));
        this.m_142416_((GuiEventListener)cancelButton);
        ExtendedButton doneButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(80, 10, buttonBaseWidth, 20, (Component)Component.m_237115_((String)"gui.done"), button -> this.resultCallback.accept(new AnimationControllerMetadata(this.workingKeyframes, this.isOffsetMode))));
        this.m_142416_((GuiEventListener)doneButton);
        this.playButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (Component)Component.m_237119_(), button -> this.togglePlayback()));
        this.playButton.setLabelSupplier(consumes -> Component.m_237115_((String)(this.isPlaying ? "fancymenu.elements.animation_controller.keyframe_manager.pause" : "fancymenu.elements.animation_controller.keyframe_manager.play")));
        this.playButton.setIsActiveSupplier(consumes -> !this.isRecording);
        this.addBottomWidget(1, 0, this.playButton);
        this.startStopRecordingButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (Component)Component.m_237119_(), button -> this.toggleRecording()));
        this.startStopRecordingButton.setLabelSupplier(consumes -> Component.m_237115_((String)(this.isRecording ? "fancymenu.elements.animation_controller.keyframe_manager.stop_recording" : "fancymenu.elements.animation_controller.keyframe_manager.start_recording")));
        this.startStopRecordingButton.setIsActiveSupplier(consumes -> !this.isPlaying);
        this.addBottomWidget(1, 0, this.startStopRecordingButton);
        this.recordingSpeedSlider = new RangeSlider(0, 0, buttonBaseWidth + 60, 20, (Component)Component.m_237119_(), 0.0, 100.0, this.recordingSpeed * 100.0);
        this.recordingSpeedSlider.setShowAsInteger(true);
        this.recordingSpeedSlider.setLabelSupplier(slider -> {
            String speedText = slider.getValueDisplayText() + "%";
            return Component.m_237110_((String)"fancymenu.elements.animation_controller.keyframe_manager.recording_speed", (Object[])new Object[]{speedText});
        });
        this.recordingSpeedSlider.setSliderValueUpdateListener((slider, valueDisplayText, value) -> this.setRecordingSpeed(value));
        this.recordingSpeedSlider.setFocusable(true);
        this.recordingSpeedSlider.setNavigatable(true);
        UIBase.applyDefaultWidgetSkinTo(this.recordingSpeedSlider);
        this.addBottomWidget(1, 0, this.recordingSpeedSlider);
        ExtendedButton addKeyframeButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (Component)Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.add_keyframe"), button -> this.addKeyframeAtProgress()));
        addKeyframeButton.setIsActiveSupplier(consumes -> this.isRecording && this.selectedKeyframes.isEmpty());
        this.addBottomWidget(1, 0, addKeyframeButton);
        this.deleteKeyframeButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (Component)Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.delete_keyframe"), button -> this.deleteSelectedKeyframes()));
        this.deleteKeyframeButton.setIsActiveSupplier(consumes -> !this.selectedKeyframes.isEmpty());
        this.addBottomWidget(1, 0, this.deleteKeyframeButton);
        this.smoothingButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (Component)Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.smoothing"), button -> this.toggleSmoothingInput()));
        this.smoothingButton.setIsActiveSupplier(consumes -> !this.isPlaying && !this.isRecording && this.selectedKeyframes.size() > 1 && !this.isShowingTimestampInput);
        this.smoothingButton.setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.keyframe_manager.smoothing.desc", new String[0])));
        this.addBottomWidget(1, 0, this.smoothingButton);
        CycleButton<CommonCycles.CycleEnabledDisabled> offsetModeButton = new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, buttonBaseWidth, 0, CommonCycles.cycleEnabledDisabled("fancymenu.elements.animation_controller.keyframe_manager.offset_mode", this.isOffsetMode), (value, button) -> this.setOffsetMode(value.getAsBoolean()));
        offsetModeButton.setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.keyframe_manager.offset_mode.desc", new String[0])));
        this.addBottomWidget(1, 0, (AbstractWidget)offsetModeButton);
        this.undoButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (Component)Component.m_237115_((String)"fancymenu.editor.edit.undo"), button -> this.undo()));
        this.undoButton.setIsActiveSupplier(consumes -> !this.undoStack.isEmpty() && !this.isPlaying);
        this.addBottomWidget(2, 0, this.undoButton);
        this.redoButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (Component)Component.m_237115_((String)"fancymenu.editor.edit.redo"), button -> this.redo()));
        this.redoButton.setIsActiveSupplier(consumes -> !this.redoStack.isEmpty() && !this.isPlaying);
        this.addBottomWidget(2, 0, this.redoButton);
        List<ElementAnchorPoint> anchorPoints = ElementAnchorPoints.getAnchorPoints();
        anchorPoints.remove(ElementAnchorPoints.ELEMENT);
        anchorPoints.remove(ElementAnchorPoints.VANILLA);
        this.anchorButton = new CycleButton<ElementAnchorPoint>(0, 0, buttonBaseWidth + 105, 0, CommonCycles.cycle("fancymenu.elements.animation_controller.keyframe_manager.anchor_point_cycle", anchorPoints, ElementAnchorPoints.TOP_LEFT).setValueNameSupplier(ElementAnchorPoint::getName).setValueComponentStyleSupplier(consumes -> Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt())), (value, button) -> this.setAnchorPoint((ElementAnchorPoint)value));
        this.anchorButton.setIsActiveSupplier(consumes -> (this.selectedKeyframes.size() == 1 || this.isRecording) && !this.isOffsetMode);
        this.addBottomWidget(2, 0, (AbstractWidget)this.anchorButton);
        this.stickyButton = new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, buttonBaseWidth + 65, 0, CommonCycles.cycleEnabledDisabled("fancymenu.elements.animation_controller.keyframe_manager.sticky"), (value, button) -> this.setStickyAnchor(value.getAsBoolean()));
        this.stickyButton.setIsActiveSupplier(consumes -> (this.selectedKeyframes.size() == 1 || this.isRecording) && !this.isOffsetMode);
        this.addBottomWidget(2, 0, (AbstractWidget)this.stickyButton);
        ExtendedButton timestampButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (Component)Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.timestamp_edit"), button -> this.toggleTimestampInput()));
        timestampButton.setIsActiveSupplier(consumes -> !this.isPlaying && !this.isRecording && this.selectedKeyframes.size() == 1 && !this.isShowingSmoothingInput);
        timestampButton.setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.keyframe_manager.timestamp_edit.desc", new String[0])));
        this.addBottomWidget(2, 0, timestampButton);
        CycleButton<CommonCycles.CycleEnabledDisabled> previewMovingButton = new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, buttonBaseWidth + 65, 0, CommonCycles.cycleEnabledDisabled("fancymenu.elements.animation_controller.keyframe_manager.move_preview_with_arrow_keys", FancyMenu.getOptions().arrowKeysMovePreview.getValue()), (value, button) -> FancyMenu.getOptions().arrowKeysMovePreview.setValue(value.getAsBoolean()));
        previewMovingButton.setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.keyframe_manager.move_preview_with_arrow_keys.desc", new String[0])));
        this.addBottomWidget(2, 0, (AbstractWidget)previewMovingButton);
        this.smoothingDistanceInput = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ / 2 - 50, this.stickyButton.m_252907_() - 40, 100, 20, (Component)Component.m_237119_()){

            @Override
            public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                MutableComponent c = Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.smoothing.input");
                int cW = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)c);
                Font font = Minecraft.m_91087_().f_91062_;
                int n = this.m_252754_() + this.m_5711_() / 2 - cW / 2;
                int n2 = this.m_252907_();
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                graphics.m_280614_(font, (Component)c, n, n2 - 9 - 5, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
                super.m_87963_(graphics, mouseX, mouseY, partial);
            }
        };
        this.smoothingDistanceInput.setCharacterFilter(CharacterFilter.buildIntegerFiler());
        this.smoothingDistanceInput.setIsVisibleSupplier(consumes -> this.isShowingSmoothingInput);
        this.smoothingDistanceInput.m_94199_(6);
        UIBase.applyDefaultWidgetSkinTo(this.smoothingDistanceInput);
        this.m_142416_((GuiEventListener)this.smoothingDistanceInput);
        this.timestampInput = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ / 2 - 50, this.stickyButton.m_252907_() - 40, 100, 20, (Component)Component.m_237119_()){

            @Override
            public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                MutableComponent c = Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.timestamp_edit.input");
                int cW = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)c);
                Font font = Minecraft.m_91087_().f_91062_;
                int n = this.m_252754_() + this.m_5711_() / 2 - cW / 2;
                int n2 = this.m_252907_();
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                graphics.m_280614_(font, (Component)c, n, n2 - 9 - 5, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
                super.m_87963_(graphics, mouseX, mouseY, partial);
            }
        };
        this.timestampInput.setCharacterFilter(CharacterFilter.buildIntegerFiler());
        this.timestampInput.setIsVisibleSupplier(consumes -> this.isShowingTimestampInput);
        this.timestampInput.m_94199_(20);
        UIBase.applyDefaultWidgetSkinTo(this.timestampInput);
        this.m_142416_((GuiEventListener)this.timestampInput);
        if (!this.isPlaying && !this.isRecording) {
            this.updateTimelineDurationToMaxTimestamp();
        }
        CycleButton<CommonCycles.CycleEnabledDisabled> farRightWidget = previewMovingButton;
        Window window = Minecraft.m_91087_().m_91268_();
        boolean resized = window.m_85443_() != this.lastGuiScaleCorrectionWidth || window.m_85444_() != this.lastGuiScaleCorrectionHeight;
        this.lastGuiScaleCorrectionWidth = window.m_85443_();
        this.lastGuiScaleCorrectionHeight = window.m_85444_();
        boolean bl = tooFarRight = farRightWidget.m_252754_() + farRightWidget.m_5711_() >= this.f_96543_ - 100;
        if (tooFarRight && window.m_85449_() > 1.0) {
            double newScale = window.m_85449_();
            if ((newScale -= 1.0) < 1.0) {
                newScale = 1.0;
            }
            window.m_85378_(newScale);
            this.m_6574_(Minecraft.m_91087_(), window.m_85445_(), window.m_85446_());
        } else if (!tooFarRight && resized) {
            RenderingUtils.resetGuiScale();
            this.m_6574_(Minecraft.m_91087_(), window.m_85445_(), window.m_85446_());
        }
    }

    protected <T extends AbstractWidget> T addBottomWidget(int row, int spacingAfterButtonOffset, @NotNull T widget) {
        if (row < 1) {
            row = 1;
        }
        if (!this.cachedWidgetRowCurrentX.containsKey(row)) {
            this.cachedWidgetRowCurrentX.put(row, this.timelineX);
        }
        int currentX = this.cachedWidgetRowCurrentX.get(row);
        int y = this.timelineY - 25 - 25 * (row - 1);
        int buttonSpacing = 5 + spacingAfterButtonOffset;
        widget.m_252865_(currentX);
        widget.m_253211_(y);
        ((IMixinAbstractWidget)widget).setHeightFancyMenu(20);
        int labelWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)widget.m_6035_());
        if (labelWidth + 10 > widget.m_5711_()) {
            widget.m_93674_(labelWidth + 10);
        }
        UIBase.applyDefaultWidgetSkinTo(widget);
        this.m_142416_((GuiEventListener)widget);
        int newCurrentX = currentX + widget.m_5711_() + buttonSpacing;
        this.cachedWidgetRowCurrentX.put(row, newCurrentX);
        return widget;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.isShowingSmoothingInput) {
            if (!this.smoothingDistanceInput.m_93696_()) {
                this.smoothingDistanceInput.setFocusable(true);
                this.m_7522_((GuiEventListener)this.smoothingDistanceInput);
            }
        } else if (this.smoothingDistanceInput == this.m_7222_()) {
            ((IMixinScreen)((Object)this)).invoke_clearFocus_FancyMenu();
        }
        if (this.isShowingTimestampInput && this.selectedKeyframes.size() != 1) {
            this.isShowingTimestampInput = false;
        }
        if (this.isShowingTimestampInput) {
            if (!this.timestampInput.m_93696_()) {
                this.timestampInput.setFocusable(true);
                this.m_7522_((GuiEventListener)this.timestampInput);
            }
        } else if (this.timestampInput == this.m_7222_()) {
            ((IMixinScreen)((Object)this)).invoke_clearFocus_FancyMenu();
        }
        long actualEndTime = this.timelineDuration - 2000L;
        if (this.isRecording && !this.isPlaying && !this.isRecordingPaused) {
            long now = System.currentTimeMillis();
            long actualElapsed = now - this.recordStartTime;
            this.currentPlayOrRecordPosition = (long)((double)actualElapsed * this.recordingSpeed);
            long trimmedActualDuration = this.timelineDuration - 2000L - 2000L;
            if (this.currentPlayOrRecordPosition >= trimmedActualDuration) {
                this.updateTimelineDuration(this.timelineDuration - 2000L + 2000L);
                actualEndTime = this.timelineDuration - 2000L;
            }
        }
        if (this.isPlaying && !this.isRecording) {
            this.currentPlayOrRecordPosition = System.currentTimeMillis() - this.playStartTime;
            if (this.currentPlayOrRecordPosition > this.timelineDuration) {
                this.isPlaying = false;
                this.currentPlayOrRecordPosition = 0L;
            }
        }
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        LayoutEditorScreen.renderGrid(graphics, this.f_96543_, this.f_96544_);
        this.renderTimelineBackground(graphics, actualEndTime);
        this.renderKeyframeLines(graphics, mouseX, mouseY, partial, actualEndTime);
        this.renderProgressLine(graphics, mouseX, mouseY, partial, actualEndTime);
        this.tickAnimation();
        this.renderPreview(graphics, mouseX, mouseY, partial);
        this.renderTimeText(graphics, actualEndTime);
        this.renderKeyframeInfo(graphics, mouseX, mouseY, partial);
        this.renderRecordingIndicator(graphics, mouseX, mouseY, partial);
        this.renderOffsetModeCrosshair(graphics);
        this.renderNotifications(graphics, mouseX, mouseY, partial);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    protected void tickAnimation() {
        if (this.isRecording && !this.isRecordingPaused) {
            return;
        }
        AnimationKeyframe currentFrame = null;
        AnimationKeyframe nextFrame = null;
        for (int i = 0; i < this.workingKeyframes.size() - 1; ++i) {
            AnimationKeyframe k1 = this.workingKeyframes.get(i);
            AnimationKeyframe k2 = this.workingKeyframes.get(i + 1);
            if (this.currentPlayOrRecordPosition < k1.timestamp || this.currentPlayOrRecordPosition >= k2.timestamp) continue;
            currentFrame = k1;
            nextFrame = k2;
            break;
        }
        if ((this.isPlaying || this.isDraggingProgress) && currentFrame != null && nextFrame != null) {
            this.selectKeyframeClearOldSelection(null);
            float progress = (float)(this.currentPlayOrRecordPosition - currentFrame.timestamp) / (float)(nextFrame.timestamp - currentFrame.timestamp);
            if (this.isOffsetMode) {
                this.previewElement.animatedOffsetX = (int)this.lerp(currentFrame.posOffsetX, nextFrame.posOffsetX, progress);
                this.previewElement.animatedOffsetY = (int)this.lerp(currentFrame.posOffsetY, nextFrame.posOffsetY, progress);
                this.previewElement.posOffsetX = 0;
                this.previewElement.posOffsetY = 0;
            } else {
                this.previewElement.posOffsetX = (int)this.lerp(currentFrame.posOffsetX, nextFrame.posOffsetX, progress);
                this.previewElement.posOffsetY = (int)this.lerp(currentFrame.posOffsetY, nextFrame.posOffsetY, progress);
            }
            this.previewElement.baseWidth = (int)this.lerp(currentFrame.baseWidth, nextFrame.baseWidth, progress);
            this.previewElement.baseHeight = (int)this.lerp(currentFrame.baseHeight, nextFrame.baseHeight, progress);
            this.previewElement.anchorPoint = this.isOffsetMode ? ElementAnchorPoints.MID_CENTERED : nextFrame.anchorPoint;
            this.previewElement.stickyAnchor = nextFrame.stickyAnchor;
        }
    }

    protected void renderOffsetModeCrosshair(@NotNull GuiGraphics graphics) {
        if (!this.isOffsetMode) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        graphics.m_280509_(centerX - 10, centerY - 1, centerX + 10, centerY + 1, OFFSET_MODE_CROSSHAIR_COLOR.getColorInt());
        graphics.m_280509_(centerX - 1, centerY - 10, centerX + 1, centerY + 10, OFFSET_MODE_CROSSHAIR_COLOR.getColorInt());
    }

    protected void renderTimelineBackground(@NotNull GuiGraphics graphics, long actualEndTime) {
        float usableWidth = (float)this.timelineWidth * ((float)Math.max(actualEndTime + 2000L, 1000L) / (float)this.timelineDuration);
        graphics.m_285944_(RenderType.m_285907_(), this.timelineX, this.timelineY, this.timelineX + (int)((float)actualEndTime / (float)this.timelineDuration * usableWidth), this.timelineY + 50, TIMELINE_COLOR.getColorInt());
        int paddingStartX = this.timelineX + (int)((float)actualEndTime / (float)this.timelineDuration * usableWidth);
        graphics.m_285944_(RenderType.m_285907_(), paddingStartX, this.timelineY, this.timelineX + (int)usableWidth, this.timelineY + 50, TIMELINE_PADDING_COLOR.getColorInt());
    }

    protected void renderKeyframeLines(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial, long actualDuration) {
        for (int i = 0; i < this.workingKeyframes.size(); ++i) {
            long maxRightPosition;
            AnimationKeyframe keyframe = this.workingKeyframes.get(i);
            float progress = (float)keyframe.timestamp / (float)this.timelineDuration;
            int lineX = this.timelineX + (int)((float)this.timelineWidth * progress);
            DrawableColor color = this.selectedKeyframes.contains(keyframe) ? KEYFRAME_COLOR_SELECTED : KEYFRAME_COLOR;
            graphics.m_285944_(RenderType.m_285907_(), lineX - 1, this.timelineY + 10, lineX + 1, this.timelineY + 40, color.getColorInt());
            if (this.draggingKeyframeIndex != i) continue;
            int dragDeltaX = mouseX - this.initialDragClickX;
            if (!this.hasMovedFromClickPosition) {
                boolean bl = this.hasMovedFromClickPosition = Math.abs(dragDeltaX) >= 3;
                if (!this.hasMovedFromClickPosition) continue;
                this.framesGotMoved = true;
                this.saveState();
            }
            float newProgress = (float)(mouseX - this.timelineX) / (float)this.timelineWidth;
            long newDuration = this.timelineDuration;
            if (!this.isRecording && mouseX > this.timelineX + this.timelineWidth - 10) {
                newDuration = this.timelineDuration + 2000L;
                newProgress = (float)(mouseX - this.timelineX) / (float)this.timelineWidth;
            }
            newProgress = Math.max(0.0f, Math.min(1.0f, newProgress));
            long timeDelta = (long)((float)newDuration * newProgress) - keyframe.timestamp;
            long minSelectedTimestamp = Long.MAX_VALUE;
            long maxSelectedTimestamp = Long.MIN_VALUE;
            long deltaToLastFrame = 0L;
            for (AnimationKeyframe selectedFrame : this.selectedKeyframes) {
                minSelectedTimestamp = Math.min(minSelectedTimestamp, selectedFrame.timestamp);
                maxSelectedTimestamp = Math.max(maxSelectedTimestamp, selectedFrame.timestamp);
                if (selectedFrame.timestamp <= keyframe.timestamp) continue;
                deltaToLastFrame = Math.max(deltaToLastFrame, selectedFrame.timestamp - keyframe.timestamp);
            }
            long maxLeftShift = -minSelectedTimestamp;
            if (timeDelta < maxLeftShift) {
                timeDelta = maxLeftShift;
            }
            if (this.isRecording && keyframe.timestamp + timeDelta > (maxRightPosition = actualDuration - deltaToLastFrame)) {
                timeDelta = maxRightPosition - keyframe.timestamp;
            }
            for (AnimationKeyframe selectedFrame : this.selectedKeyframes) {
                long newTimestamp = selectedFrame.timestamp + timeDelta;
                newTimestamp = Math.max(0L, newTimestamp);
                if (this.isRecording) {
                    newTimestamp = Math.min(newTimestamp, actualDuration);
                }
                selectedFrame.timestamp = newTimestamp;
            }
            this.updateTimelineDurationToMaxTimestamp();
        }
    }

    protected void renderPreview(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (!this.isPlaying && (this.selectedKeyframes.size() == 1 || this.isRecording)) {
            this.previewEditorElement.m_88315_(graphics, mouseX, mouseY, partial);
        } else {
            this.previewEditorElement.renderPreviewBody(graphics, mouseX, mouseY, partial);
        }
    }

    protected void renderProgressLine(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial, long actualDuration) {
        float playProgress = (float)this.currentPlayOrRecordPosition / (float)this.timelineDuration;
        int progressX = this.timelineX + (int)((float)this.timelineWidth * playProgress);
        if (this.isDraggingProgress && (!this.isRecording || this.isRecordingPaused)) {
            float newProgress = (float)(mouseX - this.timelineX) / (float)this.timelineWidth;
            if (this.isRecording) {
                float maxProgress = (float)actualDuration / (float)this.timelineDuration;
                newProgress = Math.max(0.0f, Math.min(maxProgress, newProgress));
            } else {
                newProgress = Math.max(0.0f, Math.min(1.0f, newProgress));
            }
            this.currentPlayOrRecordPosition = (long)((float)this.timelineDuration * newProgress);
            if (this.isPlaying) {
                this.playStartTime = System.currentTimeMillis() - this.currentPlayOrRecordPosition;
            }
            progressX = this.timelineX + (int)((float)this.timelineWidth * newProgress);
        }
        graphics.m_285944_(RenderType.m_285907_(), progressX - 1, this.timelineY, progressX + 1, this.timelineY + 50, PROGRESS_COLOR.getColorIntWithAlpha(0.7f));
    }

    protected void renderTimeText(@NotNull GuiGraphics graphics, long actualEndTime) {
        String currentTimeStr = this.formatTime(this.currentPlayOrRecordPosition);
        String totalTimeStr = this.formatTime(actualEndTime);
        int currentTimeColor = this.currentPlayOrRecordPosition > actualEndTime ? UIBase.getUIColorTheme().warning_text_color.getColorInt() : UIBase.getUIColorTheme().generic_text_base_color.getColorInt();
        MutableComponent currentTimeComp = Component.m_237113_((String)currentTimeStr).m_6270_(Style.f_131099_.m_178520_(currentTimeColor));
        MutableComponent totalTimeComp = Component.m_237113_((String)totalTimeStr);
        MutableComponent baseComp = Component.m_237110_((String)"fancymenu.elements.animation_controller.keyframe_manager.time", (Object[])new Object[]{currentTimeComp, totalTimeComp});
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)baseComp, this.timelineX, this.timelineY + 50 + 5, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
    }

    protected void renderKeyframeInfo(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.selectedKeyframes.size() == 1) {
            AnimationKeyframe selectedKeyframe = this.selectedKeyframes.get(0);
            String yes = I18n.m_118938_((String)"fancymenu.elements.animation_controller.keyframe_manager.keyframe_info.yes", (Object[])new Object[0]);
            String no = I18n.m_118938_((String)"fancymenu.elements.animation_controller.keyframe_manager.keyframe_info.no", (Object[])new Object[0]);
            Component[] lines = LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.keyframe_manager.keyframe_info", this.formatTime(selectedKeyframe.timestamp), "" + selectedKeyframe.posOffsetX, "" + selectedKeyframe.posOffsetY, "" + selectedKeyframe.baseWidth, "" + selectedKeyframe.baseHeight, selectedKeyframe.anchorPoint.getName(), selectedKeyframe.stickyAnchor ? yes : no);
            int yOffset = 40;
            for (Component line : lines) {
                graphics.m_280614_(Minecraft.m_91087_().f_91062_, line, 10, yOffset, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
                yOffset += 10;
            }
        }
    }

    protected void renderRecordingIndicator(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.isRecording) {
            int n;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRecordingBlinkTime > 600L) {
                this.recordingBlinkState = !this.recordingBlinkState;
                this.lastRecordingBlinkTime = currentTime;
            }
            MutableComponent recordingText = Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.recording").m_6270_(Style.f_131099_.m_178520_(RECORDING_COLOR.getColorInt()));
            MutableComponent manualModeText = Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.recording_speed.manual_mode").m_6270_(Style.f_131099_.m_178520_(RECORDING_PAUSED_COLOR.getColorInt()));
            int recordingTextWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)recordingText);
            int manualModeTextWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)manualModeText);
            int rectSize = 20;
            int padding = 5;
            int totalWidthRecordingText = recordingTextWidth + padding + rectSize;
            int totalWidthManualModeText = manualModeTextWidth + padding + rectSize;
            int xOffset = 10;
            int yOffset = 10;
            int recordingTextX = this.f_96543_ - totalWidthRecordingText - xOffset;
            int manualModeTextX = this.f_96543_ - totalWidthManualModeText - xOffset;
            if (!this.isRecordingPaused) {
                int n2 = rectSize / 2;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                n = n2 - 9 / 2;
            } else {
                n = 0;
            }
            int recordingTextOffsetY = n;
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)recordingText, recordingTextX, yOffset + recordingTextOffsetY, -1, false);
            if (this.isRecordingPaused) {
                Font font = Minecraft.m_91087_().f_91062_;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                graphics.m_280614_(font, (Component)manualModeText, manualModeTextX, yOffset + rectSize - 9, -1, false);
            }
            if (this.recordingBlinkState) {
                int rectX = recordingTextX + recordingTextWidth + padding;
                graphics.m_285944_(RenderType.m_285907_(), rectX, yOffset, rectX + rectSize, yOffset + rectSize, RECORDING_COLOR.getColorInt());
            }
        }
    }

    protected void renderNotifications(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        Iterator<Notification> iterator = this.activeNotifications.iterator();
        int notificationYOffset = 10;
        if (this.isRecording) {
            notificationYOffset += 30;
        }
        while (iterator.hasNext()) {
            Notification notification = iterator.next();
            if (notification.isExpired()) {
                iterator.remove();
                continue;
            }
            notification.updateOpacity();
            int textColor = UIBase.getUIColorTheme().generic_text_base_color.getColorIntWithAlpha(notification.opacity);
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, notification.message, this.f_96543_ - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)notification.message) - 10, notificationYOffset, textColor, false);
            notificationYOffset += notification.getHeight();
        }
    }

    protected void updateTimelineDurationToMaxTimestamp() {
        if (this.isRecording) {
            return;
        }
        long maxTimestamp = 0L;
        for (AnimationKeyframe kf : this.workingKeyframes) {
            maxTimestamp = Math.max(maxTimestamp, kf.timestamp);
        }
        this.updateTimelineDuration(maxTimestamp);
    }

    protected void updateTimelineDuration(long newDurationWithoutPadding) {
        long newDuration = newDurationWithoutPadding + 2000L;
        this.timelineDuration = Math.max(1000L, newDuration);
    }

    protected String formatTime(long milliseconds) {
        if (this.timelineDuration < 2000L) {
            return milliseconds + "ms";
        }
        return String.format("%.1fs", Float.valueOf((float)milliseconds / 1000.0f));
    }

    public void m_280273_(GuiGraphics $$0) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.lastCtrlClickedFrameForDeselect = null;
        this.framesGotMoved = false;
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isShowingSmoothingInput && !this.smoothingDistanceInput.m_5953_(mouseX, mouseY)) {
            this.lastSmoothingInputValue = this.smoothingDistanceInput.m_94155_();
            this.isShowingSmoothingInput = false;
        }
        if (this.isShowingTimestampInput && !this.timestampInput.m_5953_(mouseX, mouseY)) {
            this.isShowingTimestampInput = false;
        }
        if (this.previewEditorElement.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isOverProgressLine((int)mouseX, (int)mouseY) && (!this.isRecording || this.isRecordingPaused)) {
            this.isDraggingProgress = true;
            return true;
        }
        if (this.isOverProgressLine((int)mouseX, (int)mouseY) && this.isRecording && !this.isRecordingPaused) {
            this.displayNotification((Component)Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.pause_recording_to_drag_progress").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt())), 6000L);
            return true;
        }
        int clickedIndex = this.getKeyframeIndexAtPosition((int)mouseX, (int)mouseY);
        if (!Screen.m_96637_() && this.isInTimelineArea((int)mouseX, (int)mouseY) && clickedIndex == -1) {
            this.selectKeyframeClearOldSelection(null);
            return true;
        }
        if (this.isRecording && !this.isRecordingPaused && clickedIndex >= 0) {
            this.displayNotification((Component)Component.m_237115_((String)"fancymenu.elements.animation_controller.keyframe_manager.pause_recording_to_edit_keyframe").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt())), 6000L);
            return true;
        }
        if (clickedIndex >= 0) {
            this.initialDragClickX = (int)mouseX;
            this.hasMovedFromClickPosition = false;
            this.draggingKeyframeIndex = clickedIndex;
            AnimationKeyframe keyframe = this.workingKeyframes.get(this.draggingKeyframeIndex);
            if (Screen.m_96637_() && this.selectedKeyframes.contains(keyframe)) {
                this.lastCtrlClickedFrameForDeselect = keyframe;
            } else {
                this.selectKeyframe(this.workingKeyframes.get(clickedIndex), Screen.m_96637_());
            }
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isDraggingProgress = false;
        this.draggingKeyframeIndex = -1;
        this.hasMovedFromClickPosition = false;
        boolean previewGotResized = this.previewEditorElement.recentlyResized;
        boolean previewGotMoved = this.previewEditorElement.recentlyMovedByDragging;
        this.previewEditorElement.m_6348_(mouseX, mouseY, button);
        if (this.previewEditorElement.isSelected() && (previewGotResized || previewGotMoved) && this.selectedKeyframes.size() == 1 && (!this.isRecording || this.isRecordingPaused) && !this.isPlaying) {
            this.saveState();
            this.applyElementValuesToKeyframe(this.previewElement, this.selectedKeyframes.get(0));
        }
        if (this.lastCtrlClickedFrameForDeselect != null && !this.framesGotMoved) {
            if (this.selectedKeyframes.size() > 1) {
                this.selectedKeyframes.remove(this.lastCtrlClickedFrameForDeselect);
                if (this.selectedKeyframes.size() == 1) {
                    AnimationKeyframe lastSelected = this.selectedKeyframes.get(0);
                    this.selectKeyframeClearOldSelection(null);
                    this.selectKeyframeClearOldSelection(lastSelected);
                }
            } else {
                this.selectKeyframeClearOldSelection(null);
            }
        }
        this.lastCtrlClickedFrameForDeselect = null;
        this.framesGotMoved = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        String key = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
        if (key == null) {
            key = "";
        }
        key = key.toLowerCase();
        if (Screen.m_96637_()) {
            if (key.equals("z")) {
                this.undo();
                return true;
            }
            if (key.equals("y")) {
                this.redo();
                return true;
            }
        }
        if (this.isShowingSmoothingInput && this.smoothingDistanceInput.m_93696_()) {
            this.lastSmoothingInputValue = this.smoothingDistanceInput.m_94155_();
            if (keyCode == 257) {
                this.applySmoothingDistance();
                return true;
            }
            if (keyCode == 256) {
                this.isShowingSmoothingInput = false;
                return true;
            }
        }
        if (this.isShowingTimestampInput && this.timestampInput.m_93696_()) {
            if (keyCode == 257) {
                this.saveState();
                if (this.selectedKeyframes.size() == 1 && MathUtils.isLong((String)this.timestampInput.m_94155_())) {
                    this.selectedKeyframes.get((int)0).timestamp = Long.parseLong(this.timestampInput.m_94155_());
                }
                this.isShowingTimestampInput = false;
                this.updateTimelineDurationToMaxTimestamp();
                return true;
            }
            if (keyCode == 256) {
                this.isShowingTimestampInput = false;
                return true;
            }
        }
        if ((!this.isRecording || this.isRecordingPaused) && Screen.m_96637_() && keyCode == 65) {
            this.selectKeyframeClearOldSelection(null);
            this.workingKeyframes.forEach(keyframe -> this.selectKeyframe((AnimationKeyframe)keyframe, true));
        }
        if (!this.selectedKeyframes.isEmpty() && !FancyMenu.getOptions().arrowKeysMovePreview.getValue().booleanValue()) {
            if (keyCode == 263 || keyCode == 262) {
                long timeShift;
                this.saveState();
                long minSelectedTimestamp = Long.MAX_VALUE;
                long maxSelectedTimestamp = Long.MIN_VALUE;
                for (AnimationKeyframe selectedFrame : this.selectedKeyframes) {
                    minSelectedTimestamp = Math.min(minSelectedTimestamp, selectedFrame.timestamp);
                    maxSelectedTimestamp = Math.max(maxSelectedTimestamp, selectedFrame.timestamp);
                }
                long l = timeShift = keyCode == 263 ? -100L : 100L;
                if (keyCode == 263) {
                    if (minSelectedTimestamp + timeShift < 0L) {
                        timeShift = -minSelectedTimestamp;
                    }
                } else if (maxSelectedTimestamp + timeShift > this.timelineDuration) {
                    timeShift = this.timelineDuration - maxSelectedTimestamp;
                }
                if (timeShift != 0L) {
                    long finalTimeShift = timeShift;
                    this.selectedKeyframes.forEach(selectedKeyframe -> selectedKeyframe.timestamp += finalTimeShift);
                    this.updateTimelineDurationToMaxTimestamp();
                }
                return true;
            }
        } else if (!(!FancyMenu.getOptions().arrowKeysMovePreview.getValue().booleanValue() || this.selectedKeyframes.size() != 1 || this.isRecording && !this.isRecordingPaused || this.isPlaying || keyCode != 263 && keyCode != 262 && keyCode != 265 && keyCode != 264)) {
            this.saveState();
            this.isShowingTimestampInput = false;
            this.isShowingSmoothingInput = false;
            if (keyCode == 263) {
                --this.previewElement.posOffsetX;
            }
            if (keyCode == 262) {
                ++this.previewElement.posOffsetX;
            }
            if (keyCode == 265) {
                --this.previewElement.posOffsetY;
            }
            if (keyCode == 264) {
                ++this.previewElement.posOffsetY;
            }
            this.applyElementValuesToKeyframe(this.previewElement, this.selectedKeyframes.get(0));
            return true;
        }
        if (keyCode == 261 && !this.selectedKeyframes.isEmpty()) {
            this.deleteSelectedKeyframes();
            return true;
        }
        if (keyCode == 75) {
            this.addKeyframeAtProgress();
            return true;
        }
        if (keyCode == 80) {
            this.togglePlayback();
            return true;
        }
        if (keyCode == 82) {
            this.toggleRecording();
            return true;
        }
        if (keyCode == 84) {
            this.togglePauseRecording(true);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return this.previewEditorElement.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    protected void applyElementValuesToKeyframe(@NotNull PreviewElement element, @NotNull AnimationKeyframe keyframe) {
        if (this.isOffsetMode) {
            int screenCenterX = this.f_96543_ / 2;
            int screenCenterY = this.f_96544_ / 2;
            int elementCenterX = element.getAbsoluteX() + element.getAbsoluteWidth() / 2;
            int elementCenterY = element.getAbsoluteY() + element.getAbsoluteHeight() / 2;
            keyframe.posOffsetX = elementCenterX - screenCenterX;
            keyframe.posOffsetY = elementCenterY - screenCenterY;
        } else {
            keyframe.posOffsetX = element.posOffsetX;
            keyframe.posOffsetY = element.posOffsetY;
        }
        keyframe.baseWidth = element.baseWidth;
        keyframe.baseHeight = element.baseHeight;
        keyframe.anchorPoint = this.isOffsetMode ? ElementAnchorPoints.MID_CENTERED : element.anchorPoint;
        keyframe.stickyAnchor = this.isOffsetMode ? true : element.stickyAnchor;
    }

    protected void applyKeyframeValuesToElement(@NotNull AnimationKeyframe keyframe, @NotNull PreviewElement element) {
        if (this.isOffsetMode) {
            element.animatedOffsetX = keyframe.posOffsetX;
            element.animatedOffsetY = keyframe.posOffsetY;
            element.posOffsetX = 0;
            element.posOffsetY = 0;
        } else {
            element.posOffsetX = keyframe.posOffsetX;
            element.posOffsetY = keyframe.posOffsetY;
        }
        element.baseWidth = keyframe.baseWidth;
        element.baseHeight = keyframe.baseHeight;
        element.anchorPoint = this.isOffsetMode ? ElementAnchorPoints.MID_CENTERED : keyframe.anchorPoint;
        element.stickyAnchor = this.isOffsetMode ? true : keyframe.stickyAnchor;
    }

    protected void togglePlayback() {
        if (this.isRecording) {
            return;
        }
        boolean bl = this.isPlaying = !this.isPlaying;
        if (this.isPlaying) {
            this.playStartTime = System.currentTimeMillis() - this.currentPlayOrRecordPosition;
            this.selectKeyframeClearOldSelection(null);
            this.draggingKeyframeIndex = -1;
            this.displayNotification(PLAYING_STARTED_TEXT, 2000L);
        } else {
            this.displayNotification(PLAYING_STOPPED_TEXT, 2000L);
        }
    }

    protected void toggleRecording() {
        if (this.isPlaying) {
            return;
        }
        if (this.isRecording) {
            this.stopRecording();
        } else {
            this.startRecording();
        }
    }

    protected void startRecording() {
        if (this.isPlaying) {
            return;
        }
        this.isRecording = true;
        this.isRecordingPaused = this.recordingSpeed == 0.0;
        this.recordStartTime = System.currentTimeMillis() - (long)((double)this.currentPlayOrRecordPosition / this.recordingSpeed);
        this.selectKeyframeClearOldSelection(null);
        this.draggingKeyframeIndex = -1;
        this.previewEditorElement.setSelected(true);
    }

    protected void stopRecording() {
        this.isRecording = false;
        this.isRecordingPaused = false;
        this.recordStartTime = -1L;
        this.selectKeyframeClearOldSelection(null);
        this.currentPlayOrRecordPosition = 0L;
        this.updateTimelineDurationToMaxTimestamp();
    }

    protected void togglePauseRecording(boolean updateSlider) {
        if (!this.isRecording) {
            return;
        }
        if (!this.isRecordingPaused) {
            this.cachedRecordingSpeed = this.recordingSpeed;
            this.setRecordingSpeed(0.0);
        } else {
            this.setRecordingSpeed(this.cachedRecordingSpeed);
        }
        if (updateSlider && this.recordingSpeedSlider != null) {
            this.recordingSpeedSlider.m_93611_(this.recordingSpeed);
        }
    }

    protected void setRecordingSpeed(double speed) {
        double oldSpeed = this.recordingSpeed;
        double newSpeed = Math.max(0.0, Math.min(1.0, speed));
        if (oldSpeed != newSpeed) {
            if (newSpeed > 0.0) {
                if (this.isRecording) {
                    long now = System.currentTimeMillis();
                    this.recordStartTime = now - (long)((double)this.currentPlayOrRecordPosition / newSpeed);
                }
                this.selectKeyframeClearOldSelection(null);
                this.isRecordingPaused = false;
            } else {
                this.isRecordingPaused = true;
            }
        }
        this.recordingSpeed = newSpeed;
    }

    protected void toggleOffsetMode() {
        this.setOffsetMode(!this.isOffsetMode);
    }

    protected void setOffsetMode(boolean offsetMode) {
        this.isOffsetMode = offsetMode;
        if (offsetMode) {
            this.previewElement.anchorPoint = ElementAnchorPoints.MID_CENTERED;
            this.anchorButton.setSelectedValue(ElementAnchorPoints.MID_CENTERED);
        }
    }

    protected void addKeyframeAtProgress() {
        AnimationKeyframe newKeyframe;
        if (!this.isRecording) {
            return;
        }
        this.saveState();
        if (this.isOffsetMode) {
            int screenCenterX = this.f_96543_ / 2;
            int screenCenterY = this.f_96544_ / 2;
            int elementCenterX = this.previewElement.getAbsoluteX() + this.previewElement.getAbsoluteWidth() / 2;
            int elementCenterY = this.previewElement.getAbsoluteY() + this.previewElement.getAbsoluteHeight() / 2;
            newKeyframe = new AnimationKeyframe(this.currentPlayOrRecordPosition, elementCenterX - screenCenterX, elementCenterY - screenCenterY, this.previewElement.baseWidth, this.previewElement.baseHeight, ElementAnchorPoints.MID_CENTERED, true);
        } else {
            newKeyframe = new AnimationKeyframe(this.currentPlayOrRecordPosition, this.previewElement.posOffsetX, this.previewElement.posOffsetY, this.previewElement.baseWidth, this.previewElement.baseHeight, this.previewElement.anchorPoint, this.previewElement.stickyAnchor);
        }
        this.workingKeyframes.add(newKeyframe);
        this.displayNotification(KEYFRAME_ADDED_TEXT, 2000L);
        this.workingKeyframes.sort(Comparator.comparingLong(k -> k.timestamp));
        this.updateTimelineDurationToMaxTimestamp();
    }

    protected void deleteSelectedKeyframes() {
        if (!this.selectedKeyframes.isEmpty()) {
            this.saveState();
            new ArrayList<AnimationKeyframe>(this.selectedKeyframes).forEach(selectedKeyframe -> {
                this.workingKeyframes.remove(selectedKeyframe);
                this.selectKeyframeClearOldSelection(null);
                this.updateTimelineDurationToMaxTimestamp();
                this.displayNotification(KEYFRAME_DELETED_TEXT, 2000L);
            });
        }
    }

    protected void saveState() {
        this.undoStack.push(new ArrayList<AnimationKeyframe>(this.workingKeyframes.stream().map(AnimationKeyframe::clone).toList()));
        this.redoStack.clear();
    }

    protected void undo() {
        ArrayList selected = new ArrayList();
        this.selectedKeyframes.forEach(keyframe -> selected.add(keyframe.uniqueIdentifier));
        if (this.isPlaying) {
            return;
        }
        if (!this.undoStack.isEmpty()) {
            this.redoStack.push(new ArrayList<AnimationKeyframe>(this.workingKeyframes));
            this.workingKeyframes.clear();
            this.workingKeyframes.addAll((Collection<AnimationKeyframe>)this.undoStack.pop());
            this.selectKeyframeClearOldSelection(null);
            this.updateTimelineDurationToMaxTimestamp();
        }
        if (!selected.isEmpty() && !this.isRecording) {
            selected.forEach(s -> {
                AnimationKeyframe frame = null;
                for (AnimationKeyframe f : this.workingKeyframes) {
                    if (!f.uniqueIdentifier.equals(s)) continue;
                    frame = f;
                    break;
                }
                this.selectKeyframe(frame, true);
            });
        }
    }

    protected void redo() {
        ArrayList selected = new ArrayList();
        this.selectedKeyframes.forEach(keyframe -> selected.add(keyframe.uniqueIdentifier));
        if (this.isPlaying) {
            return;
        }
        if (!this.redoStack.isEmpty()) {
            this.undoStack.push(new ArrayList<AnimationKeyframe>(this.workingKeyframes));
            this.workingKeyframes.clear();
            this.workingKeyframes.addAll((Collection<AnimationKeyframe>)this.redoStack.pop());
            this.selectKeyframeClearOldSelection(null);
            this.updateTimelineDurationToMaxTimestamp();
        }
        if (!selected.isEmpty() && !this.isRecording) {
            selected.forEach(s -> {
                AnimationKeyframe frame = null;
                for (AnimationKeyframe f : this.workingKeyframes) {
                    if (!f.uniqueIdentifier.equals(s)) continue;
                    frame = f;
                    break;
                }
                this.selectKeyframe(frame, true);
            });
        }
    }

    protected void selectKeyframe(@Nullable AnimationKeyframe selected, boolean addToSelection) {
        if (!addToSelection) {
            this.selectedKeyframes.clear();
        }
        if (selected != null) {
            if (!this.selectedKeyframes.contains(selected)) {
                this.selectedKeyframes.add(selected);
                if (this.selectedKeyframes.size() == 1) {
                    this.applyKeyframeValuesToElement(selected, this.previewElement);
                    this.previewEditorElement.setSelected(true);
                    if (this.isPlaying) {
                        this.togglePlayback();
                    }
                    this.anchorButton.setSelectedValue(selected.anchorPoint);
                    this.stickyButton.setSelectedValue(CommonCycles.CycleEnabledDisabled.getByBoolean(selected.stickyAnchor));
                } else if (!this.isRecording) {
                    this.previewEditorElement.setSelected(false);
                }
            }
        } else {
            this.selectedKeyframes.clear();
            if (!this.isRecording) {
                this.previewEditorElement.setSelected(false);
            }
        }
    }

    protected void selectKeyframeClearOldSelection(@Nullable AnimationKeyframe keyframe) {
        this.selectKeyframe(keyframe, false);
    }

    protected void toggleSmoothingInput() {
        this.lastSmoothingInputValue = this.smoothingDistanceInput.m_94155_();
        boolean bl = this.isShowingSmoothingInput = !this.isShowingSmoothingInput;
        if (this.isShowingSmoothingInput) {
            this.smoothingDistanceInput.m_94144_(this.lastSmoothingInputValue);
            if (this.smoothingDistanceInput.m_94155_().isBlank()) {
                this.smoothingDistanceInput.m_94144_("100");
            }
        }
    }

    protected void toggleTimestampInput() {
        if (this.selectedKeyframes.size() != 1) {
            return;
        }
        AnimationKeyframe selected = this.selectedKeyframes.get(0);
        boolean bl = this.isShowingTimestampInput = !this.isShowingTimestampInput;
        if (this.isShowingTimestampInput) {
            this.timestampInput.m_94144_("" + selected.timestamp);
        }
    }

    protected void applySmoothingDistance() {
        String value;
        if (this.selectedKeyframes.size() > 1 && MathUtils.isLong((String)(value = this.smoothingDistanceInput.m_94155_())) && !value.isEmpty()) {
            try {
                long distanceMs = Long.parseLong(value);
                if (distanceMs > 0L) {
                    this.saveState();
                    ArrayList<AnimationKeyframe> sortedFrames = new ArrayList<AnimationKeyframe>(this.selectedKeyframes);
                    sortedFrames.sort(Comparator.comparingLong(k -> k.timestamp));
                    long startTime = ((AnimationKeyframe)sortedFrames.get((int)0)).timestamp;
                    for (int i = 1; i < sortedFrames.size(); ++i) {
                        ((AnimationKeyframe)sortedFrames.get((int)i)).timestamp = startTime + distanceMs * (long)i;
                    }
                    this.updateTimelineDurationToMaxTimestamp();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.isShowingSmoothingInput = false;
    }

    protected boolean isInTimelineArea(int mouseX, int mouseY) {
        return mouseX >= this.timelineX && mouseX <= this.timelineX + this.timelineWidth && mouseY >= this.timelineY && mouseY <= this.timelineY + 50;
    }

    protected boolean isOverProgressLine(int mouseX, int mouseY) {
        long maxTime = this.timelineDuration;
        float progress = (float)this.currentPlayOrRecordPosition / (float)maxTime;
        int progressX = this.timelineX + (int)((float)this.timelineWidth * progress);
        return mouseY >= this.timelineY && mouseY <= this.timelineY + 50 && mouseX >= progressX - 5 && mouseX <= progressX + 5;
    }

    protected int getKeyframeIndexAtPosition(int mouseX, int mouseY) {
        if (mouseY < this.timelineY || mouseY > this.timelineY + 50) {
            return -1;
        }
        for (int i = 0; i < this.workingKeyframes.size(); ++i) {
            AnimationKeyframe keyframe = this.workingKeyframes.get(i);
            float progress = (float)keyframe.timestamp / (float)this.timelineDuration;
            int lineX = (int)((float)this.timelineX + (float)this.timelineWidth * progress);
            int halfLineWidth = 1;
            if (mouseX < lineX - halfLineWidth || mouseX > lineX + halfLineWidth) continue;
            return i;
        }
        return -1;
    }

    protected void setAnchorPoint(ElementAnchorPoint newAnchor) {
        this.previewElement.anchorPoint = newAnchor;
        this.previewElement.posOffsetX = 0;
        this.previewElement.posOffsetY = 0;
        int startX = this.previewElement.getAbsoluteX();
        int startY = this.previewElement.getAbsoluteY();
        int endX = startX + this.previewElement.getAbsoluteWidth();
        int endY = startY + this.previewElement.getAbsoluteHeight();
        if (startX < 0 || startY < 0 || endX > this.f_96543_ || endY > this.f_96544_) {
            if (startX < 0) {
                this.previewElement.posOffsetX = -startX;
            } else if (endX > this.f_96543_) {
                this.previewElement.posOffsetX = this.f_96543_ - endX;
            }
            if (startY < 0) {
                this.previewElement.posOffsetY = -startY;
            } else if (endY > this.f_96544_) {
                this.previewElement.posOffsetY = this.f_96544_ - endY;
            }
        }
        if (this.selectedKeyframes.size() == 1) {
            this.saveState();
            AnimationKeyframe selectedKeyframe = this.selectedKeyframes.get(0);
            selectedKeyframe.anchorPoint = this.previewElement.anchorPoint;
            selectedKeyframe.posOffsetX = this.previewElement.posOffsetX;
            selectedKeyframe.posOffsetY = this.previewElement.posOffsetY;
        }
    }

    protected void setStickyAnchor(boolean sticky) {
        if (this.selectedKeyframes.size() == 1) {
            this.saveState();
            this.selectedKeyframes.get((int)0).stickyAnchor = sticky;
        }
        this.previewElement.stickyAnchor = sticky;
    }

    protected float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public void displayNotification(@NotNull Component message, long durationMs) {
        this.activeNotifications.add(new Notification(message, durationMs));
    }

    public boolean m_6913_() {
        return false;
    }

    protected static class PreviewElement
    extends AbstractElement {
        public PreviewElement(ElementBuilder<?, ?> builder) {
            super(builder);
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        }
    }

    protected class PreviewEditorElement
    extends AbstractEditorElement {
        protected boolean elementMovingStarted;
        protected boolean resizingStarted;

        public PreviewEditorElement(@NotNull AbstractElement element, LayoutEditorScreen editor) {
            super(element, editor);
            this.elementMovingStarted = false;
            this.resizingStarted = false;
            this.settings.setFadeable(false);
            this.settings.setAdvancedSizingSupported(false);
            this.settings.setAdvancedPositioningSupported(false);
            this.settings.setOpacityChangeable(false);
            this.settings.setDelayable(false);
            this.settings.setElementAnchorPointAllowed(false);
            this.settings.setStretchable(false);
            this.settings.setVanillaAnchorPointAllowed(false);
            this.settings.setOrderable(false);
            this.settings.setCopyable(false);
            this.settings.setDestroyable(false);
            this.settings.setIdentifierCopyable(false);
        }

        @Override
        public void init() {
            super.init();
            this.topLeftDisplay.clearLines();
            this.bottomRightDisplay.clearLines();
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            this.renderPreviewBody(graphics, mouseX, mouseY, partial);
            super.m_88315_(graphics, mouseX, mouseY, partial);
        }

        public void renderPreviewBody(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            DrawableColor c = PREVIEW_COLOR_NORMAL;
            if (KeyframeManagerScreen.this.isRecording) {
                c = RECORDING_COLOR;
            }
            if (KeyframeManagerScreen.this.selectedKeyframes.size() == 1) {
                c = KEYFRAME_COLOR_SELECTED;
            }
            graphics.m_285944_(RenderType.m_285907_(), this.element.getAbsoluteX(), this.element.getAbsoluteY(), this.element.getAbsoluteX() + this.element.getAbsoluteWidth(), this.element.getAbsoluteY() + this.element.getAbsoluteHeight(), c.getColorInt());
        }

        @Override
        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            int draggingDiffX = (int)(mouseX - this.leftMouseDownMouseX);
            int draggingDiffY = (int)(mouseY - this.leftMouseDownMouseY);
            boolean bl = this.movingCrumpleZonePassed = Math.abs(draggingDiffX) >= 5 || Math.abs(draggingDiffY) >= 5;
            if (this.movingCrumpleZonePassed && !this.elementMovingStarted) {
                this.updateMovingStartPos((int)mouseX, (int)mouseY);
                this.elementMovingStarted = true;
            }
            if (!this.resizingStarted) {
                this.updateResizingStartPos((int)mouseX, (int)mouseY);
                this.resizingStarted = true;
            }
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        @Override
        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.movingCrumpleZonePassed = false;
            this.elementMovingStarted = false;
            this.resizingStarted = false;
            return super.m_6348_(mouseX, mouseY, button);
        }
    }

    protected static class Notification {
        @NotNull
        public final Component message;
        public final long startTime;
        public final long duration;
        public float opacity = 1.0f;

        public Notification(@NotNull Component message, long duration) {
            this.message = message;
            this.startTime = System.currentTimeMillis();
            this.duration = duration;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.startTime > this.duration;
        }

        public void updateOpacity() {
            float fadeStartTime;
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            if ((float)elapsedTime > (fadeStartTime = (float)(this.duration - 500L))) {
                this.opacity = 1.0f - ((float)elapsedTime - fadeStartTime) / 500.0f;
                this.opacity = Math.max(0.05f, Math.min(1.0f, this.opacity));
            }
        }

        public int getHeight() {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return 9 + 2;
        }
    }

    public record AnimationControllerMetadata(@NotNull List<AnimationKeyframe> keyframes, boolean isOffsetMode) {
    }
}

