/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.config;

import java.util.function.BiConsumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class RPLConfigs {
    private static final ForgeConfigSpec serverSpec;
    private static final Server SERVER;

    public static Server server() {
        return SERVER;
    }

    public static void registerConfigs(BiConsumer<ModConfig.Type, ForgeConfigSpec> cons) {
        cons.accept(ModConfig.Type.SERVER, serverSpec);
    }

    public static void onModConfigLoad(ModConfig modConfig) {
    }

    public static void onModConfigReload(ModConfig modConfig) {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue maxChunksForceLoaded;
        public final ForgeConfigSpec.IntValue maxChunksLoadedEachTick;
        public final ForgeConfigSpec.IntValue projectileChunkAge;
        public final ForgeConfigSpec.IntValue entityLoadTimeout;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings for Ritchie's Projectile Library").push("server");
            this.maxChunksForceLoaded = builder.comment("The maximum amount of chunks forced to load during a single tick. Set to 0 to force load unlimited chunks.").translation("ritchiesprojectilelib.configgui.maxChunksForceLoaded").defineInRange("maxChunksForceLoaded", 64, 0, Integer.MAX_VALUE);
            this.maxChunksLoadedEachTick = builder.comment("The maximum amount of chunks that can be processed for loading each tick.").translation("ritchiesprojectilelib.configgui.maxChunksLoadedEachTick").defineInRange("maxChunksLoadedEachTick", 32, 1, 256);
            this.projectileChunkAge = builder.comment(new String[]{"[in Ticks]", "How long chunks loaded by this mod last for before being unloaded."}).translation("ritchiesprojectilelib.configgui.projectileChunkAge").defineInRange("projectileChunkAge", 3, 1, 20);
            this.entityLoadTimeout = builder.comment(new String[]{"[in Ticks]", "How long chunks loaded by this mod last for before being unloaded if they have not yet loaded entities."}).translation("ritchiesprojectilelib.configgui.entityLoadTimeout").defineInRange("entityLoadTimeout", 10, 1, 200);
            builder.pop();
        }
    }
}

