/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei.category;

import com.enderio.machines.client.gui.screen.SlicerScreen;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.integrations.jei.util.MachineRecipeCategory;
import com.enderio.machines.common.integrations.jei.util.RecipeUtil;
import com.enderio.machines.common.lang.MachineLang;
import com.enderio.machines.common.recipe.SlicingRecipe;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class SlicingRecipeCategory
extends MachineRecipeCategory<SlicingRecipe> {
    public static final RecipeType<SlicingRecipe> TYPE = RecipeType.create((String)"enderio", (String)"slicing", SlicingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public SlicingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SlicerScreen.BG_TEXTURE, 43, 15, 108, 60);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)MachineBlocks.SLICE_AND_SPLICE.get()));
    }

    public RecipeType<SlicingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return MachineLang.CATEGORY_SLICING;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SlicingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 11, 1).addIngredients(Ingredient.m_204132_((TagKey)ItemTags.f_271207_));
        builder.addSlot(RecipeIngredientRole.CATALYST, 29, 1).addIngredients(Ingredient.m_204132_((TagKey)Tags.Items.SHEARS));
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 25).addIngredients(recipe.getInputs().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 25).addIngredients(recipe.getInputs().get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 37, 25).addIngredients(recipe.getInputs().get(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 43).addIngredients(recipe.getInputs().get(3));
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 43).addIngredients(recipe.getInputs().get(4));
        builder.addSlot(RecipeIngredientRole.INPUT, 37, 43).addIngredients(recipe.getInputs().get(5));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 34).addItemStacks(List.of(RecipeUtil.getResultStacks(recipe).get(0).getItem()));
    }
}

