/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.fluid.FluidStack;
import net.lyivx.ls_furniture.client.util.FluidRenderUtil;
import net.lyivx.ls_furniture.common.blocks.entity.LiquidHolderBlockEntity;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SimpleFluidRenderer {
    public static void drawContainer(Level level, BlockPos pos, LiquidHolderBlockEntity blockEntity, AABB box, PoseStack poseStack, MultiBufferSource source, int light) {
        Fluid fluid = blockEntity.getFluid();
        FluidStack fluidStack = FluidStack.create((Fluid)fluid, (long)blockEntity.getStoredAmount());
        if (fluid == Fluids.f_76191_) {
            return;
        }
        TextureAtlasSprite[] sprites = FluidRenderUtil.getSprites(fluid);
        if (sprites == null || sprites.length < 1 || sprites[0] == null) {
            return;
        }
        TextureAtlasSprite still = sprites[0];
        int colour = FluidRenderUtil.getColor(fluidStack, (BlockAndTintGetter)level, pos);
        if (fluid.m_6212_((Fluid)Fluids.f_76193_)) {
            int biomeColor;
            colour = biomeColor = BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)pos);
        }
        float red = (float)FastColor.ARGB32.m_13665_((int)colour) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)colour) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)colour) / 255.0f;
        float alpha = 1.0f;
        float fullness = (float)blockEntity.getStoredAmount() / (float)blockEntity.getCapacity();
        float minY = (float)box.f_82289_;
        float maxY = (float)box.f_82292_;
        float fluidHeight = (maxY - minY) * fullness;
        float offset = minY + fluidHeight;
        offset = Math.min(offset, maxY);
        offset = Math.max(offset, minY);
        float uScale = still.m_118410_() - still.m_118409_();
        float vScale = still.m_118412_() - still.m_118411_();
        float u0 = still.m_118409_() + uScale * (float)(box.f_82288_ - Math.floor(box.f_82288_));
        float u1 = still.m_118409_() + uScale * (float)(box.f_82291_ - Math.floor(box.f_82288_));
        float v0 = still.m_118411_() + vScale * (float)(box.f_82290_ - Math.floor(box.f_82290_));
        float v1 = still.m_118411_() + vScale * (float)(box.f_82293_ - Math.floor(box.f_82290_));
        RenderType type = RenderType.m_110466_();
        VertexConsumer consumer = source.m_6299_(type);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        consumer.m_252986_(matrix, (float)box.f_82288_, offset, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_7421_(u0, v0).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82288_, offset, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_7421_(u0, v1).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, offset, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_7421_(u1, v1).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)box.f_82291_, offset, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_7421_(u1, v0).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static AABB createRotatedBox(Direction direction, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        minX /= 16.0;
        minY /= 16.0;
        minZ /= 16.0;
        maxX /= 16.0;
        maxY /= 16.0;
        maxZ /= 16.0;
        return switch (direction) {
            case Direction.WEST -> new AABB(1.0 - maxX, minY, 1.0 - maxZ, 1.0 - minX, maxY, 1.0 - minZ);
            case Direction.NORTH -> new AABB(minZ, minY, 1.0 - maxX, maxZ, maxY, 1.0 - minX);
            case Direction.SOUTH -> new AABB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX);
            default -> new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        };
    }
}

