/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import net.lyivx.ls_furniture.common.blocks.entity.LockableBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.CounterType;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.items.HammerItem;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.common.utils.block.ILockable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CounterBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock,
HammerItem.HammerableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<CounterType> SHAPE = ModBlockStateProperties.COUNTER_TYPE;
    public static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape BACK = Block.m_49796_((double)0.0, (double)16.0, (double)15.0, (double)16.0, (double)18.0, (double)16.0);
    public static final VoxelShape BACK_INNER = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)16.0, (double)15.0, (double)16.0, (double)18.0, (double)16.0), (VoxelShape)Block.m_49796_((double)15.0, (double)16.0, (double)0.0, (double)16.0, (double)18.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape BACK_OUTER = Block.m_49796_((double)15.0, (double)16.0, (double)15.0, (double)16.0, (double)18.0, (double)16.0);
    public static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0);
    public static final VoxelShape BASE_RIGHT = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0);
    public static final VoxelShape BASE_LEFT = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    public static final VoxelShape BASE_INNER = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape BASE_OUTER = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0);
    public static final VoxelShape SINGLE = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{BACK, BASE});
    public static final VoxelShape SINGLE_EAST = ShapeUtil.rotateShape(SINGLE, Direction.EAST);
    public static final VoxelShape SINGLE_SOUTH = ShapeUtil.rotateShape(SINGLE, Direction.SOUTH);
    public static final VoxelShape SINGLE_WEST = ShapeUtil.rotateShape(SINGLE, Direction.WEST);
    public static final VoxelShape MIDDLE = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{BACK, BASE});
    public static final VoxelShape MIDDLE_EAST = ShapeUtil.rotateShape(MIDDLE, Direction.EAST);
    public static final VoxelShape MIDDLE_SOUTH = ShapeUtil.rotateShape(MIDDLE, Direction.SOUTH);
    public static final VoxelShape MIDDLE_WEST = ShapeUtil.rotateShape(MIDDLE, Direction.WEST);
    public static final VoxelShape OUTER = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{BACK_OUTER, BASE_OUTER});
    public static final VoxelShape OUTER_EAST = ShapeUtil.rotateShape(OUTER, Direction.EAST);
    public static final VoxelShape OUTER_SOUTH = ShapeUtil.rotateShape(OUTER, Direction.SOUTH);
    public static final VoxelShape OUTER_WEST = ShapeUtil.rotateShape(OUTER, Direction.WEST);
    public static final VoxelShape INNER = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{BACK_INNER, BASE_INNER});
    public static final VoxelShape INNER_EAST = ShapeUtil.rotateShape(INNER, Direction.EAST);
    public static final VoxelShape INNER_SOUTH = ShapeUtil.rotateShape(INNER, Direction.SOUTH);
    public static final VoxelShape INNER_WEST = ShapeUtil.rotateShape(INNER, Direction.WEST);
    public static final VoxelShape RIGHT = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{BACK, BASE_RIGHT});
    public static final VoxelShape RIGHT_EAST = ShapeUtil.rotateShape(RIGHT, Direction.EAST);
    public static final VoxelShape RIGHT_SOUTH = ShapeUtil.rotateShape(RIGHT, Direction.SOUTH);
    public static final VoxelShape RIGHT_WEST = ShapeUtil.rotateShape(RIGHT, Direction.WEST);
    public static final VoxelShape LEFT = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{BACK, BASE_LEFT});
    public static final VoxelShape LEFT_EAST = ShapeUtil.rotateShape(LEFT, Direction.EAST);
    public static final VoxelShape LEFT_SOUTH = ShapeUtil.rotateShape(LEFT, Direction.SOUTH);
    public static final VoxelShape LEFT_WEST = ShapeUtil.rotateShape(LEFT, Direction.WEST);

    public CounterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockPos);
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)CounterBlock.getConnection(blockState, context.m_43725_(), blockPos)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        ILockable lockable;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((blockEntity = level.m_7702_(currentPos)) instanceof ILockable && (lockable = (ILockable)blockEntity).isLocked()) {
            return state;
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)CounterBlock.getConnection(state, (Level)level, currentPos))) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        CounterType shape = (CounterType)((Object)state.m_61143_(SHAPE));
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case CounterType.SINGLE -> {
                switch (facing) {
                    case EAST: {
                        yield SINGLE_EAST;
                    }
                    case SOUTH: {
                        yield SINGLE_SOUTH;
                    }
                    case WEST: {
                        yield SINGLE_WEST;
                    }
                }
                yield SINGLE;
            }
            case CounterType.MIDDLE -> {
                switch (facing) {
                    case EAST: {
                        yield MIDDLE_EAST;
                    }
                    case SOUTH: {
                        yield MIDDLE_SOUTH;
                    }
                    case WEST: {
                        yield MIDDLE_WEST;
                    }
                }
                yield MIDDLE;
            }
            case CounterType.OUTER_LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield OUTER_EAST;
                    }
                    case SOUTH: {
                        yield OUTER_SOUTH;
                    }
                    case WEST: {
                        yield OUTER_WEST;
                    }
                }
                yield OUTER;
            }
            case CounterType.OUTER_RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield OUTER_SOUTH;
                    }
                    case SOUTH: {
                        yield OUTER_WEST;
                    }
                    case WEST: {
                        yield OUTER;
                    }
                }
                yield OUTER_EAST;
            }
            case CounterType.LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield LEFT_EAST;
                    }
                    case SOUTH: {
                        yield LEFT_SOUTH;
                    }
                    case WEST: {
                        yield LEFT_WEST;
                    }
                }
                yield LEFT;
            }
            case CounterType.RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield RIGHT_SOUTH;
                    }
                    case WEST: {
                        yield RIGHT_WEST;
                    }
                }
                yield RIGHT;
            }
            case CounterType.INNER_RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield INNER_SOUTH;
                    }
                    case SOUTH: {
                        yield INNER_WEST;
                    }
                    case WEST: {
                        yield INNER;
                    }
                }
                yield INNER_EAST;
            }
            case CounterType.INNER_LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield INNER_EAST;
                    }
                    case SOUTH: {
                        yield INNER_SOUTH;
                    }
                    case WEST: {
                        yield INNER_WEST;
                    }
                }
                yield INNER;
            }
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, WATERLOGGED});
    }

    public static CounterType getConnection(BlockState state, Level level, BlockPos pos) {
        Direction dir2;
        Direction dir1;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState state1 = level.m_8055_(pos.m_121945_(facing));
        if (state1.m_60734_() instanceof CounterBlock && (dir1 = (Direction)state1.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && CounterBlock.isDifferentOrientation(state, level, pos, dir1.m_122424_())) {
            if (dir1 == facing.m_122428_()) {
                return CounterType.INNER_LEFT;
            }
            return CounterType.INNER_RIGHT;
        }
        BlockState state2 = level.m_8055_(pos.m_121945_(facing.m_122424_()));
        if (state2.m_60734_() instanceof CounterBlock && (dir2 = (Direction)state2.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && CounterBlock.isDifferentOrientation(state, level, pos, dir2)) {
            if (dir2 == facing.m_122428_()) {
                return CounterType.OUTER_LEFT;
            }
            return CounterType.OUTER_RIGHT;
        }
        boolean left = CounterBlock.canConnect(level, pos, ((Direction)state.m_61143_((Property)FACING)).m_122428_());
        boolean right = CounterBlock.canConnect(level, pos, ((Direction)state.m_61143_((Property)FACING)).m_122427_());
        if (left && right) {
            return CounterType.MIDDLE;
        }
        if (left) {
            return CounterType.LEFT;
        }
        if (right) {
            return CounterType.RIGHT;
        }
        return CounterType.SINGLE;
    }

    public static boolean canConnect(Level level, BlockPos pos, Direction direction) {
        BlockState state = level.m_8055_(pos.m_121945_(direction));
        return state.m_60734_() instanceof CounterBlock;
    }

    public static boolean isDifferentOrientation(BlockState state, Level level, BlockPos pos, Direction dir) {
        BlockState blockState = level.m_8055_(pos.m_121945_(dir));
        return !(blockState.m_60734_() instanceof CounterBlock) || blockState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.connectable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.lockable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.hammerable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getHammerableProperties() {
        return List.of(SHAPE);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    @Override
    public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
        return WrenchItem.WrenchableBlock.super.updateAfterCycle(state, level, pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockableBlockEntity(pos, state);
    }
}

