/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.model.light;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.paulf.fairylights.client.model.light.EasyMeshBuilder;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;

public class IncandescentLightModel
extends LightModel<BrightnessLightBehavior> {
    final ModelPart bulb;
    final ModelPart filament;

    public IncandescentLightModel(ModelPart root) {
        super(root);
        this.bulb = root.m_171324_("bulb");
        this.filament = root.m_171324_("filament");
    }

    @Override
    public void animate(Light<?> light, BrightnessLightBehavior behavior, float delta) {
        super.animate(light, behavior, delta);
        this.brightness = behavior.getBrightness(delta);
    }

    @Override
    protected int getLight(int packedLight) {
        return (int)Math.max(this.brightness * 15.0f * 16.0f, (float)(packedLight & 0xFF)) | packedLight & 0xFF0000;
    }

    @Override
    public void m_7695_(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        super.m_7695_(matrix, builder, light, overlay, r, g, b, a);
        int emissiveLight = this.getLight(light);
        float cr = 0.23f;
        float cg = 0.18f;
        float cb = 0.14f;
        float br = this.brightness;
        this.filament.m_104306_(matrix, builder, emissiveLight, overlay, r * (0.23f * (1.0f - br) + br), g * (0.18f * (1.0f - br) + br), b * (0.14f * (1.0f - br) + br), a);
    }

    @Override
    public void renderTranslucent(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        float bi = this.brightness;
        int emissiveLight = this.getLight(light);
        float br = 1.0f;
        float bg = 0.73f;
        float bb = 0.3f;
        this.bulb.m_104306_(matrix, builder, emissiveLight, overlay, r * (1.0f * bi + (1.0f - bi)), g * (0.73f * bi + (1.0f - bi)), b * (0.3f * bi + (1.0f - bi)), bi * 0.4f + 0.25f);
        super.renderTranslucent(matrix, builder, light, overlay, r, g, b, a);
    }

    public static LayerDefinition createLayer() {
        LightModel.LightMeshHelper helper = LightModel.LightMeshHelper.create();
        helper.unlit().setTextureOffset(90, 10);
        helper.unlit().addBox(-1.0f, -0.01f, -1.0f, 2.0f, 1.0f, 2.0f);
        EasyMeshBuilder bulb = new EasyMeshBuilder("bulb", 98, 10);
        bulb.addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f);
        helper.extra().add(bulb);
        EasyMeshBuilder filament = new EasyMeshBuilder("filament", 90, 13);
        filament.addBox(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f);
        helper.extra().add(filament);
        return helper.build();
    }
}

