/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.feature.light.ColorLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.item.DyeableItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FixedColorBehavior
implements ColorLightBehavior {
    private final float red;
    private final float green;
    private final float blue;

    public FixedColorBehavior(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    @Override
    public float getRed(float delta) {
        return this.red;
    }

    @Override
    public float getGreen(float delta) {
        return this.green;
    }

    @Override
    public float getBlue(float delta) {
        return this.blue;
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
    }

    @Override
    public void tick(Level world, Vec3 origin, Light<?> light) {
    }

    public static ColorLightBehavior create(ItemStack stack) {
        int rgb = DyeableItem.getColor(stack);
        float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb & 0xFF) / 255.0f;
        return new FixedColorBehavior(red, green, blue);
    }
}

