/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.data.Lenses;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Ingredient;

public class LensesDataLoader
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String DIRECTORY = "lenses";

    public LensesDataLoader() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> content, ResourceManager resourceManager, ProfilerFiller profiler) {
        ConcurrentHashMap<Ingredient, FocalRange> lenses = new ConcurrentHashMap<Ingredient, FocalRange>();
        Exposure.LOGGER.info("Loading exposure lenses:");
        for (Map.Entry<ResourceLocation, JsonElement> entry : content.entrySet()) {
            if (!entry.getKey().m_135827_().equals("exposure")) continue;
            try {
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                JsonElement item = jsonObject.get("item");
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)item);
                if (ingredient.m_43947_()) {
                    throw new IllegalArgumentException("'item' cannot be empty.");
                }
                JsonElement value = jsonObject.get("focal_range");
                FocalRange focalRange = FocalRange.fromJson(value);
                lenses.put(ingredient, focalRange);
                Exposure.LOGGER.info("Lens [" + String.valueOf(entry.getKey()) + ", " + String.valueOf(focalRange) + "] added.");
            }
            catch (Exception e) {
                Exposure.LOGGER.error(e.toString());
            }
        }
        if (lenses.isEmpty()) {
            Exposure.LOGGER.info("No lenses have been loaded.");
        }
        Lenses.reload(lenses);
    }
}

