/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin;

import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class MultiPlayerGameModeMixin {
    @Inject(method={"interactAt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/EntityHitResult;getLocation()Lnet/minecraft/world/phys/Vec3;")}, cancellable=true)
    void onInteractAt(Player player, Entity target, EntityHitResult ray, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (MultiPlayerGameModeMixin.exposure$useCamera(player)) {
            cir.setReturnValue((Object)InteractionResult.CONSUME);
        }
    }

    @Inject(method={"useItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getWorldBorder()Lnet/minecraft/world/level/border/WorldBorder;")}, cancellable=true)
    void onUseItemOn(LocalPlayer player, InteractionHand hand, BlockHitResult result, CallbackInfoReturnable<InteractionResult> cir) {
        if (MultiPlayerGameModeMixin.exposure$useCamera((Player)player)) {
            cir.setReturnValue((Object)InteractionResult.CONSUME);
        }
    }

    @Unique
    private static boolean exposure$useCamera(Player player) {
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        if (gameMode == null) {
            return false;
        }
        Optional<Camera<?>> cameraOpt = Camera.getCamera(player);
        if (cameraOpt.isEmpty()) {
            return false;
        }
        Camera<?> camera = cameraOpt.get();
        if (camera instanceof CameraInHand) {
            CameraInHand cameraInHand = (CameraInHand)camera;
            gameMode.m_233721_(player, cameraInHand.getHand());
            return true;
        }
        return false;
    }
}

