/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.client;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.handler.ClientPacketsHandler;
import io.github.mortuusars.exposure.network.packet.IPacket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public record SyncLensesS2CP(ConcurrentMap<Ingredient, FocalRange> lenses) implements IPacket
{
    public static final ResourceLocation ID = Exposure.resource("sync_lenses");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.lenses.size());
        for (Map.Entry lens : this.lenses.entrySet()) {
            Ingredient ingredient = (Ingredient)lens.getKey();
            ingredient.m_43923_(buffer);
            FocalRange focalRange = (FocalRange)lens.getValue();
            focalRange.toNetwork(buffer);
        }
        return buffer;
    }

    public static SyncLensesS2CP fromBuffer(FriendlyByteBuf buffer) {
        ConcurrentHashMap<Ingredient, FocalRange> lenses = new ConcurrentHashMap<Ingredient, FocalRange>();
        int lensCount = buffer.m_130242_();
        for (int i = 0; i < lensCount; ++i) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FocalRange focalRange = FocalRange.fromNetwork(buffer);
            lenses.put(ingredient, focalRange);
        }
        return new SyncLensesS2CP(lenses);
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        ClientPacketsHandler.syncLenses(this);
        return true;
    }
}

