/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.modifiers;

import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import io.github.mortuusars.exposure.util.Color;
import io.github.mortuusars.exposure.util.HUSLColorConverter;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;

public class AgedHSBPixelModifier
implements IPixelModifier {
    public final int tintColor;
    public final double[] tintColorHsluv;
    public final float tintOpacity;
    public final int blackPoint;
    public final int whitePoint;

    public AgedHSBPixelModifier(int tintColor, float tintOpacity, int blackPoint, int whitePoint) {
        this.tintColor = tintColor;
        String hexStr = StringUtils.leftPad((String)Integer.toHexString(tintColor & 0xFFFFFF), (int)6, (String)"0");
        this.tintColorHsluv = HUSLColorConverter.hexToHsluv("#" + hexStr);
        this.tintOpacity = tintOpacity;
        this.blackPoint = blackPoint & 0xFF;
        this.whitePoint = whitePoint & 0xFF;
    }

    @Override
    public String getIdSuffix() {
        return "_sepia";
    }

    @Override
    public int modifyPixel(int ABGR) {
        int alpha = FastColor.ABGR32.m_266503_((int)ABGR);
        int blue = FastColor.ABGR32.m_266247_((int)ABGR);
        int green = FastColor.ABGR32.m_266446_((int)ABGR);
        int red = FastColor.ABGR32.m_266313_((int)ABGR);
        blue = (int)Mth.m_184637_((float)blue, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        green = (int)Mth.m_184637_((float)green, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        red = (int)Mth.m_184637_((float)red, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        float[] baseHSB = new float[3];
        Color.RGBtoHSB(red, green, blue, baseHSB);
        float[] tintHSB = new float[3];
        Color.RGBtoHSB(FastColor.ARGB32.m_13665_((int)this.tintColor), FastColor.ARGB32.m_13667_((int)this.tintColor), FastColor.ARGB32.m_13669_((int)this.tintColor), tintHSB);
        int luma = Mth.m_14045_((int)((int)(0.45 * (double)red + 0.65 * (double)green + 0.2 * (double)blue)), (int)0, (int)255);
        int tintedRGB = Color.HSBtoRGB(tintHSB[0], tintHSB[1], (float)luma / 255.0f);
        int newBlue = Mth.m_14045_((int)((int)Mth.m_14179_((float)this.tintOpacity, (float)blue, (float)FastColor.ARGB32.m_13669_((int)tintedRGB))), (int)0, (int)255);
        int newGreen = Mth.m_14045_((int)((int)Mth.m_14179_((float)this.tintOpacity, (float)green, (float)FastColor.ARGB32.m_13667_((int)tintedRGB))), (int)0, (int)255);
        int newRed = Mth.m_14045_((int)((int)Mth.m_14179_((float)this.tintOpacity, (float)red, (float)FastColor.ARGB32.m_13665_((int)tintedRGB))), (int)0, (int)255);
        return FastColor.ABGR32.m_266248_((int)alpha, (int)newBlue, (int)newGreen, (int)newRed);
    }

    public String toString() {
        return "AgedHSBPixelModifier{tintColor=#" + Integer.toHexString(this.tintColor) + ", tintOpacity=" + this.tintOpacity + ", blackPoint=" + this.blackPoint + ", whitePoint=" + this.whitePoint + "}";
    }
}

