/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.google.common.collect.Lists;
import dev.emi.emi.api.EmiApi;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;

public class EmiHistory {
    private static final List<Screen> HISTORIES = Lists.newArrayList();
    private static final List<Screen> FORWARD_HISTORIES = Lists.newArrayList();

    public static boolean isEmpty() {
        return HISTORIES.isEmpty();
    }

    public static boolean isForwardEmpty() {
        return FORWARD_HISTORIES.isEmpty();
    }

    public static void push(Screen history) {
        HISTORIES.add(history);
        FORWARD_HISTORIES.clear();
    }

    public static void pop() {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91080_ instanceof AbstractContainerScreen) {
            EmiHistory.clear();
            return;
        }
        int i = HISTORIES.size() - 1;
        AbstractContainerScreen<?> screen = EmiApi.getHandledScreen();
        if (i >= 0) {
            Screen popped = HISTORIES.remove(i);
            FORWARD_HISTORIES.add(client.f_91080_);
            client.m_91152_(popped);
        } else if (screen != null) {
            client.m_91152_(screen);
        }
    }

    public static void popUntil(Predicate<Screen> predicate, Screen otherwise) {
        Minecraft client = Minecraft.m_91087_();
        while (!EmiHistory.isEmpty()) {
            EmiHistory.pop();
            if (!predicate.test(client.f_91080_)) continue;
            return;
        }
        client.m_91152_(otherwise);
    }

    public static void forward() {
        Minecraft client = Minecraft.m_91087_();
        int i = FORWARD_HISTORIES.size() - 1;
        if (i >= 0 && client.f_91080_ != null) {
            Screen popped = FORWARD_HISTORIES.remove(i);
            HISTORIES.add(client.f_91080_);
            client.m_91152_(popped);
        }
    }

    public static void clear() {
        HISTORIES.clear();
        FORWARD_HISTORIES.clear();
    }
}

