/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.projectile;

import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.event.GunProjectileHitEvent;
import ttv.migami.jeg.faction.GunnerManager;
import ttv.migami.jeg.init.ModCommands;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.particles.ColoredFlareData;

public class FlareProjectileEntity
extends ProjectileEntity {
    private static final Predicate<BlockState> IGNORE_LEAVES = input -> input != null && (Boolean)Config.COMMON.gameplay.ignoreLeaves.get() != false && input.m_60734_() instanceof LeavesBlock;
    private boolean hasRaid = false;
    private String raid = null;
    private boolean terrorRaid = false;
    private static final EntityDataAccessor<Boolean> DATA_IS_CUSTOM_COLORED = SynchedEntityData.m_135353_(FlareProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(FlareProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public void setColor(int color) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR);
    }

    public void setCustomColored(boolean customColored) {
        this.f_19804_.m_135381_(DATA_IS_CUSTOM_COLORED, (Object)customColored);
    }

    public boolean isCustomColored() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CUSTOM_COLORED);
    }

    public FlareProjectileEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public FlareProjectileEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack stack, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, stack, item, modifiedGun);
        if (stack.m_41783_() != null && stack.m_41783_().m_128471_("HasTerrorRaid")) {
            this.terrorRaid = true;
            stack.m_41783_().m_128379_("HasRaid", false);
        } else if (stack.m_41783_() != null && stack.m_41783_().m_128471_("HasRaid")) {
            this.hasRaid = true;
            if (stack.m_41783_().m_128441_("Raid")) {
                this.raid = stack.m_41783_().m_128461_("Raid");
            }
            stack.m_41783_().m_128379_("HasRaid", false);
            stack.m_41783_().m_128473_("Raid");
        }
    }

    @Override
    protected void onProjectileTick() {
        Level level;
        if (!this.m_9236_().f_46443_ && this.f_19797_ > 80) {
            if (this.hasRaid) {
                GunnerManager gunnerManager = GunnerManager.getInstance();
                if (this.raid != null) {
                    faction = gunnerManager.getFactionByName(this.raid);
                    ModCommands.startRaid((ServerLevel)this.m_9236_(), faction, this.shooter.m_20182_(), true);
                } else {
                    faction = gunnerManager.getFactionByName(gunnerManager.getRandomFactionName());
                    ModCommands.startRaid((ServerLevel)this.m_9236_(), faction, this.shooter.m_20182_(), true);
                }
                this.hasRaid = false;
            }
            if (this.terrorRaid) {
                ModCommands.startTerrorRaid((ServerLevel)this.m_9236_(), this.shooter.m_20182_(), true, false);
                this.terrorRaid = false;
            }
        }
        JustEnoughGuns.LOGGER.atInfo().log((Object)this.isCustomColored());
        JustEnoughGuns.LOGGER.atInfo().log((Object)this.getColor());
        if (this.m_9236_() instanceof ClientLevel && this.f_19797_ > 1 && this.f_19797_ < this.life && this.isCustomColored()) {
            int r = this.getColor() >> 16 & 0xFF;
            int g = this.getColor() >> 8 & 0xFF;
            int b = this.getColor() & 0xFF;
            this.m_9236_().m_6485_((ParticleOptions)new ColoredFlareData(r, g, b), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.1, 0.0);
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 1 && this.f_19797_ < this.life) {
                if (this.terrorRaid) {
                    ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.BLUE_FLARE.get(), true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                } else if (!this.isCustomColored()) {
                    ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.FLARE_SMOKE.get(), true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE.get(), true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_123756_, true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            BlockHitResult result = FlareProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            this.onHit((HitResult)result, startVec, endVec);
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        super.onHitEntity(entity, hitVec, startVec, endVec, headshot);
        entity.m_20254_(5);
    }

    private void onHit(HitResult result, Vec3 startVec, Vec3 endVec) {
        if (MinecraftForge.EVENT_BUS.post((Event)new GunProjectileHitEvent(result, this))) {
            return;
        }
        if (result instanceof BlockHitResult) {
            BlockHitResult blockRayTraceResult = (BlockHitResult)result;
            if (blockRayTraceResult.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            Vec3 hitVec = result.m_82450_();
            BlockPos pos = blockRayTraceResult.m_82425_();
            if (((Boolean)Config.COMMON.gameplay.griefing.setFireToBlocks.get()).booleanValue()) {
                BlockPos offsetPos = pos.m_121945_(blockRayTraceResult.m_82434_());
                if (this.m_9236_().m_213780_().m_188501_() > 0.5f && BaseFireBlock.m_49255_((Level)this.m_9236_(), (BlockPos)offsetPos, (Direction)blockRayTraceResult.m_82434_())) {
                    BlockState fireState = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)offsetPos);
                    this.m_9236_().m_7731_(offsetPos, fireState, 11);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, hitVec.f_82479_ - 1.0 + this.f_19796_.m_188500_() * 2.0, hitVec.f_82480_, hitVec.f_82481_ - 1.0 + this.f_19796_.m_188500_() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLOR, (Object)0xF0F0F0);
        this.f_19804_.m_135372_(DATA_IS_CUSTOM_COLORED, (Object)false);
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Color", this.getColor());
        tag.m_128379_("CustomColored", this.isCustomColored());
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Color")) {
            this.setColor(tag.m_128451_("Color"));
        }
        if (tag.m_128441_("CustomColored")) {
            this.setCustomColored(tag.m_128471_("CustomColored"));
        }
    }
}

