/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.projectile;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.client.medal.MedalType;
import ttv.migami.jeg.common.BoundingBoxManager;
import ttv.migami.jeg.common.ChargeTracker;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.SpreadTracker;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.DynamicHelmet;
import ttv.migami.jeg.entity.projectile.BlazeProjectileEntity;
import ttv.migami.jeg.entity.projectile.FlameProjectileEntity;
import ttv.migami.jeg.entity.projectile.ResonanceProjectileEntity;
import ttv.migami.jeg.entity.projectile.RocketEntity;
import ttv.migami.jeg.entity.projectile.SonicProjectileEntity;
import ttv.migami.jeg.event.GunProjectileHitEvent;
import ttv.migami.jeg.event.KillEffectEvent;
import ttv.migami.jeg.init.ModBlocks;
import ttv.migami.jeg.init.ModDamageTypes;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.init.ModTags;
import ttv.migami.jeg.interfaces.IDamageable;
import ttv.migami.jeg.interfaces.IExplosionDamageable;
import ttv.migami.jeg.interfaces.IHeadshotBox;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.S2CMessageBlood;
import ttv.migami.jeg.network.message.S2CMessageExplosiveAmmo;
import ttv.migami.jeg.network.message.S2CMessageProjectileHitBlock;
import ttv.migami.jeg.network.message.S2CMessageProjectileHitEntity;
import ttv.migami.jeg.network.message.S2CMessageRemoveProjectile;
import ttv.migami.jeg.network.message.S2CMessageSendMedal;
import ttv.migami.jeg.util.BufferUtil;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;
import ttv.migami.jeg.util.ReflectionUtil;
import ttv.migami.jeg.util.math.ExtendedEntityRayTraceResult;
import ttv.migami.jeg.world.ProjectileExplosion;
import ttv.migami.mdf.init.ModEffects;

public class ProjectileEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final Random RANDOM = new Random();
    private static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.m_6087_() && !input.m_5833_();
    private static final Predicate<BlockState> IGNORE_LEAVES = input -> input != null && (Boolean)Config.COMMON.gameplay.ignoreLeaves.get() != false && input.m_60734_() instanceof LeavesBlock;
    protected int shooterId;
    protected LivingEntity shooter;
    protected Gun modifiedGun;
    protected Gun.General general;
    protected Gun.Projectile projectile;
    protected Gun.PotionEffect potionEffect;
    private ItemStack weapon = ItemStack.f_41583_;
    private ItemStack item = ItemStack.f_41583_;
    protected float additionalDamage = 0.0f;
    protected EntityDimensions entitySize;
    protected double modifiedGravity;
    protected int life;
    protected boolean hitWater = false;
    protected float chargeProgress;

    public ProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        this(entityType, worldIn);
        ServerPlayer player;
        this.shooterId = shooter.m_19879_();
        this.shooter = shooter;
        this.modifiedGun = modifiedGun;
        this.general = modifiedGun.getGeneral();
        this.projectile = modifiedGun.getProjectile();
        this.potionEffect = modifiedGun.getPotionEffect();
        this.entitySize = new EntityDimensions(this.projectile.getSize(), this.projectile.getSize(), false);
        this.modifiedGravity = modifiedGun.getProjectile().isGravity() ? GunModifierHelper.getModifiedProjectileGravity(weapon, -0.04) : 0.0;
        this.life = GunModifierHelper.getModifiedProjectileLife(weapon, this.projectile.getLife());
        if (shooter instanceof ServerPlayer) {
            player = (ServerPlayer)shooter;
            this.chargeProgress = player.getPersistentData().m_128457_("ChargeProgress");
        } else if (shooter instanceof Player) {
            Player player2 = (Player)shooter;
            this.chargeProgress = ChargeTracker.getChargeProgress(player2, weapon);
        } else {
            this.chargeProgress = 0.25f;
        }
        if (shooter instanceof Player) {
            player = (Player)shooter;
            ChargeTracker.clearLastChargeProgress(player.m_20148_());
        }
        Vec3 dir = this.getDirection(shooter, weapon, item, modifiedGun);
        double speedModifier = GunEnchantmentHelper.getProjectileSpeedModifier(weapon);
        double speed = GunModifierHelper.getModifiedProjectileSpeed(weapon, this.projectile.getSpeed() * speedModifier);
        this.m_20334_(dir.f_82479_ * speed, dir.f_82480_ * speed, dir.f_82481_ * speed);
        this.updateHeading();
        double posX = shooter.f_19790_ + (shooter.m_20185_() - shooter.f_19790_) / 2.0;
        double posY = shooter.f_19791_ + (shooter.m_20186_() - shooter.f_19791_) / 2.0 + (double)shooter.m_20192_();
        double posZ = shooter.f_19792_ + (shooter.m_20189_() - shooter.f_19792_) / 2.0;
        this.m_6034_(posX, posY, posZ);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(this.projectile.getItem());
        if (ammo != null) {
            ItemStack model;
            int customModelData = -1;
            if (weapon.m_41783_() != null && weapon.m_41783_().m_128425_("Model", 10) && (model = ItemStack.m_41712_((CompoundTag)weapon.m_41783_().m_128469_("Model"))).m_41783_() != null && model.m_41783_().m_128441_("CustomModelData")) {
                customModelData = model.m_41783_().m_128451_("CustomModelData");
            }
            ItemStack ammoStack = new ItemStack((ItemLike)ammo);
            if (customModelData != -1) {
                ammoStack.m_41784_().m_128405_("CustomModelData", customModelData);
            }
            this.item = ammoStack;
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.entitySize;
    }

    public Vec3 getDirection(LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        float gunSpread = GunModifierHelper.getModifiedSpread(weapon, modifiedGun.getGeneral().getSpread());
        if (gunSpread == 0.0f) {
            return this.getVectorFromRotation(shooter.m_146909_(), shooter.m_146908_());
        }
        if (shooter instanceof Player) {
            if (!modifiedGun.getGeneral().isAlwaysSpread()) {
                gunSpread *= SpreadTracker.get((Player)shooter).getSpread(item);
            }
            if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)((Player)shooter))).booleanValue()) {
                gunSpread *= 0.5f;
            }
        } else {
            gunSpread *= shooter.m_9236_().m_46791_() != Difficulty.HARD ? 10.0f : 5.0f;
        }
        gunSpread = Math.min(gunSpread, 170.0f) * 0.5f * ((float)Math.PI / 180);
        Vec3 vecforwards = this.getVectorFromRotation(shooter.m_146909_(), shooter.m_146908_());
        Vec3 vecupwards = this.getVectorFromRotation(shooter.m_146909_() + 90.0f, shooter.m_146908_());
        Vec3 vecsideways = vecforwards.m_82537_(vecupwards);
        float theta = this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
        float r = Mth.m_14116_((float)this.f_19796_.m_188501_()) * (float)Math.tan(gunSpread);
        float a1 = Mth.m_14089_((float)theta) * r;
        float a2 = Mth.m_14031_((float)theta) * r;
        return vecforwards.m_82549_(vecsideways.m_82490_((double)a1)).m_82549_(vecupwards.m_82490_((double)a2)).m_82541_();
    }

    public void setWeapon(ItemStack weapon) {
        this.weapon = weapon.m_41777_();
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setAdditionalDamage(float additionalDamage) {
        this.additionalDamage = additionalDamage;
    }

    public double getModifiedGravity() {
        return this.modifiedGravity;
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateHeading();
        this.onProjectileTick();
        if (!this.m_9236_().m_5776_()) {
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            Object result = ProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            if (result.m_6662_() != HitResult.Type.MISS) {
                endVec = result.m_82450_();
            }
            List<EntityResult> hitEntities = null;
            int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COLLATERAL.get()), (ItemStack)this.weapon);
            if (level == 0 && !this.projectile.isCollateral()) {
                EntityResult entityResult = this.findEntityOnPath(startVec, endVec);
                if (entityResult != null) {
                    hitEntities = Collections.singletonList(entityResult);
                }
            } else {
                hitEntities = this.findEntitiesOnPath(startVec, endVec);
            }
            if (hitEntities != null && hitEntities.size() > 0) {
                for (EntityResult entityResult : hitEntities) {
                    result = new ExtendedEntityRayTraceResult(entityResult);
                    if (((EntityHitResult)result).m_82443_() instanceof Player) {
                        Player player = (Player)((EntityHitResult)result).m_82443_();
                        if (this.shooter instanceof Player && !((Player)this.shooter).m_7099_(player)) {
                            result = null;
                        }
                    }
                    if (result == null) continue;
                    this.onHit((HitResult)result, startVec, endVec);
                }
            } else {
                this.onHit((HitResult)result, startVec, endVec);
            }
        }
        double nextPosX = this.m_20185_() + this.m_20184_().m_7096_();
        double nextPosY = this.m_20186_() + this.m_20184_().m_7098_();
        double nextPosZ = this.m_20189_() + this.m_20184_().m_7094_();
        this.m_6034_(nextPosX, nextPosY, nextPosZ);
        if (this.projectile.isGravity()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
        }
        if (this.f_19797_ >= this.life) {
            if (this.m_6084_()) {
                this.onExpired();
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void onProjectileTick() {
        if (!this.m_9236_().f_46443_ && this.m_5842_()) {
            ServerPlayHandler.sendParticlesToAll((ServerLevel)this.m_9236_(), ParticleTypes.f_123795_, true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 2, 0.1, 0.1, 0.1, 0.0);
        }
    }

    protected void impactEffect() {
    }

    protected void onExpired() {
    }

    private void playSoundForNearbyPlayers(Entity entity) {
        if (entity == this.shooter) {
            return;
        }
        LivingEntity livingEntity = this.shooter;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.m_9236_().m_6269_(player, (Entity)this, (SoundEvent)ModSounds.BULLET_CLOSE.get(), SoundSource.PLAYERS, 0.7f, 0.0f);
        } else {
            this.m_5496_((SoundEvent)ModSounds.BULLET_CLOSE.get(), 0.7f, 1.0f);
        }
    }

    @Nullable
    protected EntityResult findEntityOnPath(Vec3 startVec, Vec3 endVec) {
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            Vec3 hitPos;
            double distanceToHit;
            EntityResult result;
            if (entity.equals((Object)this.shooter) || (result = this.getHitResult(entity, startVec, endVec)) == null || !((distanceToHit = startVec.m_82554_(hitPos = result.getHitPos())) < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        List flyByEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(3.0), PROJECTILE_TARGETS);
        for (Entity entity : flyByEntities) {
            if (entity == this.shooter || !(entity instanceof Player)) continue;
            this.playSoundForNearbyPlayers(this);
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot) : null;
    }

    @Nullable
    protected List<EntityResult> findEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            EntityResult result;
            if (entity.equals((Object)this.shooter) || (result = this.getHitResult(entity, startVec, endVec)) == null) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    private EntityResult getHitResult(Entity entity, Vec3 startVec, Vec3 endVec) {
        double expandHeight = entity instanceof Player && !entity.m_6047_() ? 0.0625 : 0.0;
        AABB boundingBox = entity.m_20191_();
        if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue() && entity instanceof ServerPlayer && this.shooter instanceof ServerPlayer) {
            int ping = (int)Math.floor((double)((ServerPlayer)this.shooter).f_8943_ / 1000.0 * 20.0 + 0.5);
            boundingBox = BoundingBoxManager.getBoundingBox((Player)entity, ping);
        }
        boundingBox = boundingBox.m_82363_(0.0, expandHeight, 0.0);
        Vec3 hitPos = boundingBox.m_82371_(startVec, endVec).orElse(null);
        Vec3 grownHitPos = boundingBox.m_82377_(((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue(), 0.0, ((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue()).m_82371_(startVec, endVec).orElse(null);
        if (hitPos == null && grownHitPos != null) {
            BlockHitResult raytraceresult = ProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, grownHitPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
                return null;
            }
            hitPos = grownHitPos;
        }
        boolean headshot = false;
        if (((Boolean)Config.COMMON.gameplay.enableHeadShots.get()).booleanValue() && entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            ItemStack helmet;
            AABB box;
            IHeadshotBox<LivingEntity> headshotBox = BoundingBoxManager.getHeadshotBoxes(entity.m_6095_());
            if (headshotBox != null && (box = headshotBox.getHeadshotBox((LivingEntity)entity)) != null) {
                Optional headshotHitPos = (box = box.m_82386_(boundingBox.m_82399_().f_82479_, boundingBox.f_82289_, boundingBox.m_82399_().f_82481_)).m_82371_(startVec, endVec);
                if (!headshotHitPos.isPresent()) {
                    box = box.m_82377_(((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue(), 0.0, ((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue());
                    headshotHitPos = box.m_82371_(startVec, endVec);
                }
                if (headshotHitPos.isPresent() && (hitPos == null || ((Vec3)headshotHitPos.get()).m_82554_(hitPos) < 0.5)) {
                    hitPos = (Vec3)headshotHitPos.get();
                    headshot = true;
                }
            }
            if (headshot && entity instanceof LivingEntity && !(helmet = (livingEntity = (LivingEntity)entity).m_6844_(EquipmentSlot.HEAD)).m_41619_()) {
                this.helmetHit(livingEntity, helmet);
            }
        }
        if (hitPos == null) {
            return null;
        }
        return new EntityResult(entity, hitPos, headshot);
    }

    private void checkHelmet() {
    }

    private boolean helmetHit(LivingEntity livingEntity, ItemStack helmet) {
        int durabilityLeft = helmet.m_41776_() - helmet.m_41773_();
        if (!(livingEntity instanceof Player) && ((Boolean)Config.COMMON.gameplay.mobsDropHelmets.get()).booleanValue()) {
            if (livingEntity.m_19880_().contains("EliteGunner") && this.f_19796_.m_188499_()) {
                return false;
            }
            if (!livingEntity.m_6095_().m_204039_(ModTags.Entities.VERY_HEAVY) && (this.f_19796_.m_188501_() < 0.4f || this.getAdvantage().equals((Object)ModTags.Entities.VERY_HEAVY.f_203868_()))) {
                if (this.f_19796_.m_188499_() || this.getAdvantage().equals((Object)ModTags.Entities.VERY_HEAVY.f_203868_())) {
                    this.removeHelmet(livingEntity, helmet);
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, false));
                }
                if (durabilityLeft <= 1) {
                    helmet.m_41622_(1, livingEntity, e -> e.m_21166_(EquipmentSlot.HEAD));
                    livingEntity.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                } else {
                    helmet.m_41721_(helmet.m_41776_() - 1);
                }
                return false;
            }
        }
        return true;
    }

    public void removeHelmet(LivingEntity livingEntity, ItemStack helmet) {
        if (this.ignoreEntity((Entity)livingEntity)) {
            return;
        }
        if (helmet.getEnchantmentLevel(Enchantments.f_44975_) != 0) {
            return;
        }
        livingEntity.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        if (!helmet.m_41619_() && !livingEntity.m_9236_().f_46443_) {
            livingEntity.m_9236_().m_5594_(null, livingEntity.m_20097_(), (SoundEvent)ModSounds.MEDAL_HEADSHOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            DynamicHelmet flyingHelmet = new DynamicHelmet(this.m_9236_(), livingEntity.m_20185_(), livingEntity.m_20188_() - 0.5, livingEntity.m_20189_(), helmet);
            flyingHelmet.m_146926_(livingEntity.m_146909_());
            flyingHelmet.m_146922_(livingEntity.m_146908_());
            flyingHelmet.m_20334_((this.f_19796_.m_188500_() - 0.5) * 0.3, 0.5 + this.f_19796_.m_188500_() * 0.2, (this.f_19796_.m_188500_() - 0.5) * 0.3);
            livingEntity.m_9236_().m_7967_((Entity)flyingHelmet);
        }
    }

    private void onHit(HitResult result, Vec3 startVec, Vec3 endVec) {
        if (MinecraftForge.EVENT_BUS.post((Event)new GunProjectileHitEvent(result, this))) {
            return;
        }
        if (result instanceof BlockHitResult) {
            int fireStarterLevel;
            BlockHitResult blockHitResult = (BlockHitResult)result;
            BlockPos pos = blockHitResult.m_82425_();
            BlockState state = this.m_9236_().m_8055_(pos);
            if (blockHitResult.m_6662_() == HitResult.Type.MISS || this.projectile.ignoresBlocks() || state.m_60713_((Block)ModBlocks.DYNAMIC_LIGHT.get())) {
                return;
            }
            Vec3 hitVec = result.m_82450_();
            Block block = state.m_60734_();
            if (this.weapon.m_41720_() != ModItems.SUBSONIC_RIFLE.get() && this.weapon.m_41720_() != ModItems.SUPERSONIC_SHOTGUN.get() && this.weapon.m_41720_() != ModItems.HYPERSONIC_CANNON.get()) {
                this.m_9236_().m_220400_((Entity)this, GameEvent.f_157794_, this.m_20318_(1.0f));
            }
            if (this.shooter instanceof Player) {
                float destroySpeed;
                float destroySpeed2;
                float destroySpeed3;
                if (((Boolean)Config.COMMON.gameplay.griefing.enableGlassBreaking.get()).booleanValue() && state.m_204336_(ModTags.Blocks.FRAGILE) && (destroySpeed3 = state.m_60800_((BlockGetter)this.m_9236_(), pos)) >= 0.0f) {
                    float chance = ((Double)Config.COMMON.gameplay.griefing.fragileBaseBreakChance.get()).floatValue() / (destroySpeed3 + 1.0f);
                    if (this.f_19796_.m_188501_() < chance) {
                        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46136_)) {
                            ItemEntity seedsEntity;
                            ItemStack seedsStack;
                            int melonSeeds;
                            if (state.m_60713_(Blocks.f_50186_)) {
                                int melonCount = RANDOM.nextInt(6) + 1;
                                ItemStack melonStack = new ItemStack((ItemLike)Items.f_42575_, melonCount);
                                ItemEntity melonEntity = new ItemEntity(this.m_9236_(), pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, melonStack);
                                this.m_9236_().m_7967_((Entity)melonEntity);
                                int melonSeeds2 = RANDOM.nextInt(2) + 1;
                                ItemStack seedsStack2 = new ItemStack((ItemLike)Items.f_42578_, melonSeeds2);
                                ItemEntity seedsEntity2 = new ItemEntity(this.m_9236_(), pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, seedsStack2);
                                this.m_9236_().m_7967_((Entity)seedsEntity2);
                            }
                            if (state.m_60713_(Blocks.f_50143_) || state.m_60713_(Blocks.f_50144_)) {
                                melonSeeds = RANDOM.nextInt(6) + 1;
                                seedsStack = new ItemStack((ItemLike)Items.f_42577_, melonSeeds);
                                seedsEntity = new ItemEntity(this.m_9236_(), pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, seedsStack);
                                this.m_9236_().m_7967_((Entity)seedsEntity);
                            }
                            if (state.m_60713_(Blocks.f_50133_)) {
                                melonSeeds = RANDOM.nextInt(2) + 1;
                                seedsStack = new ItemStack((ItemLike)Items.f_42577_, melonSeeds);
                                seedsEntity = new ItemEntity(this.m_9236_(), pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, seedsStack);
                                this.m_9236_().m_7967_((Entity)seedsEntity);
                                ItemStack pumpkinStack = new ItemStack((ItemLike)Items.f_42047_, 1);
                                ItemEntity pumpkiEntity = new ItemEntity(this.m_9236_(), pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, pumpkinStack);
                                this.m_9236_().m_7967_((Entity)pumpkiEntity);
                            }
                            if (state.m_60713_(Blocks.f_50262_)) {
                                melonSeeds = RANDOM.nextInt(3) + 1;
                                seedsStack = new ItemStack((ItemLike)Items.f_42533_, melonSeeds);
                                seedsEntity = new ItemEntity(this.m_9236_(), pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, seedsStack);
                                this.m_9236_().m_7967_((Entity)seedsEntity);
                            }
                            if (state.m_60713_(Blocks.f_50718_) || state.m_60713_(Blocks.f_50717_)) {
                                melonSeeds = RANDOM.nextInt(3) + 1;
                                seedsStack = new ItemStack((ItemLike)Items.f_42784_, melonSeeds);
                                seedsEntity = new ItemEntity(this.m_9236_(), pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, seedsStack);
                                this.m_9236_().m_7967_((Entity)seedsEntity);
                            }
                            if (state.m_60713_((Block)ModBlocks.BOOHIVE.get()) || state.m_60713_((Block)ModBlocks.BOO_NEST.get())) {
                                melonSeeds = RANDOM.nextInt(5) + 1;
                                seedsStack = new ItemStack((ItemLike)ModItems.ECTOPLASM.get(), melonSeeds);
                                seedsEntity = new ItemEntity(this.m_9236_(), pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, seedsStack);
                                this.m_9236_().m_7967_((Entity)seedsEntity);
                            }
                        }
                        if (!(state.m_60713_(Blocks.f_50133_) || state.m_60713_(Blocks.f_50143_) || state.m_60713_(Blocks.f_50144_))) {
                            this.m_9236_().m_46961_(pos, ((Boolean)Config.COMMON.gameplay.griefing.fragileBlockDrops.get()).booleanValue());
                        } else {
                            this.m_9236_().m_46961_(pos, false);
                        }
                        if (state != null && state.m_60713_(Blocks.f_50126_)) {
                            boolean isIceWater = this.m_9236_().m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49990_);
                            if (!isIceWater) {
                                int neighbourIce = 0;
                                if (this.m_9236_().m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50126_)) {
                                    ++neighbourIce;
                                }
                                if (this.m_9236_().m_8055_(pos.m_122029_()).m_60713_(Blocks.f_50126_)) {
                                    ++neighbourIce;
                                }
                                if (this.m_9236_().m_8055_(pos.m_122024_()).m_60713_(Blocks.f_50126_)) {
                                    ++neighbourIce;
                                }
                                if (this.m_9236_().m_8055_(pos.m_122012_()).m_60713_(Blocks.f_50126_)) {
                                    ++neighbourIce;
                                }
                                if (this.m_9236_().m_8055_(pos.m_122019_()).m_60713_(Blocks.f_50126_)) {
                                    ++neighbourIce;
                                }
                                if (this.m_9236_().m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50126_)) {
                                    ++neighbourIce;
                                }
                                if (neighbourIce > 2) {
                                    isIceWater = true;
                                }
                            }
                            if (isIceWater) {
                                this.m_9236_().m_7731_(pos, Blocks.f_49990_.m_49966_(), 0);
                            }
                        }
                    }
                }
                boolean advantageFlag = false;
                if (this.getAdvantage() != null) {
                    if (((Boolean)Config.COMMON.gameplay.gunAdvantage.get()).booleanValue() && this.getAdvantage().equals((Object)ModTags.Entities.HEAVY.f_203868_()) || this.getAdvantage().equals((Object)ModTags.Entities.VERY_HEAVY.f_203868_())) {
                        advantageFlag = true;
                    } else if (!((Boolean)Config.COMMON.gameplay.gunAdvantage.get()).booleanValue()) {
                        advantageFlag = true;
                    }
                }
                boolean explosiveAmmo = false;
                if (Gun.hasAttachmentEquipped(this.weapon, IAttachment.Type.BARREL) && Gun.getAttachment(IAttachment.Type.BARREL, this.weapon).m_41720_() == ModItems.EXPLOSIVE_MUZZLE.get()) {
                    explosiveAmmo = true;
                }
                boolean fireAmmo = this instanceof BlazeProjectileEntity;
                boolean breakBlocks = true;
                if (!(this.shooter instanceof Player) && !this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                    breakBlocks = false;
                }
                if (breakBlocks && ((Boolean)Config.COMMON.gameplay.griefing.enableWoodBreaking.get()).booleanValue() && (state.m_204336_(BlockTags.f_144280_) && state.m_204336_(BlockTags.f_13069_) || state.m_204336_(ModTags.Blocks.WOOD)) && (fireAmmo || advantageFlag || explosiveAmmo) && (destroySpeed2 = state.m_60800_((BlockGetter)this.m_9236_(), pos)) >= 0.0f) {
                    float chance = ((Double)Config.COMMON.gameplay.griefing.woodBaseBreakChance.get()).floatValue() / (destroySpeed2 + 1.0f);
                    if (this.f_19796_.m_188501_() < chance) {
                        this.m_9236_().m_46961_(pos, false);
                    }
                }
                if (explosiveAmmo && breakBlocks && ((Boolean)Config.COMMON.gameplay.griefing.enableStoneBreaking.get()).booleanValue() && (state.m_204336_(BlockTags.f_144282_) && state.m_204336_(BlockTags.f_13069_) || state.m_204336_(ModTags.Blocks.STONE)) && (destroySpeed = state.m_60800_((BlockGetter)this.m_9236_(), pos)) >= 0.0f) {
                    float chance = ((Double)Config.COMMON.gameplay.griefing.stoneBaseBreakChance.get()).floatValue() / (destroySpeed + 1.0f);
                    if (this.f_19796_.m_188501_() < chance) {
                        this.m_9236_().m_46961_(pos, false);
                    }
                }
            }
            if (!state.m_247087_()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (block instanceof IDamageable) {
                ((IDamageable)block).onBlockDamaged(this.m_9236_(), state, pos, this, this.getDamage(), (int)Math.ceil((double)this.getDamage() / 2.0) + 1);
            }
            this.onHitBlock(state, pos, blockHitResult.m_82434_(), hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_);
            if (block instanceof TargetBlock) {
                TargetBlock targetBlock = (TargetBlock)block;
                int power = ReflectionUtil.updateTargetBlock(targetBlock, (LevelAccessor)this.m_9236_(), state, blockHitResult, this);
                LivingEntity livingEntity = this.shooter;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    serverPlayer.m_36220_(Stats.f_12953_);
                    CriteriaTriggers.f_10561_.m_70211_(serverPlayer, (Entity)this, blockHitResult.m_82450_(), power);
                }
            }
            if (block instanceof BellBlock) {
                BellBlock bell = (BellBlock)block;
                bell.m_49712_(this.m_9236_(), pos, blockHitResult.m_82434_());
            }
            if ((fireStarterLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.FIRE_STARTER.get()), (ItemStack)this.weapon)) > 0 && ((Boolean)Config.COMMON.gameplay.griefing.setFireToBlocks.get()).booleanValue() && this.m_9236_().m_213780_().m_188501_() > 0.7f) {
                BlockPos offsetPos = pos.m_121945_(blockHitResult.m_82434_());
                if (BaseFireBlock.m_49255_((Level)this.m_9236_(), (BlockPos)offsetPos, (Direction)blockHitResult.m_82434_())) {
                    BlockState fireState = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)offsetPos);
                    this.m_9236_().m_7731_(offsetPos, fireState, 11);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, hitVec.f_82479_ - 1.0 + this.f_19796_.m_188500_() * 2.0, hitVec.f_82480_, hitVec.f_82481_ - 1.0 + this.f_19796_.m_188500_() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        if (result instanceof ExtendedEntityRayTraceResult) {
            Player player;
            ExtendedEntityRayTraceResult entityHitResult = (ExtendedEntityRayTraceResult)result;
            Entity entity = entityHitResult.m_82443_();
            if (entity.m_19879_() == this.shooterId) {
                return;
            }
            if (entity.m_20363_((Entity)this.shooter)) {
                return;
            }
            LivingEntity hitVec = this.shooter;
            if (hitVec instanceof Player && entity.m_20367_((Entity)(player = (Player)hitVec))) {
                return;
            }
            if (this.ignoreEntity(entity)) {
                return;
            }
            int fireStarterLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.FIRE_STARTER.get()), (ItemStack)this.weapon);
            if (fireStarterLevel > 0) {
                entity.m_20254_(2);
            }
            if (Gun.hasAttachmentEquipped(this.weapon, IAttachment.Type.BARREL) && Gun.getAttachment(IAttachment.Type.BARREL, this.weapon).m_41720_() == ModItems.EXPLOSIVE_MUZZLE.get()) {
                PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageExplosiveAmmo(result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_));
            }
            this.onHitEntity(entity, result.m_82450_(), startVec, endVec, entityHitResult.isHeadshot());
            int collateralLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COLLATERAL.get()), (ItemStack)this.weapon);
            if (!(collateralLevel != 0 || this.ignoreEntity(entity) || this instanceof RocketEntity || this.projectile.isCollateral() || this instanceof FlameProjectileEntity)) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (this.shooter instanceof Player) {
                entity.f_19802_ = 0;
            }
        }
    }

    public ResourceLocation getAdvantage() {
        if (!((Boolean)Config.COMMON.gameplay.gunAdvantage.get()).booleanValue()) {
            return ModTags.Entities.NONE.f_203868_();
        }
        if (this.getProjectile().getAdvantage() == null) {
            return ModTags.Entities.NONE.f_203868_();
        }
        return this.getProjectile().getAdvantage();
    }

    public float advantageMultiplier(Entity entity) {
        ResourceLocation advantage = this.getAdvantage();
        float advantageMultiplier = 1.0f;
        if (!advantage.equals((Object)ModTags.Entities.NONE.f_203868_())) {
            if (entity.m_6095_().m_204039_(ModTags.Entities.HEAVY)) {
                advantageMultiplier = advantage.equals((Object)ModTags.Entities.HEAVY.f_203868_()) || advantage.equals((Object)ModTags.Entities.VERY_HEAVY.f_203868_()) ? 1.25f : 0.5f;
            } else if (entity.m_6095_().m_204039_(ModTags.Entities.VERY_HEAVY)) {
                advantageMultiplier = advantage.equals((Object)ModTags.Entities.VERY_HEAVY.f_203868_()) ? 1.0f : (advantage.equals((Object)ModTags.Entities.HEAVY.f_203868_()) ? 0.5f : 0.25f);
            }
            if (advantage.equals((Object)ModTags.Entities.UNDEAD.f_203868_())) {
                if (this.isUndead(entity) || entity.m_6095_().m_204039_(ModTags.Entities.GHOST)) {
                    advantageMultiplier = 1.25f;
                    entity.m_20254_(2);
                } else {
                    advantageMultiplier = 0.75f;
                }
            }
        }
        return advantageMultiplier;
    }

    protected boolean ignoreEntity(Entity entity) {
        PathfinderMob pathfinderMob;
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21224_()) {
            return true;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)ttv.migami.jeg.init.ModEffects.PLAYER_BULLET_PROTECTION.get()) && this.shooter instanceof Player) {
            return true;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)ttv.migami.jeg.init.ModEffects.BULLET_PROTECTION.get())) {
            return true;
        }
        ResourceLocation advantage = this.getAdvantage();
        if (entity.m_6095_().m_204039_(ModTags.Entities.GHOST) && !advantage.equals((Object)ModTags.Entities.UNDEAD.f_203868_())) {
            return !this.getProjectile().getItem().equals((Object)ModItems.SPECTRE_ROUND.getId());
        }
        if (this.shooter.m_21205_().m_150930_((Item)ModItems.HOLY_SHOTGUN.get()) && !this.isUndead(entity) && !(entity instanceof Enemy)) {
            return true;
        }
        if (this.shooter.m_19880_().contains("GunnerPatroller") && entity.m_19880_().contains("GunnerPatroller")) {
            return true;
        }
        if (this.shooter instanceof Player && entity.m_19880_().contains("PlayerOwned")) {
            return true;
        }
        if (this.shooter.m_19880_().contains("PlayerOwned") && entity.m_19880_().contains("PlayerOwned")) {
            return true;
        }
        if (this.shooter.m_19880_().contains("PlayerOwned") && !(entity instanceof Enemy) && !(entity instanceof Player)) {
            return true;
        }
        LivingEntity livingEntity2 = this.shooter;
        return livingEntity2 instanceof PathfinderMob && (pathfinderMob = (PathfinderMob)livingEntity2).m_6095_() == entity.m_6095_() && (double)this.m_9236_().f_46441_.m_188501_() < 0.9;
    }

    protected boolean isUndead(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && ((livingEntity = (LivingEntity)entity).m_6336_().equals(MobType.f_21641_) || entity.m_6095_().m_204039_(ModTags.Entities.UNDEAD));
    }

    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        LivingEntity durabilityLeft2;
        Player player;
        float damageDivisor;
        LivingEntity livingEntity;
        float newDamage;
        if (this.ignoreEntity(entity)) {
            return;
        }
        float damage = this.getDamage();
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.weapon, this.f_19796_, damage));
        damage = newDamage;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)ttv.migami.jeg.init.ModEffects.RESONANCE.get()) && this instanceof ResonanceProjectileEntity) {
            damage = (float)((double)damage * ((double)(1 + livingEntity.m_21124_((MobEffect)ttv.migami.jeg.init.ModEffects.RESONANCE.get()).m_19564_()) * 0.8));
        }
        if (((Boolean)Config.COMMON.gameplay.gunAdvantage.get()).booleanValue()) {
            damage *= this.advantageMultiplier(entity);
        }
        if (headshot) {
            damage *= this.getProjectile().getHeadshotMultiplier();
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, this.shooter);
        if (entity instanceof EnderMan && !(this instanceof SonicProjectileEntity)) {
            source = this.shooter.m_269291_().m_269299_((Entity)this, this.shooter);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity;
            if (JustEnoughGuns.devilFruitsLoaded && this.projectile.hitsRubberFruit() && livingEntity2.m_21023_((MobEffect)ModEffects.RUBBER_FRUIT.get())) {
                entity.m_7334_((Entity)this);
                return;
            }
        }
        float f = damageDivisor = this.shooter.m_9236_().m_46791_() != Difficulty.HARD ? 2.0f : 1.5f;
        if (!(this.shooter instanceof Player)) {
            damage /= damageDivisor;
        }
        if (headshot && entity instanceof Player) {
            player = (Player)entity;
            if (((Boolean)Config.COMMON.gameplay.playersDropHelmets.get()).booleanValue() && (!player.m_21023_((MobEffect)ttv.migami.jeg.init.ModEffects.BULLET_PROTECTION.get()) || this.shooter instanceof Player && !player.m_21023_((MobEffect)ttv.migami.jeg.init.ModEffects.PLAYER_BULLET_PROTECTION.get()))) {
                ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
                int durabilityLeft2 = helmet.m_41776_() - helmet.m_41773_();
                if (player.m_6844_(EquipmentSlot.HEAD).m_150930_(Items.f_42354_) && this.getAdvantage().equals((Object)ModTags.Entities.VERY_HEAVY.f_203868_())) {
                    if (durabilityLeft2 <= 1 && helmet.getEnchantmentLevel(Enchantments.f_44962_) == 0) {
                        helmet.m_41622_(1, (LivingEntity)player, e -> e.m_21166_(EquipmentSlot.HEAD));
                        player.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    } else {
                        helmet.m_41721_(helmet.m_41776_() - 1);
                    }
                    if (this.projectile.getDamage() > player.m_21223_() && player.m_21223_() > 10.0f) {
                        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                            this.removeHelmet((LivingEntity)player, helmet);
                        }
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, false));
                        damage = player.m_21223_() - 0.5f;
                    }
                }
            }
        }
        entity.m_6469_(source, damage);
        if (!((Boolean)Config.COMMON.gameplay.enableKnockback.get()).booleanValue()) {
            entity.m_20334_(0.0, 0.0, 0.0);
        }
        if (this.potionEffect.getPotionEffect() != null && !this.potionEffect.isSelfApplied() && entity instanceof LivingEntity) {
            LivingEntity livingEntity3 = (LivingEntity)entity;
            MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(this.potionEffect.getPotionEffect());
            if (effect != null) {
                livingEntity3.m_7292_(new MobEffectInstance(effect, this.potionEffect.getPotionEffectDuration(), this.potionEffect.getPotionEffectStrength()));
            }
        }
        if (!entity.m_9236_().f_46443_) {
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (int)damage / 2, (double)(entity.m_20205_() / 2.0f), (double)(entity.m_20206_() / 2.0f), (double)(entity.m_20205_() / 2.0f), 0.1);
        }
        if ((durabilityLeft2 = this.shooter) instanceof Player) {
            player = (Player)durabilityLeft2;
            if (entity instanceof LivingEntity) {
                int hitType;
                LivingEntity livingEntity4 = (LivingEntity)entity;
                int n = critical ? 2 : (hitType = headshot ? 1 : 0);
                if (headshot) {
                    Player player2;
                    if (livingEntity4 instanceof Player && (player2 = (Player)livingEntity4).m_7500_() || livingEntity4.m_5833_()) {
                        return;
                    }
                    if (livingEntity4.m_21224_()) {
                        Level level = this.m_9236_();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            if (!entity.m_19880_().contains("JEGDying")) {
                                if (this.weapon.m_41783_() != null && this.weapon.m_41783_().m_128471_("MedalsEnabled")) {
                                    PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new S2CMessageSendMedal(MedalType.COMBAT_HEADSHOT.ordinal()));
                                }
                                if (Gun.hasCosmeticEquipped(this.weapon, IAttachment.Type.KILL_EFECT)) {
                                    if (MinecraftForge.EVENT_BUS.post((Event)new KillEffectEvent.Pre(player, this.weapon, this.m_20182_(), livingEntity4))) {
                                        return;
                                    }
                                    MinecraftForge.EVENT_BUS.post((Event)new KillEffectEvent.Post(player, this.weapon, this.m_20182_(), livingEntity4));
                                }
                            }
                        }
                        entity.m_20049_("JEGDying");
                    }
                }
                PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
            }
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_));
    }

    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        if (!(this instanceof FlameProjectileEntity)) {
            PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.m_9236_().m_46745_(pos), (IMessage)new S2CMessageProjectileHitBlock(x, y, z, pos, face));
        }
        if (this instanceof BlazeProjectileEntity && ((Boolean)Config.COMMON.gameplay.griefing.setFireToBlocks.get()).booleanValue()) {
            BlockPos offsetPos = pos.m_121945_(face);
            if (this.m_9236_().m_213780_().m_188501_() > 0.5f && BaseFireBlock.m_49255_((Level)this.m_9236_(), (BlockPos)offsetPos, (Direction)face)) {
                BlockState fireState = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)offsetPos);
                this.m_9236_().m_7731_(offsetPos, fireState, 11);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, x - 1.0 + this.f_19796_.m_188500_() * 2.0, y, z - 1.0 + this.f_19796_.m_188500_() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void updateHeading() {
        double horizontalDistance = this.m_20184_().m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7094_()) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)this.m_20184_().m_7098_(), (double)horizontalDistance) * 57.29577951308232));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public Gun.Projectile getProjectile() {
        return this.projectile;
    }

    private Vec3 getVectorFromRotation(float pitch, float yaw) {
        float f = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public float getDamage() {
        float initialDamage = this.projectile.getDamage() + this.additionalDamage;
        if (this.projectile.isDamageReduceOverLife()) {
            float modifier = ((float)this.projectile.getLife() - (float)(this.f_19797_ - 1)) / (float)this.projectile.getLife();
            initialDamage *= Math.min(modifier, 1.0f);
        }
        float damage = initialDamage / (float)this.general.getProjectileAmount();
        damage = GunModifierHelper.getModifiedDamage(this.weapon, this.modifiedGun, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(this.weapon, damage);
        damage = GunEnchantmentHelper.getWitheredDamage(this.weapon, damage);
        damage = GunModifierHelper.getChargeDamage(this.weapon, damage, this.chargeProgress);
        return Math.max(0.0f, damage);
    }

    private float getCriticalDamage(ItemStack weapon, RandomSource rand, float damage) {
        float chance = GunModifierHelper.getCriticalChance(weapon);
        if (rand.m_188501_() < chance) {
            return (float)((double)damage * (Double)Config.COMMON.gameplay.criticalDamageMultiplier.get());
        }
        return damage;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public void onRemovedFromWorld() {
        this.impactEffect();
        if (!this.m_9236_().f_46443_) {
            PacketHandler.getPlayChannel().sendToNearbyPlayers(this::getDeathTargetPoint, (IMessage)new S2CMessageRemoveProjectile(this.m_19879_()));
        }
    }

    private LevelLocation getDeathTargetPoint() {
        return LevelLocation.create((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)256.0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static BlockHitResult rayTraceBlocks(Level world, ClipContext context, Predicate<BlockState> ignorePredicate) {
        return ProjectileEntity.performRayTrace(context, (rayTraceContext, blockPos) -> {
            if (JustEnoughGuns.valkyrienSkiesLoaded) {
                return RaycastUtilsKt.clipIncludeShips((Level)world, (ClipContext)context);
            }
            BlockState blockState = world.m_8055_(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = world.m_6425_(blockPos);
            Vec3 startVec = rayTraceContext.m_45702_();
            Vec3 endVec = rayTraceContext.m_45693_();
            VoxelShape blockShape = rayTraceContext.m_45694_(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockResult = world.m_45558_(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidResult = fluidShape.m_83220_(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockResult.m_82450_());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidResult.m_82450_());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vec3 Vector3d2 = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)Vector3d2.f_82479_, (double)Vector3d2.f_82480_, (double)Vector3d2.f_82481_), (BlockPos)BlockPos.m_274446_((Position)rayTraceContext.m_45693_()));
        });
    }

    private static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> p_217300_2_) {
        int blockZ;
        int blockY;
        Vec3 endVec;
        Vec3 startVec = context.m_45702_();
        if (startVec.equals((Object)(endVec = context.m_45693_()))) {
            return p_217300_2_.apply(context);
        }
        double startX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
        double startY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
        double startZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
        double endX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
        double endY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
        double endZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
        int blockX = Mth.m_14107_((double)endX);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.m_14107_((double)endY), blockZ = Mth.m_14107_((double)endZ));
        T t = hitFunction.apply(context, (BlockPos)mutablePos);
        if (t != null) {
            return t;
        }
        double deltaX = startX - endX;
        double deltaY = startY - endY;
        double deltaZ = startZ - endZ;
        int signX = Mth.m_14205_((double)deltaX);
        int signY = Mth.m_14205_((double)deltaY);
        int signZ = Mth.m_14205_((double)deltaZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
        double d12 = d9 * (signX > 0 ? 1.0 - Mth.m_14185_((double)endX) : Mth.m_14185_((double)endX));
        double d13 = d10 * (signY > 0 ? 1.0 - Mth.m_14185_((double)endY) : Mth.m_14185_((double)endY));
        double d14 = d11 * (signZ > 0 ? 1.0 - Mth.m_14185_((double)endZ) : Mth.m_14185_((double)endZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    blockX += signX;
                    d12 += d9;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                blockY += signY;
                d13 += d10;
            } else {
                blockZ += signZ;
                d14 += d11;
            }
            if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.m_122178_(blockX, blockY, blockZ))) == null) continue;
            return t1;
        }
        return p_217300_2_.apply(context);
    }

    public static void createExplosion(Entity entity, float radius, boolean forceNone) {
        DamageSource damageSource;
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            damageSource = entity.m_269291_().m_269036_(entity, (Entity)projectile.getShooter());
        } else {
            damageSource = null;
        }
        DamageSource source = damageSource;
        Explosion.BlockInteraction mode = (Boolean)Config.COMMON.gameplay.griefing.enableBlockRemovalOnExplosions.get() != false && !forceNone ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        ProjectileExplosion explosion = new ProjectileExplosion(world, entity, source, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, false, mode);
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        explosion.m_46081_().forEach(pos -> {
            if (world.m_8055_(pos).m_60734_() instanceof IExplosionDamageable) {
                ((IExplosionDamageable)world.m_8055_(pos).m_60734_()).onProjectileExploded(world, world.m_8055_(pos), (BlockPos)pos, entity);
            }
        });
        if (!explosion.m_254884_()) {
            explosion.m_46080_();
        }
        for (ServerPlayer player : ((ServerLevel)world).m_6907_()) {
            if (!(player.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()) < 4096.0)) continue;
            player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
        }
    }

    public static void createFireExplosion(Entity entity, float radius, boolean forceNone) {
        DamageSource damageSource;
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            damageSource = entity.m_269291_().m_269036_(entity, (Entity)projectile.getShooter());
        } else {
            damageSource = null;
        }
        DamageSource source = damageSource;
        Explosion.BlockInteraction mode = Explosion.BlockInteraction.KEEP;
        ProjectileExplosion explosion = new ProjectileExplosion(world, entity, source, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, true, mode);
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        BlockPos origin = entity.m_20183_();
        int fireRadius = Mth.m_14167_((float)radius);
        for (int dx = -fireRadius; dx <= fireRadius; ++dx) {
            for (int dy = -fireRadius; dy <= fireRadius; ++dy) {
                for (int dz = -fireRadius; dz <= fireRadius; ++dz) {
                    BlockState state;
                    BlockPos pos = origin.m_7918_(dx, dy, dz);
                    if (pos.m_123331_((Vec3i)origin) > (double)(radius * radius) || !(state = world.m_8055_(pos)).isFlammable((BlockGetter)world, pos, Direction.UP)) continue;
                    for (Direction dir : Direction.values()) {
                        BlockPos neighbor = pos.m_121945_(dir);
                        if (!world.m_8055_(neighbor).m_60795_() || !Blocks.f_50083_.m_49966_().m_60710_((LevelReader)world, neighbor)) continue;
                        world.m_7731_(neighbor, Blocks.f_50083_.m_49966_(), 11);
                    }
                }
            }
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.projectile = new Gun.Projectile();
        this.projectile.deserializeNBT(compound.m_128469_("Projectile"));
        this.potionEffect = new Gun.PotionEffect();
        this.potionEffect.deserializeNBT(compound.m_128469_("PotionEffect"));
        this.general = new Gun.General();
        this.general.deserializeNBT(compound.m_128469_("General"));
        this.modifiedGravity = compound.m_128459_("ModifiedGravity");
        this.life = compound.m_128451_("MaxLife");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("Projectile", (Tag)this.projectile.serializeNBT());
        compound.m_128365_("PotionEffect", (Tag)this.potionEffect.serializeNBT());
        compound.m_128365_("General", (Tag)this.general.serializeNBT());
        compound.m_128347_("ModifiedGravity", this.modifiedGravity);
        compound.m_128405_("MaxLife", this.life);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.projectile.serializeNBT());
        buffer.m_130079_(this.potionEffect.serializeNBT());
        buffer.m_130079_(this.general.serializeNBT());
        buffer.writeInt(this.shooterId);
        BufferUtil.writeItemStackToBufIgnoreTag((ByteBuf)buffer, this.item);
        buffer.writeDouble(this.modifiedGravity);
        buffer.m_130130_(this.life);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.projectile = new Gun.Projectile();
        this.projectile.deserializeNBT(buffer.m_130260_());
        this.potionEffect = new Gun.PotionEffect();
        this.potionEffect.deserializeNBT(buffer.m_130260_());
        this.general = new Gun.General();
        this.general.deserializeNBT(buffer.m_130260_());
        this.shooterId = buffer.readInt();
        this.item = BufferUtil.readItemStackFromBufIgnoreTag((ByteBuf)buffer);
        this.modifiedGravity = buffer.readDouble();
        this.life = buffer.m_130242_();
        this.entitySize = new EntityDimensions(this.projectile.getSize(), this.projectile.getSize(), false);
    }

    public static class EntityResult {
        private final Entity entity;
        private final Vec3 hitVec;
        private final boolean headshot;

        public EntityResult(Entity entity, Vec3 hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Vec3 getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }
    }
}

