/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.item;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import ttv.migami.jeg.entity.throwable.ThrowableGrenadeEntity;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.item.AmmoItem;

public class GrenadeItem
extends AmmoItem {
    protected int maxCookTime;

    public GrenadeItem(Item.Properties properties, int maxCookTime) {
        super(properties);
        this.maxCookTime = maxCookTime;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return this.maxCookTime;
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        if (!this.canCook()) {
            return;
        }
        int duration = this.m_8105_(stack) - count;
        if (duration == 10) {
            level.m_220400_((Entity)player, GameEvent.f_157776_, player.m_20318_(1.0f));
            player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.ITEM_GRENADE_PIN.get(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        Player player;
        ItemStack stack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        if (!worldIn.m_5776_() && playerIn instanceof Player && (player = playerIn).m_5842_() && this == ModItems.GRENADE.get()) {
            player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.WATER_BOMB.get()));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (this.canCook() && !worldIn.m_5776_() && !entityLiving.m_5842_()) {
            ThrowableGrenadeEntity grenade = this.create(stack, worldIn, entityLiving, 0);
            if (!(entityLiving instanceof Player) || !((Player)entityLiving).m_7500_()) {
                stack.m_41774_(1);
            }
            grenade.onDeath();
            if (entityLiving instanceof Player) {
                ((Player)entityLiving).m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
        return stack;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        int duration;
        if (!worldIn.m_5776_() && !entityLiving.m_5842_() && (duration = this.m_8105_(stack) - timeLeft) >= 10) {
            ThrowableGrenadeEntity grenade = this.create(stack, worldIn, entityLiving, this.maxCookTime - duration);
            if (!(entityLiving instanceof Player) || !((Player)entityLiving).m_7500_()) {
                stack.m_41774_(1);
            }
            grenade.m_37251_((Entity)entityLiving, entityLiving.m_146909_(), entityLiving.m_146908_(), 0.0f, Math.min(1.0f, (float)duration / 10.0f), 1.0f);
            worldIn.m_7967_((Entity)grenade);
            this.onThrown(worldIn, grenade);
            if (entityLiving instanceof Player) {
                ((Player)entityLiving).m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public ThrowableGrenadeEntity create(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        return new ThrowableGrenadeEntity(world, entity, timeLeft);
    }

    public boolean canCook() {
        return true;
    }

    protected void onThrown(Level world, ThrowableGrenadeEntity entity) {
    }
}

