/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.BlockConjured;
import vazkii.psi.common.block.base.ModBlocks;

public class TileConjured
extends BlockEntity {
    @ObjectHolder(registryName="minecraft:block_entity_type", value="psi:conjured")
    public static BlockEntityType<TileConjured> TYPE;
    private static final String TAG_COLORIZER = "colorizer";
    public ItemStack colorizer = ItemStack.f_41583_;

    public TileConjured(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public void doParticles(Level worldIn) {
        int color = Psi.proxy.getColorForColorizer(this.colorizer);
        float r = (float)PsiRenderHelper.r(color) / 255.0f;
        float g = (float)PsiRenderHelper.g(color) / 255.0f;
        float b = (float)PsiRenderHelper.b(color) / 255.0f;
        BlockState state = this.m_58904_().m_8055_(this.m_58899_());
        if (state.m_60734_() == ModBlocks.conjured && ((Boolean)state.m_61143_((Property)BlockConjured.SOLID)).booleanValue()) {
            boolean[] edges = new boolean[12];
            Arrays.fill(edges, true);
            if (((Boolean)state.m_61143_((Property)BlockConjured.BLOCK_DOWN)).booleanValue()) {
                this.removeEdges(edges, 0, 1, 2, 3);
            }
            if (((Boolean)state.m_61143_((Property)BlockConjured.BLOCK_UP)).booleanValue()) {
                this.removeEdges(edges, 4, 5, 6, 7);
            }
            if (((Boolean)state.m_61143_((Property)BlockConjured.BLOCK_NORTH)).booleanValue()) {
                this.removeEdges(edges, 3, 7, 8, 11);
            }
            if (((Boolean)state.m_61143_((Property)BlockConjured.BLOCK_SOUTH)).booleanValue()) {
                this.removeEdges(edges, 1, 5, 9, 10);
            }
            if (((Boolean)state.m_61143_((Property)BlockConjured.BLOCK_EAST)).booleanValue()) {
                this.removeEdges(edges, 2, 6, 10, 11);
            }
            if (((Boolean)state.m_61143_((Property)BlockConjured.BLOCK_WEST)).booleanValue()) {
                this.removeEdges(edges, 0, 4, 8, 9);
            }
            double x = this.m_58899_().m_123341_();
            double y = this.m_58899_().m_123342_();
            double z = this.m_58899_().m_123343_();
            this.makeParticle(worldIn, edges[0], r, g, b, x + 0.0, y + 0.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(worldIn, edges[1], r, g, b, x + 0.0, y + 0.0, z + 1.0, 1.0, 0.0, 0.0);
            this.makeParticle(worldIn, edges[2], r, g, b, x + 1.0, y + 0.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(worldIn, edges[3], r, g, b, x + 0.0, y + 0.0, z + 0.0, 1.0, 0.0, 0.0);
            this.makeParticle(worldIn, edges[4], r, g, b, x + 0.0, y + 1.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(worldIn, edges[5], r, g, b, x + 0.0, y + 1.0, z + 1.0, 1.0, 0.0, 0.0);
            this.makeParticle(worldIn, edges[6], r, g, b, x + 1.0, y + 1.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(worldIn, edges[7], r, g, b, x + 0.0, y + 1.0, z + 0.0, 1.0, 0.0, 0.0);
            this.makeParticle(worldIn, edges[8], r, g, b, x + 0.0, y + 0.0, z + 0.0, 0.0, 1.0, 0.0);
            this.makeParticle(worldIn, edges[9], r, g, b, x + 0.0, y + 0.0, z + 1.0, 0.0, 1.0, 0.0);
            this.makeParticle(worldIn, edges[10], r, g, b, x + 1.0, y + 0.0, z + 1.0, 0.0, 1.0, 0.0);
            this.makeParticle(worldIn, edges[11], r, g, b, x + 1.0, y + 0.0, z + 0.0, 0.0, 1.0, 0.0);
        } else if (Math.random() < 0.5) {
            float w = 0.15f;
            float h = 0.05f;
            double x = (double)this.m_58899_().m_123341_() + 0.5 + (Math.random() - 0.5) * (double)w;
            double y = (double)this.m_58899_().m_123342_() + 0.25 + (Math.random() - 0.5) * (double)h;
            double z = (double)this.m_58899_().m_123343_() + 0.5 + (Math.random() - 0.5) * (double)w;
            float s = 0.2f + (float)Math.random() * 0.1f;
            float m = 0.01f + (float)Math.random() * 0.015f;
            Psi.proxy.wispFX(worldIn, x, y, z, r, g, b, s, -m);
        }
    }

    public void makeParticle(Level worldIn, boolean doit, float r, float g, float b, double xp, double yp, double zp, double xv, double yv, double zv) {
        if (doit) {
            float m = 0.1f;
            Psi.proxy.sparkleFX(worldIn, xp, yp, zp, r, g, b, (float)(xv *= (double)m), (float)(yv *= (double)m), (float)(zv *= (double)m), 2.75f, 15);
        }
    }

    public void removeEdges(boolean[] edges, int ... posArray) {
        for (int i : posArray) {
            edges[i] = false;
        }
    }

    @Nonnull
    public void m_183515_(CompoundTag cmp) {
        super.m_183515_(cmp);
        if (!this.colorizer.m_41619_()) {
            cmp.m_128365_(TAG_COLORIZER, (Tag)this.colorizer.m_41739_(new CompoundTag()));
        }
    }

    public void m_142466_(CompoundTag cmp) {
        super.m_142466_(cmp);
        this.readPacketNBT(cmp);
    }

    public void readPacketNBT(CompoundTag cmp) {
        this.colorizer = cmp.m_128441_(TAG_COLORIZER) ? ItemStack.m_41712_((CompoundTag)cmp.m_128469_(TAG_COLORIZER)) : ItemStack.f_41583_;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag cmp = new CompoundTag();
        this.m_183515_(cmp);
        return cmp;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt != null && pkt.m_131708_() != null) {
            this.readPacketNBT(pkt.m_131708_());
        }
    }
}

