/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.Commands;
import com.qendolin.betterclouds.clouds.ChunkedGenerator;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Mesh;
import com.qendolin.betterclouds.clouds.PerfTimer;
import com.qendolin.betterclouds.clouds.shaders.CoverageShader;
import com.qendolin.betterclouds.clouds.shaders.DebugShader;
import com.qendolin.betterclouds.clouds.shaders.DepthShader;
import com.qendolin.betterclouds.clouds.shaders.ShaderParameters;
import com.qendolin.betterclouds.clouds.shaders.ShadingShader;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.mixin.runtime.BufferRendererAccessor;
import com.qendolin.betterclouds.mixin.runtime.VertexBufferAccessor;
import com.qendolin.betterclouds.telemetry.Telemetry;
import com.qendolin.betterclouds.util.RenderHelper;
import java.io.Closeable;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.lwjgl.opengl.GL32;

public class Resources
implements Closeable {
    public static final ResourceLocation NOISE_TEXTURE = ResourceLocation.m_214293_((String)"betterclouds", (String)"textures/environment/cloud_noise_rgb.png");
    public static final ResourceLocation LIGHTING_TEXTURE = ResourceLocation.m_214293_((String)"betterclouds", (String)"textures/environment/cloud_light_gradient.png");
    private static final int UNASSIGNED = 0;
    private DepthShader depthShader = null;
    private CoverageShader coverageShader = null;
    private ShadingShader shadingShader = null;
    private DebugShader debugShader = null;
    private ChunkedGenerator generator = null;
    private int cubeVbo;
    private int cubeVao;
    private int oitFbo;
    private int oitCoverageDepthTexture;
    private int oitDataTexture;
    private int oitCoverageTexture;
    private int fboWidth;
    private int fboHeight;
    private PerfTimer timer;

    public ChunkedGenerator generator() {
        return this.generator;
    }

    public DepthShader depthShader() {
        return this.depthShader;
    }

    public CoverageShader coverageShader() {
        return this.coverageShader;
    }

    public ShadingShader shadingShader() {
        return this.shadingShader;
    }

    public DebugShader debugShader() {
        return this.debugShader;
    }

    public int cubeVao() {
        return this.cubeVao;
    }

    public int oitFbo() {
        return this.oitFbo;
    }

    public int oitCoverageDepthTexture() {
        return this.oitCoverageDepthTexture;
    }

    public int oitDataTexture() {
        return this.oitDataTexture;
    }

    public int oitCoverageTexture() {
        return this.oitCoverageTexture;
    }

    public PerfTimer timer() {
        return this.timer;
    }

    public int fboWidth() {
        return this.fboWidth;
    }

    public int fboHeight() {
        return this.fboHeight;
    }

    public boolean failedToLoadCritical() {
        if (this.depthShader == null || this.coverageShader == null || this.shadingShader == null) {
            return true;
        }
        if (this.depthShader.isIncomplete() || this.coverageShader.isIncomplete() || this.shadingShader.isIncomplete() || this.debugShader.isIncomplete()) {
            return true;
        }
        if (this.generator == null) {
            return true;
        }
        if (this.oitFbo == 0) {
            return true;
        }
        if (this.oitDataTexture == 0 || this.oitCoverageTexture == 0) {
            return true;
        }
        return this.cubeVao == 0 || this.cubeVbo == 0;
    }

    public void reloadTimer() {
        this.deleteTimer();
        if (!Debug.isProfilingEnabled()) {
            return;
        }
        this.timer = new PerfTimer();
    }

    public void deleteTimer() {
        if (this.timer != null) {
            this.timer.close();
        }
        this.timer = null;
    }

    public void reloadMeshPrimitives() {
        this.deleteMeshPrimitives();
        this.cubeVao = GL32.glGenVertexArrays();
        GL32.glBindVertexArray((int)this.cubeVao);
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_VERTEX_ARRAY, this.cubeVao, "cube");
        this.cubeVbo = GL32.glGenBuffers();
        GL32.glBindBuffer((int)34962, (int)this.cubeVbo);
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_BUFFER, this.cubeVbo, "cube");
        GL32.glBufferData((int)34962, (float[])Mesh.CUBE_MESH, (int)35044);
        GL32.glEnableVertexAttribArray((int)0);
        GL32.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        Resources.unbindVao();
        Resources.unbindVbo();
    }

    public void deleteMeshPrimitives() {
        if (this.cubeVbo != 0) {
            GL32.glDeleteBuffers((int)this.cubeVbo);
        }
        if (this.cubeVao != 0) {
            GL32.glDeleteVertexArrays((int)this.cubeVao);
        }
        this.cubeVbo = 0;
        this.cubeVao = 0;
    }

    public static void unbindVao() {
        GL32.glBindVertexArray((int)0);
        VertexBufferAccessor buffer = (VertexBufferAccessor)BufferRendererAccessor.getCurrentVertexBuffer();
        if (buffer == null) {
            return;
        }
        int previousVaoId = buffer.getVertexArrayId();
        if (previousVaoId > 0) {
            GL32.glBindVertexArray((int)previousVaoId);
        }
    }

    public static void unbindVbo() {
        GL32.glBindBuffer((int)34962, (int)0);
        VertexBufferAccessor buffer = (VertexBufferAccessor)BufferRendererAccessor.getCurrentVertexBuffer();
        if (buffer == null) {
            return;
        }
        int previousVboId = buffer.getVertexBufferId();
        if (previousVboId > 0) {
            GL32.glBindBuffer((int)34962, (int)previousVboId);
        }
    }

    public void reloadTextures(Minecraft client) {
        RenderSystem.assertOnRenderThread();
        int noiseTexture = RenderHelper.getTextureId(client.m_91097_().m_118506_(NOISE_TEXTURE));
        GlStateManager._activeTexture((int)33984);
        RenderHelper.bindTexture(noiseTexture);
        GLCompat.glCompat.objectLabelDev(5890, noiseTexture, "noise");
        GL32.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL32.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL32.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL32.glTexParameteri((int)3553, (int)10240, (int)9729);
        int lightingTexture = RenderHelper.getTextureId(client.m_91097_().m_118506_(LIGHTING_TEXTURE));
        GlStateManager._bindTexture((int)lightingTexture);
        GLCompat.glCompat.objectLabelDev(5890, lightingTexture, "lighting");
        GL32.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL32.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL32.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL32.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlStateManager._bindTexture((int)0);
    }

    public void reloadGenerator(boolean fancy) {
        this.deleteGenerator();
        this.generator = new ChunkedGenerator();
        this.generator.allocate(ConfigManager.instance(), fancy);
        this.generator.clear();
        this.generator.unbind();
    }

    public void deleteGenerator() {
        if (this.generator != null) {
            this.generator.close();
        }
        this.generator = null;
    }

    public void reloadFramebuffer(int width, int height) {
        if (width == 0 || height == 0) {
            BetterCloudsStatic.getLogger().warn("Cannot create framebuffer with size 0 ({}x{})! Skipping framebuffer creation to avoid an error.", width, height);
            return;
        }
        this.deleteFramebuffer();
        this.oitFbo = GL32.glGenFramebuffers();
        GlStateManager._glBindFramebuffer((int)36009, (int)this.oitFbo);
        GLCompat.glCompat.objectLabelDev(36160, this.oitFbo, "coverage");
        this.fboWidth = width;
        this.fboHeight = height;
        this.oitDataTexture = GL32.glGenTextures();
        GlStateManager._activeTexture((int)33984);
        GlStateManager._bindTexture((int)this.oitDataTexture);
        GLCompat.glCompat.objectLabelDev(5890, this.oitDataTexture, "coverage_color");
        GLCompat.glCompat.texStorage2DFallback(3553, 1, 32849, this.fboWidth, this.fboHeight, 6407, 5120);
        GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.oitDataTexture, (int)0);
        GL32.glDrawBuffers((int[])new int[]{36064});
        boolean useStencilTextureFallback = GLCompat.glCompat.useStencilTextureFallback();
        boolean useDepthWriteFallback = GLCompat.glCompat.useDepthWriteFallback();
        boolean[][] configurations = new boolean[][]{{false, false}, {true, false}, {true, true}};
        int configurationIndex = -1;
        while (true) {
            this.createFramebufferAttachments(useStencilTextureFallback, useDepthWriteFallback);
            int status = GL32.glCheckFramebufferStatus((int)36160);
            if (status == 36053) {
                BetterCloudsStatic.getLogger().info("Framebuffer complete. useStencilTextureFallback={}, useDepthWriteFallback={}", useStencilTextureFallback, useDepthWriteFallback);
                if (configurationIndex == -1) break;
                GLCompat.glCompat.setUseStencilTextureFallback(useStencilTextureFallback);
                GLCompat.glCompat.setUseDepthWriteFallback(useDepthWriteFallback);
                break;
            }
            this.deleteFramebufferAttachments();
            if (++configurationIndex >= configurations.length) {
                throw new IllegalStateException("Better Clouds framebuffer incomplete, exhausted all options, your GPU is likely incompatible, status: " + status);
            }
            BetterCloudsStatic.getLogger().warn("Framebuffer incomplete, trying different creation configuration. useStencilTextureFallback={}, useDepthWriteFallback={}, status={}", useStencilTextureFallback, useDepthWriteFallback, status);
            useStencilTextureFallback = configurations[configurationIndex][0];
            useDepthWriteFallback = configurations[configurationIndex][1];
        }
    }

    private void createFramebufferAttachments(boolean useStencilTextureFallback, boolean useDepthWriteFallback) {
        if (useStencilTextureFallback) {
            this.oitCoverageTexture = GL32.glGenTextures();
            GlStateManager._bindTexture((int)this.oitCoverageTexture);
            GLCompat.glCompat.objectLabelDev(5890, this.oitCoverageTexture, "coverage_color_fallback");
            GLCompat.glCompat.texStorage2DFallback(3553, 1, 33321, this.fboWidth, this.fboHeight, 6403, 5121);
            GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL32.glFramebufferTexture2D((int)36160, (int)36065, (int)3553, (int)this.oitCoverageTexture, (int)0);
            GL32.glDrawBuffers((int[])new int[]{36064, 36065});
            this.oitCoverageDepthTexture = GL32.glGenTextures();
            GL32.glBindTexture((int)3553, (int)this.oitCoverageDepthTexture);
            GLCompat.glCompat.objectLabelDev(5890, this.oitCoverageDepthTexture, "coverage_depth");
            GLCompat.glCompat.texStorage2DFallback(3553, 1, 33190, this.fboWidth, this.fboHeight, 6402, 5126);
            GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL32.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.oitCoverageDepthTexture, (int)0);
        } else {
            this.oitCoverageTexture = GL32.glGenTextures();
            GlStateManager._bindTexture((int)this.oitCoverageTexture);
            GLCompat.glCompat.objectLabelDev(5890, this.oitCoverageTexture, "coverage_stencil");
            GLCompat.glCompat.texStorage2D(3553, 1, 35056, this.fboWidth, this.fboHeight);
            GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL32.glTexParameteri((int)3553, (int)GLCompat.glCompat.GL_DEPTH_STENCIL_TEXTURE_MODE, (int)6401);
            GL32.glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)this.oitCoverageTexture, (int)0);
            if (useDepthWriteFallback) {
                this.oitCoverageDepthTexture = this.oitCoverageTexture;
            } else {
                this.oitCoverageDepthTexture = GL32.glGenTextures();
                GLCompat.glCompat.textureView(this.oitCoverageDepthTexture, 3553, this.oitCoverageTexture, 35056, 0, 1, 0, 1);
                GL32.glBindTexture((int)3553, (int)this.oitCoverageDepthTexture);
                GLCompat.glCompat.objectLabelDev(5890, this.oitCoverageDepthTexture, "coverage_depth");
                GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL32.glTexParameteri((int)3553, (int)GLCompat.glCompat.GL_DEPTH_STENCIL_TEXTURE_MODE, (int)6402);
            }
        }
        GlStateManager._bindTexture((int)0);
    }

    public void deleteFramebuffer() {
        if (this.oitFbo != 0) {
            GL32.glDeleteFramebuffers((int)this.oitFbo);
        }
        this.deleteFramebufferAttachments();
        this.oitFbo = 0;
    }

    private void deleteFramebufferAttachments() {
        if (this.oitDataTexture != 0) {
            GlStateManager._deleteTexture((int)this.oitDataTexture);
        }
        if (this.oitCoverageTexture != 0) {
            GlStateManager._deleteTexture((int)this.oitCoverageTexture);
        }
        if (this.oitCoverageDepthTexture != 0) {
            GlStateManager._deleteTexture((int)this.oitCoverageDepthTexture);
        }
        this.oitDataTexture = 0;
        this.oitCoverageTexture = 0;
        this.oitCoverageDepthTexture = 0;
    }

    public void reloadShaders(ResourceManager manager, ShaderParameters shaderParameters) {
        RenderHelper.saveShader();
        try {
            this.reloadShadersInternal(manager, shaderParameters);
        }
        catch (Exception e) {
            Commands.sendGpuIncompatibleChatMessage();
            BetterCloudsStatic.getLogger().error(e);
            Telemetry.INSTANCE.sendShaderCompileError(e.toString());
            this.deleteShaders();
        }
        RenderHelper.restoreShader();
    }

    protected void reloadShadersInternal(ResourceManager manager, ShaderParameters shaderParameters) throws IOException {
        this.deleteShaders();
        this.depthShader = DepthShader.create(manager);
        this.depthShader.bind();
        this.depthShader.uDepthTexture.setInt(6);
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_PROGRAM, this.depthShader.glId(), "depth");
        this.coverageShader = CoverageShader.create(manager, shaderParameters.configSizeXZ(), shaderParameters.configSizeY(), shaderParameters.useStencilTextureFallback(), shaderParameters.useDistantHorizonsCompat(), shaderParameters.worldCurvatureSize());
        this.coverageShader.bind();
        this.coverageShader.uDepthTexture.setInt(0);
        this.coverageShader.uNoiseTexture.setInt(5);
        this.coverageShader.uDhDepthTexture.setInt(6);
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_PROGRAM, this.coverageShader.glId(), "coverage");
        this.shadingShader = ShadingShader.create(manager, shaderParameters.useDepthWriteFallback(), shaderParameters.useStencilTextureFallback(), shaderParameters.configCelestialBodyHalo());
        this.shadingShader.bind();
        this.shadingShader.uDepthTexture.setInt(1);
        this.shadingShader.uDataTexture.setInt(2);
        this.shadingShader.uCoverageTexture.setInt(3);
        this.shadingShader.uLightTexture.setInt(4);
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_PROGRAM, this.shadingShader.glId(), "shading");
        this.debugShader = new DebugShader(manager);
        this.debugShader.bind();
        this.debugShader.uColorModulator.setVec4(1.0f, 1.0f, 1.0f, 1.0f);
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_PROGRAM, this.debugShader.glId(), "debug");
    }

    public void deleteShaders() {
        if (this.depthShader != null) {
            this.depthShader.close();
        }
        if (this.coverageShader != null) {
            this.coverageShader.close();
        }
        if (this.shadingShader != null) {
            this.shadingShader.close();
        }
        this.depthShader = null;
        this.coverageShader = null;
        this.shadingShader = null;
    }

    @Override
    public void close() {
        this.deleteFramebuffer();
        this.deleteMeshPrimitives();
        this.deleteGenerator();
        this.deleteShaders();
        this.deleteTimer();
    }
}

