/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.DebugMemoryUntracker;
import com.mojang.blaze3d.platform.GLX;
import com.qendolin.betterclouds.BetterClouds;
import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.telemetry.Telemetry;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVulkan;
import org.lwjgl.opengl.ARBBaseInstance;
import org.lwjgl.opengl.ARBBufferStorage;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ARBDrawBuffersBlend;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.ARBTextureStorage;
import org.lwjgl.opengl.ARBTextureView;
import org.lwjgl.opengl.EXTDebugLabel;
import org.lwjgl.opengl.EXTDebugMarker;
import org.lwjgl.opengl.EXTTextureStorage;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL40;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GL44;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GLCompat {
    public final int GL_VERTEX_ARRAY;
    public final int GL_BUFFER;
    public final int GL_PROGRAM;
    public final int GL_TEXTURE;
    public final int GL_FRAMEBUFFER;
    public final int GL_SHADER;
    public final int GL_QUERY;
    public final int GL_DEPTH_STENCIL_TEXTURE_MODE;
    public final int GL_MAP_PERSISTENT_BIT;
    public final int GL_MAP_COHERENT_BIT;
    private final boolean isDev;
    private final boolean hasContext;
    private final boolean vulkanLikely;
    public final boolean openGl44;
    public final boolean openGl43;
    public final boolean openGl42;
    public final boolean openGl40;
    public final boolean openGl32;
    public final boolean openGl33;
    public final int openGlMax;
    public final boolean khrDebug;
    public final boolean amdDebugOutput;
    public final boolean arbDebugOutput;
    public final boolean extDebugLabel;
    public final boolean extDebugMarker;
    public final boolean arbTextureView;
    public final boolean arbBaseInstance;
    public final boolean arbTextureStorage;
    public final boolean extTextureStorage;
    public final boolean arbDirectStateAccess;
    public final boolean extDirectStateAccess;
    public final boolean arbStencilTexturing;
    public final boolean arbBufferStorage;
    public final boolean arbInstancedArrays;
    public final boolean nvCopyDepthToColor;
    public final boolean arbDrawBuffersBlend;
    public final boolean arbSeparateShaderObjects;
    public final boolean arbConservativeDepth;
    public final boolean arbShaderImageLoadStore;
    public final boolean extShaderImageLoadStore;
    public final boolean arbExplicitAttribLocation;
    public final ImmutableList<String> supportedCheckedExtensions;
    public final boolean glObjectLabel;
    public final boolean glPushDebugGroup;
    public final boolean glPopDebugGroup;
    public final boolean glDebugMessageInsert;
    public final boolean glTextureView;
    public final boolean glDrawArraysInstancedBaseInstance;
    public final boolean glTexStorage2D;
    public final boolean glBufferStorage;
    public final boolean glVertexAttribDivisor;
    public final boolean glBlendFunci;
    public final boolean glBlendEquationi;
    public final ImmutableList<String> supportedCheckedFunctions;
    private boolean useBaseInstanceFallback;
    private boolean useStencilTextureFallback;
    private boolean useDepthWriteFallback;
    private boolean useTexStorageFallback;
    private final boolean compatible;
    private final boolean partiallyIncompatible;
    public static GLCompat glCompat = null;

    public GLCompat(boolean isDev) {
        boolean supportsStencilTexturing;
        this.isDev = isDev;
        this.hasContext = GLFW.glfwGetCurrentContext() != 0L;
        boolean vulkanLikely = false;
        if (!this.hasContext && GLFWVulkan.glfwVulkanSupported()) {
            try {
                Class.forName("org.lwjgl.vulkan.VkInstance");
                vulkanLikely = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.vulkanLikely = vulkanLikely;
        GLCapabilities caps = this.hasContext ? GL.getCapabilities() : null;
        this.openGl44 = this.hasContext && caps.OpenGL44;
        this.openGl43 = this.hasContext && caps.OpenGL43;
        this.openGl42 = this.hasContext && caps.OpenGL42;
        this.openGl40 = this.hasContext && caps.OpenGL40;
        this.openGl33 = this.hasContext && caps.OpenGL33;
        boolean bl = this.openGl32 = !this.hasContext || caps.OpenGL32;
        this.openGlMax = this.hasContext && caps.OpenGL46 ? 46 : (this.hasContext && caps.OpenGL45 ? 45 : (this.hasContext && caps.OpenGL44 ? 44 : (this.hasContext && caps.OpenGL43 ? 43 : (this.hasContext && caps.OpenGL42 ? 42 : (this.hasContext && caps.OpenGL41 ? 41 : (this.hasContext && caps.OpenGL40 ? 40 : (this.hasContext && caps.OpenGL33 ? 33 : (this.hasContext && caps.OpenGL32 ? 32 : 0))))))));
        this.khrDebug = this.hasContext && caps.GL_KHR_debug;
        this.amdDebugOutput = this.hasContext && caps.GL_AMD_debug_output;
        this.arbDebugOutput = this.hasContext && caps.GL_ARB_debug_output;
        this.extDebugLabel = this.hasContext && caps.GL_EXT_debug_label;
        this.extDebugMarker = this.hasContext && caps.GL_EXT_debug_marker;
        this.arbTextureView = this.hasContext && caps.GL_ARB_texture_view;
        this.arbBaseInstance = this.hasContext && caps.GL_ARB_base_instance;
        this.arbTextureStorage = this.hasContext && caps.GL_ARB_texture_storage;
        this.extTextureStorage = this.hasContext && caps.GL_EXT_texture_storage;
        this.arbDirectStateAccess = this.hasContext && caps.GL_ARB_direct_state_access;
        this.extDirectStateAccess = this.hasContext && caps.GL_EXT_direct_state_access;
        this.arbStencilTexturing = this.hasContext && caps.GL_ARB_stencil_texturing;
        this.arbBufferStorage = this.hasContext && caps.GL_ARB_buffer_storage;
        this.arbInstancedArrays = this.hasContext && caps.GL_ARB_instanced_arrays;
        this.nvCopyDepthToColor = this.hasContext && caps.GL_NV_copy_depth_to_color;
        this.arbDrawBuffersBlend = this.hasContext && caps.GL_ARB_draw_buffers_blend;
        this.arbSeparateShaderObjects = this.hasContext && caps.GL_ARB_separate_shader_objects;
        this.arbConservativeDepth = this.hasContext && caps.GL_ARB_conservative_depth;
        this.arbShaderImageLoadStore = this.hasContext && caps.GL_ARB_shader_image_load_store;
        this.extShaderImageLoadStore = this.hasContext && caps.GL_EXT_shader_image_load_store;
        this.arbExplicitAttribLocation = this.hasContext && caps.GL_ARB_explicit_attrib_location;
        ArrayList<String> supportedExtensions = new ArrayList<String>();
        if (this.khrDebug) {
            supportedExtensions.add("GL_KHR_debug");
        }
        if (this.amdDebugOutput) {
            supportedExtensions.add("GL_AMD_debug_output");
        }
        if (this.arbDebugOutput) {
            supportedExtensions.add("GL_ARB_debug_output");
        }
        if (this.extDebugLabel) {
            supportedExtensions.add("GL_EXT_debug_label");
        }
        if (this.extDebugMarker) {
            supportedExtensions.add("GL_EXT_debug_marker");
        }
        if (this.arbTextureView) {
            supportedExtensions.add("GL_ARB_texture_view");
        }
        if (this.arbBaseInstance) {
            supportedExtensions.add("GL_ARB_base_instance");
        }
        if (this.arbTextureStorage) {
            supportedExtensions.add("GL_ARB_texture_storage");
        }
        if (this.extTextureStorage) {
            supportedExtensions.add("GL_EXT_texture_storage");
        }
        if (this.arbDirectStateAccess) {
            supportedExtensions.add("GL_ARB_direct_state_access");
        }
        if (this.extDirectStateAccess) {
            supportedExtensions.add("GL_EXT_direct_state_access");
        }
        if (this.arbStencilTexturing) {
            supportedExtensions.add("GL_ARB_stencil_texturing");
        }
        if (this.arbBufferStorage) {
            supportedExtensions.add("GL_ARB_buffer_storage");
        }
        if (this.arbInstancedArrays) {
            supportedExtensions.add("GL_ARB_instanced_arrays");
        }
        if (this.nvCopyDepthToColor) {
            supportedExtensions.add("GL_NV_copy_depth_to_color");
        }
        if (this.arbSeparateShaderObjects) {
            supportedExtensions.add("GL_ARB_separate_shader_objects");
        }
        if (this.arbConservativeDepth) {
            supportedExtensions.add("GL_ARB_conservative_depth");
        }
        if (this.arbShaderImageLoadStore) {
            supportedExtensions.add("GL_ARB_shader_image_load_store");
        }
        if (this.extShaderImageLoadStore) {
            supportedExtensions.add("GL_EXT_shader_image_load_store");
        }
        if (this.arbExplicitAttribLocation) {
            supportedExtensions.add("GL_ARB_explicit_attrib_location");
        }
        if (this.arbDrawBuffersBlend) {
            supportedExtensions.add("GL_ARB_draw_buffers_blend");
        }
        this.supportedCheckedExtensions = ImmutableList.copyOf(supportedExtensions);
        this.glObjectLabel = this.hasContext && caps.glObjectLabel != 0L;
        this.glPushDebugGroup = this.hasContext && caps.glPushDebugGroup != 0L;
        this.glPopDebugGroup = this.hasContext && caps.glPopDebugGroup != 0L;
        this.glDebugMessageInsert = this.hasContext && caps.glDebugMessageInsert != 0L;
        this.glTextureView = this.hasContext && caps.glTextureView != 0L;
        this.glDrawArraysInstancedBaseInstance = this.hasContext && caps.glDrawArraysInstancedBaseInstance != 0L;
        this.glTexStorage2D = this.hasContext && caps.glTexStorage2D != 0L;
        this.glBufferStorage = this.hasContext && caps.glBufferStorage != 0L;
        this.glVertexAttribDivisor = this.hasContext && caps.glVertexAttribDivisor != 0L;
        this.glBlendFunci = this.hasContext && caps.glBlendFunci != 0L;
        this.glBlendEquationi = this.hasContext && caps.glBlendEquationi != 0L;
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        if (this.glObjectLabel) {
            supportedFunctions.add("glObjectLabel");
        }
        if (this.glPushDebugGroup) {
            supportedFunctions.add("glPushDebugGroup");
        }
        if (this.glPopDebugGroup) {
            supportedFunctions.add("glPopDebugGroup");
        }
        if (this.glDebugMessageInsert) {
            supportedFunctions.add("glDebugMessageInsert");
        }
        if (this.glTextureView) {
            supportedFunctions.add("glTextureView");
        }
        if (this.glDrawArraysInstancedBaseInstance) {
            supportedFunctions.add("glDrawArraysInstancedBaseInstance");
        }
        if (this.glTexStorage2D) {
            supportedFunctions.add("glTexStorage2D");
        }
        if (this.glBufferStorage) {
            supportedFunctions.add("glBufferStorage");
        }
        if (this.glVertexAttribDivisor) {
            supportedFunctions.add("glVertexAttribDivisor");
        }
        if (this.glBlendFunci) {
            supportedFunctions.add("glBlendFunci");
        }
        if (this.glBlendEquationi) {
            supportedFunctions.add("glBlendEquationi");
        }
        this.supportedCheckedFunctions = ImmutableList.copyOf(supportedFunctions);
        boolean supportsBaseInstance = this.glDrawArraysInstancedBaseInstance || this.arbBaseInstance;
        boolean supportsTextureStorage = this.glTexStorage2D || this.arbTextureStorage || this.extTextureStorage;
        boolean supportsTextureView = supportsTextureStorage && (this.glTextureView || this.arbTextureView);
        boolean canReadStencil = supportsStencilTexturing = this.arbStencilTexturing || this.openGl43;
        String reason = null;
        if (this.hasContext) {
            if (!this.openGl32) {
                reason = "OpenGL 3.2 is required";
            } else if (!(this.openGl33 || this.glVertexAttribDivisor || this.arbInstancedArrays)) {
                reason = "OpenGL 3.3, glVertexAttribDivisor, or arbInstancedArrays is required";
            } else if (!(supportsStencilTexturing || this.openGl40 || this.glBlendFunci && this.glBlendEquationi || this.arbDrawBuffersBlend)) {
                reason = "OpenGL 4.0, arbStencilTexturing, glBlendFunci and glBlendEquationi, or arbDrawBuffersBlend is required";
            }
        } else {
            reason = "No OpenGL Context";
        }
        boolean bl2 = this.compatible = reason == null;
        if (reason != null) {
            BetterCloudsStatic.getLogger().warn("OpenGL compatibility check failed: " + reason);
        }
        this.useBaseInstanceFallback = !supportsBaseInstance;
        this.useStencilTextureFallback = !canReadStencil;
        this.useTexStorageFallback = !supportsTextureStorage;
        this.useDepthWriteFallback = !supportsTextureView && canReadStencil;
        this.partiallyIncompatible = this.useBaseInstanceFallback || this.useStencilTextureFallback || this.useDepthWriteFallback || this.useTexStorageFallback;
        this.GL_VERTEX_ARRAY = 32884;
        this.GL_BUFFER = 33504;
        this.GL_PROGRAM = 33506;
        this.GL_TEXTURE = 5890;
        this.GL_FRAMEBUFFER = 36160;
        this.GL_SHADER = 33505;
        this.GL_QUERY = 33507;
        this.GL_DEPTH_STENCIL_TEXTURE_MODE = 37098;
        this.GL_MAP_PERSISTENT_BIT = 64;
        this.GL_MAP_COHERENT_BIT = 128;
    }

    public boolean isIncompatible() {
        return !this.compatible;
    }

    public boolean isPartiallyIncompatible() {
        return this.partiallyIncompatible;
    }

    public void objectLabelDev(int type, int name, String label) {
        if (!this.isDev) {
            return;
        }
        this.objectLabel(type, name, label);
    }

    public void objectLabel(int type, int name, String label) {
        String typeString = switch (type) {
            case 5890 -> "tex";
            case 33504 -> "buf";
            case 32884 -> "va";
            case 36160 -> "fb";
            case 33505 -> "sh";
            case 33506 -> "shp";
            case 33507 -> "qry";
            case 33508 -> "spp";
            case 36386 -> "tff";
            case 33510 -> "ts";
            case 36161 -> "rb";
            default -> "unk";
        };
        String fullLabel = "betterclouds:" + label + ":" + typeString;
        if (this.glObjectLabel) {
            GL43.glObjectLabel((int)type, (int)name, (CharSequence)fullLabel);
        } else if (this.khrDebug) {
            KHRDebug.glObjectLabel((int)type, (int)name, (CharSequence)fullLabel);
        } else if (this.extDebugLabel) {
            int extType = switch (type) {
                case 5890 -> 5890;
                case 33504 -> 37201;
                case 32884 -> 37204;
                case 36160 -> 36160;
                case 33505 -> 35656;
                case 33506 -> 35648;
                case 33507 -> 37203;
                case 33508 -> 35407;
                case 36386 -> 36386;
                case 33510 -> 33510;
                case 36161 -> 36161;
                default -> type;
            };
            EXTDebugLabel.glLabelObjectEXT((int)extType, (int)name, (CharSequence)fullLabel);
        }
    }

    public void pushDebugGroupDev(String name) {
        if (!this.isDev) {
            return;
        }
        this.pushDebugGroup(name);
    }

    public void pushDebugGroup(String name) {
        if (this.glPushDebugGroup) {
            GL43.glPushDebugGroup((int)33354, (int)1337, (CharSequence)(name + "\u0000"));
        } else if (this.khrDebug) {
            KHRDebug.glPushDebugGroup((int)33354, (int)1337, (CharSequence)(name + "\u0000"));
        } else if (this.extDebugMarker) {
            EXTDebugMarker.glPushGroupMarkerEXT((CharSequence)(name + "\u0000"));
        }
    }

    public void popDebugGroupDev() {
        if (!this.isDev) {
            return;
        }
        this.popDebugGroup();
    }

    public void popDebugGroup() {
        if (this.glPopDebugGroup) {
            GL43.glPopDebugGroup();
        } else if (this.khrDebug) {
            KHRDebug.glPopDebugGroup();
        } else if (this.extDebugMarker) {
            EXTDebugMarker.glPopGroupMarkerEXT();
        }
    }

    public void debugMessageDev(String message) {
        if (!this.isDev) {
            return;
        }
        this.debugMessage(message);
    }

    public void debugMessage(String message) {
        if (this.glDebugMessageInsert) {
            GL43.glDebugMessageInsert((int)33354, (int)33361, (int)0, (int)33387, (CharSequence)(message + "\u0000"));
        } else if (this.khrDebug) {
            KHRDebug.glDebugMessageInsert((int)33354, (int)33361, (int)0, (int)33387, (CharSequence)(message + "\u0000"));
        } else if (this.extDebugMarker) {
            EXTDebugMarker.glInsertEventMarkerEXT((CharSequence)(message + "\u0000"));
        }
    }

    public void enableDebugOutputSynchronousDev() {
        if (!this.isDev) {
            return;
        }
        BetterCloudsStatic.getLogger().warn("Enabling synchronous OpenGL debug output");
        this.enableDebugOutputSynchronous();
    }

    public void enableDebugOutputSynchronous() {
        if (this.openGl43) {
            GL43.glEnable((int)33346);
        } else if (this.arbDebugOutput) {
            GL32.glEnable((int)33346);
        } else if (this.khrDebug) {
            GL32.glEnable((int)33346);
        }
    }

    public void debugMessageCallbackDev(GLDebugMessageCallbackI callback) {
        if (!this.isDev) {
            return;
        }
        this.debugMessageCallback(callback);
    }

    public void debugMessageCallback(GLDebugMessageCallbackI callback) {
        if (this.openGl43) {
            GL43.glDebugMessageCallback((GLDebugMessageCallbackI)((GLDebugMessageCallbackI)GLX.make((Object)GLDebugMessageCallback.create((GLDebugMessageCallbackI)callback), DebugMemoryUntracker::m_84003_)), (long)0L);
        } else if (this.arbDebugOutput) {
            ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)((GLDebugMessageARBCallbackI)GLX.make((Object)GLDebugMessageARBCallback.create((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((GLDebugMessageCallbackI)callback).invoke(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6)), DebugMemoryUntracker::m_84003_)), (long)0L);
        } else if (this.khrDebug) {
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)((GLDebugMessageCallbackI)GLX.make((Object)GLDebugMessageCallback.create((GLDebugMessageCallbackI)callback), DebugMemoryUntracker::m_84003_)), (long)0L);
        }
    }

    public void debugMessageControlDev(int source, int type, int severity, int[] ids, boolean enabled) {
        if (!this.isDev) {
            return;
        }
        this.debugMessageControl(source, type, severity, ids, enabled);
    }

    public void debugMessageControl(int source, int type, int severity, int[] ids, boolean enabled) {
        if (this.openGl43) {
            GL43.glDebugMessageControl((int)source, (int)type, (int)severity, (int[])ids, (boolean)enabled);
        } else if (this.arbDebugOutput) {
            ARBDebugOutput.glDebugMessageControlARB((int)source, (int)type, (int)severity, (int[])ids, (boolean)enabled);
        } else if (this.khrDebug) {
            KHRDebug.glDebugMessageControl((int)source, (int)type, (int)severity, (int[])ids, (boolean)enabled);
        }
    }

    public void textureView(int texture, int target, int origtexture, int internalformat, int minlevel, int numlevels, int minlayer, int numlayers) {
        if (this.glTextureView) {
            GL43.glTextureView((int)texture, (int)target, (int)origtexture, (int)internalformat, (int)minlevel, (int)numlevels, (int)minlayer, (int)numlayers);
        } else if (this.arbTextureView) {
            ARBTextureView.glTextureView((int)texture, (int)target, (int)origtexture, (int)internalformat, (int)minlevel, (int)numlevels, (int)minlayer, (int)numlayers);
        }
    }

    public void drawArraysInstancedBaseInstanceFallback(int mode, int first, int count, int primcount, int baseinstance) {
        if (this.useBaseInstanceFallback) {
            GL32.glDrawArraysInstanced((int)mode, (int)first, (int)count, (int)primcount);
        } else {
            this.drawArraysInstancedBaseInstance(mode, first, count, primcount, baseinstance);
        }
    }

    public void drawArraysInstancedBaseInstance(int mode, int first, int count, int primcount, int baseinstance) {
        if (this.glDrawArraysInstancedBaseInstance) {
            GL42.glDrawArraysInstancedBaseInstance((int)mode, (int)first, (int)count, (int)primcount, (int)baseinstance);
        } else if (this.arbBaseInstance) {
            ARBBaseInstance.glDrawArraysInstancedBaseInstance((int)mode, (int)first, (int)count, (int)primcount, (int)baseinstance);
        }
    }

    public void texStorage2DFallback(int target, int levels, int internalformat, int width, int height, int format, int type) {
        if (this.useTexStorageFallback) {
            GL32.glTexImage2D((int)target, (int)0, (int)internalformat, (int)width, (int)height, (int)0, (int)format, (int)type, (long)0L);
            GL32.glTexParameteri((int)target, (int)33085, (int)(levels - 1));
        } else {
            this.texStorage2D(target, levels, internalformat, width, height);
        }
    }

    public void texStorage2D(int target, int levels, int internalformat, int width, int height) {
        if (this.glTexStorage2D) {
            GL42.glTexStorage2D((int)target, (int)levels, (int)internalformat, (int)width, (int)height);
        } else if (this.arbTextureStorage) {
            ARBTextureStorage.glTexStorage2D((int)target, (int)levels, (int)internalformat, (int)width, (int)height);
        } else if (this.extTextureStorage) {
            EXTTextureStorage.glTexStorage2DEXT((int)target, (int)levels, (int)internalformat, (int)width, (int)height);
        }
    }

    public void bufferStorage(int target, long size, int flags) {
        if (this.glBufferStorage) {
            GL44.glBufferStorage((int)target, (long)size, (int)flags);
        } else if (this.arbBufferStorage) {
            ARBBufferStorage.glBufferStorage((int)target, (long)size, (int)flags);
        }
    }

    public void vertexAttribDivisor(int index, int divisor) {
        if (this.glVertexAttribDivisor) {
            GL33.glVertexAttribDivisor((int)index, (int)divisor);
        } else if (this.arbInstancedArrays) {
            ARBInstancedArrays.glVertexAttribDivisorARB((int)index, (int)divisor);
        }
    }

    public void blendEquationi(int buf, int mode) {
        if (this.glBlendFunci) {
            GL40.glBlendEquationi((int)buf, (int)mode);
        } else if (this.arbDrawBuffersBlend) {
            ARBDrawBuffersBlend.glBlendEquationiARB((int)buf, (int)mode);
        }
    }

    public void blendFunci(int buf, int sfactor, int dfactor) {
        if (this.glBlendFunci) {
            GL40.glBlendFunci((int)buf, (int)sfactor, (int)dfactor);
        } else if (this.arbDrawBuffersBlend) {
            ARBDrawBuffersBlend.glBlendFunciARB((int)buf, (int)sfactor, (int)dfactor);
        }
    }

    public String getString(int name) {
        if (this.hasContext) {
            return GL32.glGetString((int)name);
        }
        if (name == 7938 && this.vulkanLikely) {
            return "Vulkan";
        }
        return "unknown";
    }

    public int getInteger(int pname) {
        if (this.hasContext) {
            return GL32.glGetInteger((int)pname);
        }
        return 0;
    }

    public boolean useBaseInstanceFallback() {
        return this.useBaseInstanceFallback;
    }

    public void setUseBaseInstanceFallback(boolean useBaseInstanceFallback) {
        this.useBaseInstanceFallback = useBaseInstanceFallback;
    }

    public boolean useStencilTextureFallback() {
        return this.useStencilTextureFallback;
    }

    public void setUseStencilTextureFallback(boolean useStencilTextureFallback) {
        this.useStencilTextureFallback = useStencilTextureFallback;
    }

    public boolean useDepthWriteFallback() {
        return this.useDepthWriteFallback;
    }

    public void setUseDepthWriteFallback(boolean useDepthWriteFallback) {
        this.useDepthWriteFallback = useDepthWriteFallback;
    }

    public boolean useTexStorageFallback() {
        return this.useTexStorageFallback;
    }

    public void setUseTexStorageFallback(boolean useTexStorageFallback) {
        this.useTexStorageFallback = useTexStorageFallback;
    }

    public ImmutableList<String> usedFallbacks() {
        ArrayList<String> usedFallbacks = new ArrayList<String>();
        if (this.useBaseInstanceFallback) {
            usedFallbacks.add("base_instance");
        }
        if (this.useStencilTextureFallback) {
            usedFallbacks.add("stencil_texture");
        }
        if (this.useTexStorageFallback) {
            usedFallbacks.add("texture_storage");
        }
        if (this.useDepthWriteFallback) {
            usedFallbacks.add("depth_view_write");
        }
        return ImmutableList.copyOf(usedFallbacks);
    }

    public static String getVendor() {
        return GL32.glGetString((int)7936);
    }

    public static String getCpuInfo() {
        return GLX._getCpuInfo();
    }

    public static String getRenderer() {
        return GL32.glGetString((int)7937);
    }

    public static String getVersion() {
        return GL32.glGetString((int)7938);
    }

    public static void initGlCompat() {
        BetterCloudsStatic.getLogger().info("Initializing OpenGL compat");
        try {
            glCompat = new GLCompat(BetterCloudsStatic.IS_DEV);
        }
        catch (Exception e) {
            Telemetry.INSTANCE.sendUnhandledException(e);
            throw e;
        }
        if (glCompat.isIncompatible()) {
            BetterCloudsStatic.getLogger().warn("Your GPU (or configuration) is not compatible with Better Clouds. Try updating your drivers?");
            BetterCloudsStatic.getLogger().info(" - Vendor:       {}", glCompat.getString(7936));
            BetterCloudsStatic.getLogger().info(" - Renderer:     {}", glCompat.getString(7937));
            BetterCloudsStatic.getLogger().info(" - GL Version:   {}", glCompat.getString(7938));
            BetterCloudsStatic.getLogger().info(" - GLSL Version: {}", glCompat.getString(35724));
            BetterCloudsStatic.getLogger().info(" - Extensions:   {}", String.join((CharSequence)", ", GLCompat.glCompat.supportedCheckedExtensions));
            BetterCloudsStatic.getLogger().info(" - Functions:    {}", String.join((CharSequence)", ", GLCompat.glCompat.supportedCheckedFunctions));
        } else if (glCompat.isPartiallyIncompatible()) {
            BetterCloudsStatic.getLogger().warn("Your GPU is not fully compatible with Better Clouds.");
            for (String fallback : glCompat.usedFallbacks()) {
                BetterCloudsStatic.getLogger().info("- Using {} fallback", fallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shaderSource(int shader, String source) {
        byte[] sourceBytes = source.getBytes(Charsets.UTF_8);
        ByteBuffer buffer = MemoryUtil.memAlloc((int)(sourceBytes.length + 1));
        buffer.put(sourceBytes);
        buffer.put((byte)0);
        buffer.flip();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            pointerbuffer.put(buffer);
            GL20C.nglShaderSource((int)shader, (int)1, (long)pointerbuffer.address0(), (long)0L);
        }
        finally {
            MemoryUtil.memFree((Buffer)buffer);
        }
    }

    private static void sendSystemDetailsTelemetry() {
        if (!BetterClouds.isInitialized() || glCompat == null) {
            return;
        }
        if (ConfigManager.instance().lastTelemetryVersion >= 3) {
            return;
        }
        Telemetry.INSTANCE.sendSystemInfo().whenComplete((success, throwable) -> {
            Minecraft client = Minecraft.m_91087_();
            if (success.booleanValue() && client != null) {
                client.execute(() -> {
                    ConfigManager.instance().lastTelemetryVersion = 3;
                    ConfigManager.handler().save();
                });
            }
        });
    }
}

