/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.render.element;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import xaero.common.HudMod;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.icon.XaeroIcon;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.RadarSession;
import xaero.hud.minimap.radar.category.EntityRadarCategory;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.hud.minimap.radar.color.RadarColor;
import xaero.hud.minimap.radar.icon.RadarIconManager;
import xaero.hud.minimap.radar.render.element.RadarElementReader;
import xaero.hud.minimap.radar.render.element.RadarRenderContext;
import xaero.hud.minimap.radar.render.element.RadarRenderProvider;
import xaero.hud.minimap.radar.util.RadarUtils;
import xaero.hud.render.util.RenderBufferUtil;

public abstract class RadarRenderer
extends MinimapElementRenderer<Entity, RadarRenderContext> {
    private final RadarIconManager radarIconManager;
    private final Minimap minimap;
    private RadarSession radarSession;
    private EntityRadarCategoryManager categoryManager;
    private EntityRadarCategory previousCategory;
    private double maxDistanceSquared;
    private double labelScale;
    private boolean smoothDots;
    private boolean debugEntityIcons;
    private boolean debugEntityVariantIds;
    private int dotsStyle;
    private int heightLimit;
    private boolean heightBasedFade;
    private int startFadingAt;
    private boolean displayNameWhenIconFails;
    private boolean alwaysNameTags;
    private RadarColor radarColor;
    private RadarColor fallbackColor;
    private int displayY;
    private int nameSettingForCategory;
    private boolean namesForCategory;
    private boolean name;
    private boolean iconsAllowed;
    private boolean labelsAllowed;
    private RenderType dotsRenderType;
    private MultiBufferSource.BufferSource minimapBufferSource;
    private VertexConsumer dotsBufferBuilder;
    private VertexConsumer labelBgBuilder;
    private MultiTextureRenderTypeRenderer iconsRenderer;
    private MinimapRendererHelper helper;
    private final RadarRenderProvider radarRenderProvider;

    protected RadarRenderer(RadarIconManager radarIconManager, Minimap minimap, RadarElementReader elementReader, RadarRenderProvider provider, RadarRenderContext context) {
        super(elementReader, provider, context);
        this.radarIconManager = radarIconManager;
        this.minimap = minimap;
        this.radarRenderProvider = provider;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        this.radarIconManager.allowPrerender();
        ModSettings settings = HudMod.INSTANCE.getSettings();
        this.iconsAllowed = true;
        this.labelsAllowed = true;
        ((RadarRenderContext)this.context).reversedOrder = ModSettings.keyReverseEntityRadar.m_90857_();
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        this.radarSession = session.getRadarSession();
        this.categoryManager = this.radarSession.getCategoryManager();
        this.previousCategory = null;
        this.labelScale = settings.getDotNameScale();
        this.smoothDots = settings.getSmoothDots();
        this.debugEntityIcons = settings.debugEntityIcons;
        this.debugEntityVariantIds = settings.debugEntityVariantIds;
        this.dotsStyle = settings.getDotsStyle();
        this.dotsRenderType = settings.getSmoothDots() ? CustomRenderTypes.GUI_BILINEAR : CustomRenderTypes.GUI_NEAREST;
        RenderSystem.disableDepthTest();
        vanillaBufferSource.m_109911_();
        this.minimapBufferSource = HudMod.INSTANCE.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        this.dotsBufferBuilder = this.minimapBufferSource.m_6299_(this.dotsRenderType);
        this.labelBgBuilder = this.minimapBufferSource.m_6299_(CustomRenderTypes.RADAR_NAME_BGS);
        this.iconsRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR);
        this.helper = HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().getHelper();
        double playerDimDiv = renderInfo.backgroundCoordinateScale / renderInfo.renderEntityDimensionScale;
        this.maxDistanceSquared = RadarUtils.getMaxDistance(session.getProcessor(), settings.minimapShape == 1) * playerDimDiv * playerDimDiv;
    }

    @Override
    public boolean renderElement(Entity e, boolean highlighted, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo, GuiGraphics guiGraphics, MultiBufferSource.BufferSource vanillaBufferSource) {
        double figureScale;
        if (renderInfo.location == MinimapElementRenderLocation.IN_MINIMAP) {
            double offX = e.m_20185_() - renderInfo.renderEntityPos.f_82479_;
            if (offX * offX > this.maxDistanceSquared) {
                return false;
            }
            double offY = e.m_20189_() - renderInfo.renderEntityPos.f_82481_;
            if (offY * offY > this.maxDistanceSquared) {
                return false;
            }
        }
        if (((RadarRenderContext)this.context).entityCategory == null) {
            EntityRadarCategory rootCategory = this.categoryManager.getRootCategory();
            ((RadarRenderContext)this.context).entityCategory = this.categoryManager.getRuleResolver().resolve(rootCategory, e, renderInfo.player);
            if (((RadarRenderContext)this.context).entityCategory == null) {
                return false;
            }
        }
        if (((RadarRenderContext)this.context).entityCategory != this.previousCategory) {
            this.setupRenderForCategory(((RadarRenderContext)this.context).entityCategory);
            this.previousCategory = ((RadarRenderContext)this.context).entityCategory;
        }
        this.setupRenderForEntity(e);
        if (e instanceof Player) {
            this.confirmTrackedPlayerRadarRender((Player)e);
        }
        Entity renderEntity = renderInfo.renderEntity;
        boolean cave = renderInfo.cave;
        float optionalScaleAdjust = renderInfo.location == MinimapElementRenderLocation.OVER_MINIMAP ? 0.5f : 1.0f;
        optionalScale *= optionalScaleAdjust;
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        boolean icon = this.iconsAllowed && ((RadarRenderContext)this.context).icon;
        boolean name = this.name;
        if (highlighted && this.nameSettingForCategory > 0) {
            name = true;
        }
        XaeroIcon entityIcon = null;
        if (icon) {
            entityIcon = this.radarIconManager.get(e, (float)((RadarRenderContext)this.context).iconScale, this.debugEntityIcons, this.debugEntityVariantIds, guiGraphics, renderInfo.framebuffer);
        }
        if (entityIcon == RadarIconManager.DOT) {
            entityIcon = null;
            icon = false;
        }
        boolean usableIcon = entityIcon != null && entityIcon != RadarIconManager.FAILED;
        float offY = (float)(renderEntity.m_20186_() - e.m_20186_());
        int labelOffsetX = 0;
        int labelOffsetY = 0;
        matrixStack.m_85837_(partialX, partialY, 0.0);
        if (usableIcon) {
            figureScale = ((RadarRenderContext)this.context).iconScale;
            this.renderIcon(entityIcon, optionalScale, figureScale, offY, cave, matrixStack);
        } else {
            boolean smooth = this.smoothDots;
            if (!smooth) {
                optionalScale = (float)Math.ceil(optionalScale);
            }
            double dotActualScale = optionalScale;
            figureScale = ((RadarRenderContext)this.context).dotScale;
            if (this.dotsStyle == 1) {
                if (!smooth) {
                    figureScale = (int)figureScale;
                }
                dotActualScale *= figureScale;
            }
            float dotOffset = this.renderDot(e, renderInfo.player, smooth, optionalScale, figureScale, offY, cave, matrixStack);
            if (!smooth) {
                double dotRadius = (double)(-dotOffset) * dotActualScale;
                double dotRadiusPartial = dotRadius - (double)((int)dotRadius);
                labelOffsetX = partialX - dotRadiusPartial <= -0.5 ? -1 : 0;
                int n = labelOffsetY = partialY - dotRadiusPartial < -0.5 ? -1 : 0;
            }
            if (icon && this.displayNameWhenIconFails && entityIcon == RadarIconManager.FAILED) {
                name = true;
            }
        }
        matrixStack.m_85849_();
        if (!this.labelsAllowed) {
            return true;
        }
        if (!name && this.displayY <= 0) {
            return true;
        }
        matrixStack.m_85837_((double)labelOffsetX, (double)(labelOffsetY += (int)Math.round((double)(usableIcon ? 11 : 5) * figureScale * (double)optionalScale)), optionalDepth + (double)0.1f);
        if (optionalScale < 1.0f) {
            optionalScale = 1.0f;
        }
        this.renderLabel(e, renderEntity, name, optionalScale, matrixStack);
        return true;
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        if (((RadarRenderContext)this.context).reversedOrder) {
            this.minimapBufferSource.m_109912_(this.dotsRenderType);
        }
        multiTextureRenderTypeRenderers.draw(this.iconsRenderer);
        if (!((RadarRenderContext)this.context).reversedOrder) {
            this.minimapBufferSource.m_109912_(this.dotsRenderType);
        }
        this.minimapBufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        this.iconsRenderer = null;
        this.previousCategory = null;
    }

    private void renderIcon(XaeroIcon entityIcon, double optionalScale, double figureScale, float offY, boolean cave, PoseStack matrixStack) {
        double clampedScale = Math.max(1.0, figureScale * optionalScale);
        matrixStack.m_85841_((float)clampedScale, (float)clampedScale, 1.0f);
        float brightness = !this.heightBasedFade ? 1.0f : this.radarSession.getColorHelper().getEntityHeightFade(offY, this.heightLimit, this.startFadingAt);
        float opacity = 1.0f;
        if (cave) {
            opacity = brightness;
            brightness = 1.0f;
        }
        this.helper.prepareMyTexturedColoredModalRect(matrixStack.m_85850_().m_252922_(), -31.0f, -31.0f, entityIcon.getOffsetX() + 1, entityIcon.getOffsetY() + 1, 62.0f, 62.0f, 62.0f, entityIcon.getTextureAtlas().getWidth(), entityIcon.getTextureAtlas().getTextureId(), brightness, brightness, brightness, opacity, this.iconsRenderer);
    }

    private float renderDot(Entity e, Player player, boolean smooth, float optionalScale, double figureScale, float offY, boolean cave, PoseStack matrixStack) {
        matrixStack.m_85841_(optionalScale, optionalScale, 1.0f);
        int color = this.radarSession.getColorHelper().getEntityColor(e, offY, cave, this.heightLimit, this.startFadingAt, this.heightBasedFade, this.radarColor, this.fallbackColor);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        int dotTextureX = 0;
        int dotTextureY = 0;
        int dotTextureW = 0;
        int dotTextureH = 0;
        float dotOffset = 0.0f;
        if (this.dotsStyle == 1) {
            if (smooth) {
                dotTextureX = 1;
                dotTextureY = 88;
            } else {
                dotTextureX = 9;
                dotTextureY = 77;
            }
            dotOffset = -3.5f;
            dotTextureH = 8;
            dotTextureW = 8;
            matrixStack.m_85841_((float)figureScale, (float)figureScale, 1.0f);
        } else {
            switch (((RadarRenderContext)this.context).dotSize) {
                case 1: {
                    dotOffset = -4.5f;
                    dotTextureY = 108;
                    dotTextureH = 9;
                    dotTextureW = 9;
                    break;
                }
                case 3: {
                    dotOffset = -7.5f;
                    dotTextureY = 128;
                    dotTextureH = 15;
                    dotTextureW = 15;
                    break;
                }
                case 4: {
                    dotOffset = -10.5f;
                    dotTextureY = 160;
                    dotTextureH = 21;
                    dotTextureW = 21;
                    break;
                }
                default: {
                    dotOffset = -5.5f;
                    dotTextureY = 117;
                    dotTextureH = 11;
                    dotTextureW = 11;
                }
            }
        }
        RenderBufferUtil.addTexturedColoredRect(matrixStack.m_85850_().m_252922_(), this.dotsBufferBuilder, dotOffset, dotOffset, dotTextureX, dotTextureY, dotTextureW, dotTextureH, r, g, b, a, 256.0f);
        return dotOffset;
    }

    private void renderLabel(Entity e, Entity renderEntity, boolean name, double optionalScale, PoseStack matrixStack) {
        double dotNameScale = this.labelScale * optionalScale;
        matrixStack.m_85841_((float)dotNameScale, (float)dotNameScale, 1.0f);
        Object yValueString = null;
        if (this.displayY > 0) {
            int yInt = (int)Math.floor(e.m_20186_());
            int pYInt = (int)Math.floor(renderEntity.m_20186_());
            yValueString = this.displayY == 1 ? "" + yInt : (this.displayY == 2 ? "" + (yInt - pYInt) : "");
            if (((String)(yValueString = (String)yValueString + (yInt > pYInt ? "\u2191" : (yInt != pYInt ? "\u2193" : "")))).length() == 0) {
                yValueString = "-";
            }
        }
        Font font = Minecraft.m_91087_().f_91062_;
        Object label = null;
        if (name) {
            Component component = Misc.getFixedDisplayName(e);
            if (component == null) {
                return;
            }
            label = component.getString();
            if (this.displayY > 0) {
                label = (String)label + "(" + (String)yValueString + ")";
            }
        } else if (this.displayY > 0) {
            label = yValueString;
        }
        if (label == null) {
            return;
        }
        int labelW = font.m_92895_((String)label);
        RenderBufferUtil.addColoredRect(matrixStack.m_85850_().m_252922_(), this.labelBgBuilder, -labelW / 2 - 2, -1.0f, labelW + 3, 10, 0.0f, 0.0f, 0.0f, 0.3529412f);
        Misc.drawNormalText(matrixStack, (String)label, (float)(-labelW / 2), 0.0f, -1, false, this.minimapBufferSource);
    }

    private void setupRenderForCategory(EntityRadarCategory entityCategory) {
        if (!this.radarRenderProvider.isUsed()) {
            this.radarRenderProvider.setupContextForCategory(entityCategory, (RadarRenderContext)this.context);
        }
        this.heightLimit = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_LIMIT).intValue();
        this.heightBasedFade = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_FADE);
        this.startFadingAt = entityCategory.getSettingValue(EntityRadarCategorySettings.START_FADING_AT).intValue();
        this.displayNameWhenIconFails = entityCategory.getSettingValue(EntityRadarCategorySettings.ICON_NAME_FALLBACK);
        this.alwaysNameTags = entityCategory.getSettingValue(EntityRadarCategorySettings.ALWAYS_NAMETAGS);
        this.radarColor = RadarColor.fromIndex(entityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue());
        this.fallbackColor = this.radarSession.getColorHelper().getFallbackColor(entityCategory);
        this.displayY = entityCategory.getSettingValue(EntityRadarCategorySettings.DISPLAY_Y).intValue();
        this.nameSettingForCategory = entityCategory.getSettingValue(EntityRadarCategorySettings.NAMES).intValue();
        this.namesForCategory = this.nameSettingForCategory == 1 && ((RadarRenderContext)this.context).playerListDown || this.nameSettingForCategory == 2;
    }

    private void setupRenderForEntity(Entity entity) {
        boolean name;
        if (!this.radarRenderProvider.isUsed()) {
            this.radarRenderProvider.setupContextForEntity(entity, (RadarRenderContext)this.context);
        }
        if (!(name = this.namesForCategory) && !(entity instanceof Player)) {
            name = this.alwaysNameTags && entity.m_8077_();
        }
        this.name = name;
    }

    private void confirmTrackedPlayerRadarRender(Player e) {
        if (HudMod.INSTANCE.getTrackedPlayerRenderer().getCollector().playerExists(e.m_20148_())) {
            HudMod.INSTANCE.getTrackedPlayerRenderer().getCollector().confirmPlayerRadarRender(e);
        }
        if (!HudMod.INSTANCE.getSupportMods().worldmap()) {
            return;
        }
        if (HudMod.INSTANCE.getSupportMods().worldmapSupport.hasTrackedPlayerSystemSupport()) {
            HudMod.INSTANCE.getSupportMods().worldmapSupport.confirmPlayerRadarRender(e);
            return;
        }
        if (!HudMod.INSTANCE.getSupportMods().pac()) {
            return;
        }
        if (HudMod.INSTANCE.getSupportMods().worldmapSupport.supportsPacPlayerRadarFilter()) {
            HudMod.INSTANCE.getSupportMods().worldmapSupport.confirmPlayerRadarRender(e);
        }
    }

    public void renderSingleEntity(Entity entity, boolean cave, boolean highlighted, float optionalScale, boolean allowIcon, boolean allowLabel, MinimapElementRenderLocation location, RenderTarget defaultFramebuffer, GuiGraphics guiGraphics) {
        ((RadarRenderContext)this.context).entityCategory = null;
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        MinimapElementRenderInfo renderInfo = new MinimapElementRenderInfo(location, entity, (Player)player, entity.m_20182_(), cave, 1.0f, defaultFramebuffer, 1.0, (ResourceKey<Level>)entity.m_9236_().m_46472_());
        MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers = session.getMultiTextureRenderTypeRenderers();
        MultiBufferSource.BufferSource vanillaBufferSource = guiGraphics.m_280091_();
        this.preRender(renderInfo, vanillaBufferSource, multiTextureRenderTypeRenderers);
        this.iconsAllowed = allowIcon;
        this.labelsAllowed = allowLabel;
        this.renderElement(entity, highlighted, false, 0.0, optionalScale, 0.0, 0.0, renderInfo, guiGraphics, vanillaBufferSource);
        this.postRender(renderInfo, vanillaBufferSource, multiTextureRenderTypeRenderers);
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        if (!this.minimap.usingFBO()) {
            return false;
        }
        if (location == MinimapElementRenderLocation.WORLD_MAP) {
            return true;
        }
        if (location == MinimapElementRenderLocation.WORLD_MAP_MENU) {
            return true;
        }
        return HudMod.INSTANCE.getSettings().getEntityRadar();
    }

    public static final class Builder {
        private RadarIconManager radarIconManager;
        private Minimap minimap;

        private Builder() {
        }

        public Builder setDefault() {
            this.setRadarIconManager(null);
            return this;
        }

        public Builder setRadarIconManager(RadarIconManager radarIconManager) {
            this.radarIconManager = radarIconManager;
            return this;
        }

        public Builder setMinimap(Minimap minimap) {
            this.minimap = minimap;
            return this;
        }

        public RadarRenderer build() {
            if (this.radarIconManager == null || this.minimap == null) {
                throw new IllegalStateException();
            }
            xaero.common.minimap.render.radar.element.RadarElementReader elementReader = new xaero.common.minimap.render.radar.element.RadarElementReader();
            xaero.common.minimap.render.radar.element.RadarRenderProvider provider = new xaero.common.minimap.render.radar.element.RadarRenderProvider();
            xaero.common.minimap.render.radar.element.RadarRenderContext context = new xaero.common.minimap.render.radar.element.RadarRenderContext();
            return new xaero.common.minimap.render.radar.element.RadarRenderer(this.radarIconManager, this.minimap, elementReader, provider, context);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

