/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenHitTileEntity;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScreenHitBlock
extends BaseBlock {
    public ScreenHitBlock() {
        super(new BlockBuilder().properties(BlockBehaviour.Properties.m_284310_().m_60913_(-1.0f, 3600000.0f).m_278166_(PushReaction.BLOCK).m_60918_(SoundType.f_56743_)).tileEntitySupplier(ScreenHitTileEntity::new));
    }

    @Nonnull
    public ItemStack m_7397_(@Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        BlockPos screenPos = this.getScreenBlockPos(worldIn, pos);
        if (screenPos == null) {
            return ItemStack.f_41583_;
        }
        BlockState screenState = worldIn.m_8055_(screenPos);
        return screenState.m_60734_().m_7397_(worldIn, screenPos, screenState);
    }

    public void m_6256_(@Nonnull BlockState s, Level world, @Nonnull BlockPos pos, @Nonnull Player player) {
        if (world.f_46443_) {
            int dz;
            int dy;
            ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.m_7702_(pos);
            int dx = screenHitTileEntity.getDx();
            BlockState state = world.m_8055_(pos.m_7918_(dx, dy = screenHitTileEntity.getDy(), dz = screenHitTileEntity.getDz()));
            Block block = state.m_60734_();
            if (block != ScreenModule.SCREEN.get() && block != ScreenModule.CREATIVE_SCREEN.get()) {
                return;
            }
            HitResult mouseOver = SafeClientTools.getClientMouseOver();
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.m_7702_(pos.m_7918_(dx, dy, dz));
            if (mouseOver instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)mouseOver;
                screenTileEntity.hitScreenClient(mouseOver.m_82450_().f_82479_ - (double)pos.m_123341_() - (double)dx, mouseOver.m_82450_().f_82480_ - (double)pos.m_123342_() - (double)dy, mouseOver.m_82450_().f_82481_ - (double)pos.m_123343_() - (double)dz, blockHit.m_82434_(), (Direction)state.m_61143_((Property)ScreenBlock.HORIZ_FACING));
            }
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        return this.activate(world, pos, state, player, hand, result);
    }

    public InteractionResult activate(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        if ((pos = this.getScreenBlockPos((BlockGetter)world, pos)) == null) {
            return InteractionResult.PASS;
        }
        Block block = world.m_8055_(pos).m_60734_();
        return ((ScreenBlock)block).activate(world, pos, state, player, hand, result);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot) {
        return state;
    }

    public BlockPos getScreenBlockPos(BlockGetter world, BlockPos pos) {
        int dz;
        int dy;
        ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.m_7702_(pos);
        int dx = screenHitTileEntity.getDx();
        Block block = world.m_8055_(pos = pos.m_7918_(dx, dy = screenHitTileEntity.getDy(), dz = screenHitTileEntity.getDz())).m_60734_();
        if (block != ScreenModule.SCREEN.get() && block != ScreenModule.CREATIVE_SCREEN.get()) {
            return null;
        }
        return pos;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        if (facing == Direction.NORTH) {
            return ScreenBlock.NORTH_AABB;
        }
        if (facing == Direction.SOUTH) {
            return ScreenBlock.SOUTH_AABB;
        }
        if (facing == Direction.WEST) {
            return ScreenBlock.WEST_AABB;
        }
        if (facing == Direction.EAST) {
            return ScreenBlock.EAST_AABB;
        }
        if (facing == Direction.UP) {
            return ScreenBlock.UP_AABB;
        }
        if (facing == Direction.DOWN) {
            return ScreenBlock.DOWN_AABB;
        }
        return ScreenBlock.BLOCK_AABB;
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public void m_7592_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }
}

