/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.rftoolsutility.modules.screen.MachineInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record PacketReturnRfInRange(Map<BlockPos, MachineInfo> levels) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsutility", "returnrfinrange");
    public static Map<BlockPos, MachineInfo> clientLevels;

    public static PacketReturnRfInRange create(Map<BlockPos, MachineInfo> result) {
        return new PacketReturnRfInRange(result);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.levels.size());
        for (Map.Entry<BlockPos, MachineInfo> entry : this.levels.entrySet()) {
            buf.m_130064_(entry.getKey());
            MachineInfo info = entry.getValue();
            buf.writeLong(info.energy());
            buf.writeLong(info.maxEnergy());
            if (info.energyPerTick() != null) {
                buf.writeBoolean(true);
                buf.writeLong(info.energyPerTick().longValue());
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public Map<BlockPos, MachineInfo> getLevels() {
        return this.levels;
    }

    public static PacketReturnRfInRange create(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashMap<BlockPos, MachineInfo> levels = new HashMap<BlockPos, MachineInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buf.m_130135_();
            long e = buf.readLong();
            long m = buf.readLong();
            Long usage = null;
            if (buf.readBoolean()) {
                usage = buf.readLong();
            }
            levels.put(pos, new MachineInfo(e, m, usage));
        }
        return new PacketReturnRfInRange(levels);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            clientLevels = this.levels;
        });
    }
}

