/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.itemblacklist.blacklist;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.pitbox46.itemblacklist.ItemBlacklist;
import github.pitbox46.itemblacklist.blacklist.Group;
import github.pitbox46.itemblacklist.blacklist.ItemBanPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record Blacklist(ArrayList<ItemBanPredicate> bannedItems, HashMap<String, Group> groups) {
    public static final Codec<Blacklist> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemBanPredicate.CODEC.listOf().fieldOf("items").orElse(new ArrayList()).xmap(ArrayList::new, ArrayList::new).forGetter(Blacklist::bannedItems), (App)Group.CODEC.listOf().fieldOf("groups").orElse(new ArrayList()).xmap(l -> (HashMap)Util.m_137469_(new HashMap(l.size()), map -> l.forEach(group -> map.put(group.name(), group))), map -> new ArrayList(map.values())).forGetter(Blacklist::groups)).apply((Applicative)instance, Blacklist::new));

    public boolean shouldBan(@Nullable ItemStack stack, @Nullable Player player) {
        if (stack == null) {
            return false;
        }
        for (ItemBanPredicate pred : this.bannedItems) {
            if (!pred.test(stack, player)) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayerInGroups(Collection<String> groupKeys, Player player) {
        return groupKeys.stream().anyMatch(key -> {
            Group group = this.groups.get(key);
            return group != null && group.test(player);
        });
    }

    public void addItem(ItemStack stack) {
        this.addItem(stack, false, "default");
    }

    public void addItem(ItemStack stack, boolean includeTag, String groupKey) {
        if (stack.m_41619_()) {
            return;
        }
        ItemPredicate.Builder builder = ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{stack.m_41720_()});
        if (includeTag && stack.m_41782_()) {
            builder.m_45075_(stack.m_41783_());
        }
        ItemPredicate itemPredicate = builder.m_45077_();
        Optional<ItemBanPredicate> matchingPred = this.bannedItems.stream().filter(pred -> itemPredicate.equals(pred.itemPredicate())).findAny();
        if (matchingPred.isPresent()) {
            matchingPred.get().groupKeys().add(groupKey);
        } else {
            ItemBanPredicate pred2 = new ItemBanPredicate(itemPredicate, (ArrayList)Util.m_137469_(new ArrayList(), l -> l.add(groupKey)), true);
            this.bannedItems.add(pred2);
        }
    }

    public boolean searchAndRemove(ItemStack stack) {
        return this.bannedItems.removeIf(pred -> pred.itemPredicate().m_45049_(stack));
    }

    public void recalculate() {
        this.bannedItems.forEach(ItemBanPredicate::recalculate);
    }

    public static Blacklist emptyBlacklist() {
        return new Blacklist(new ArrayList<ItemBanPredicate>(), (HashMap)Util.m_137469_(new HashMap(), map -> map.put("default", new Group("default", Group.Properties.EMPTY))));
    }

    public JsonElement encodeToJSON(HolderLookup.Provider levelRegistryAccess) {
        DataResult encoded = CODEC.encodeStart((DynamicOps)RegistryOps.m_255058_((DynamicOps)ItemBlacklist.MODIFIED_JSON_OPS, (HolderLookup.Provider)levelRegistryAccess), (Object)this);
        return (JsonElement)encoded.result().orElseThrow();
    }

    public static Blacklist readBlacklist(HolderLookup.Provider levelRegistryAccess, JsonObject json) {
        Blacklist blacklist = CODEC.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)ItemBlacklist.MODIFIED_JSON_OPS, (HolderLookup.Provider)levelRegistryAccess), (Object)json).resultOrPartial(m -> ItemBlacklist.LOGGER.warn("Could not read blacklist: {}", m)).orElseGet(Blacklist::emptyBlacklist);
        return blacklist;
    }
}

