/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.integration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.violetmoon.zeta.config.ConfigFlagManager;
import org.violetmoon.zeta.config.ConfigObjectMapper;
import org.violetmoon.zeta.event.load.ZGatherHints;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.RegistryUtil;

class JeiGatherHints
implements ZGatherHints {
    private final IRecipeRegistration registration;
    private final String modId;
    private final RegistryAccess registryAccess;
    private final List<Item> blacklist;
    private final MutableComponent externalPreamble;

    public JeiGatherHints(IRecipeRegistration registration, String modId, RegistryAccess registryAccess, List<Item> blacklist) {
        this.registration = registration;
        this.modId = modId;
        this.registryAccess = registryAccess;
        this.blacklist = blacklist;
        this.externalPreamble = Component.m_237115_((String)(modId + ".jei.hint.preamble"));
        this.externalPreamble.m_6270_(this.externalPreamble.m_7383_().m_178520_(744779));
    }

    @Override
    public void accept(ItemLike itemLike, Component extra) {
        Item item = itemLike.m_5456_();
        if (this.blacklist.contains(item)) {
            return;
        }
        MutableComponent compound = Component.m_237113_((String)"");
        if (!BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135827_().equals(this.modId)) {
            compound = compound.m_7220_((Component)this.externalPreamble);
        }
        compound = compound.m_7220_(extra);
        this.registration.addItemStackInfo(new ItemStack((ItemLike)item), new Component[]{compound});
    }

    private void applyTag(TagKey<?> tkey, String key, Object ... extra) {
        if (key.isEmpty()) {
            key = tkey.f_203868_().m_135815_();
        }
        try {
            List<?> tagItems = RegistryUtil.getTagValues(this.registryAccess, tkey);
            this.applyIterable(tagItems, key, extra);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("TagKey " + String.valueOf(tkey) + " failed to load.", e);
        }
    }

    private void applyIterable(Iterable<?> iter, String key, Object ... extra) {
        if (key.isEmpty()) {
            throw new RuntimeException("Multi-item @Hints need a defined key.");
        }
        for (Object obj : iter) {
            this.applyObject(obj, key, extra);
        }
    }

    private void applyObject(Object obj, String key, Object ... extra) {
        if (!(obj instanceof ItemLike)) {
            throw new RuntimeException("Not an ItemLike.");
        }
        ItemLike ilike = (ItemLike)obj;
        this.applyItemLike(ilike, key, extra);
    }

    private void applyItemLike(ItemLike itemLike, String key, Object ... extra) {
        if (key.isEmpty()) {
            this.hintItem(itemLike, extra);
        } else {
            this.hintItem(itemLike, key, extra);
        }
    }

    @Override
    public void hintItem(ItemLike itemLike, Object ... extra) {
        Item item = itemLike.m_5456_();
        ResourceLocation res = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        Object ns = res.m_135827_();
        String path = res.m_135815_();
        ns = ((String)ns).equals(this.modId) ? "" : (String)ns + ".";
        this.hintItem(itemLike, (String)ns + path, extra);
    }

    @Override
    public void hintItem(ItemLike itemLike, String key, Object ... extra) {
        Item item = itemLike.m_5456_();
        String hint = this.modId + ".jei.hint." + key;
        this.accept((ItemLike)item, (Component)Component.m_237110_((String)hint, (Object[])extra));
    }

    @Override
    public void gatherHintsFromModule(ZetaModule module, ConfigFlagManager cfm) {
        if (!module.isEnabled()) {
            return;
        }
        List<Field> fields = ConfigObjectMapper.walkModuleFields(module.getClass());
        HashMap<String, Field> fieldsByName = new HashMap<String, Field>();
        for (Field f : fields) {
            fieldsByName.put(f.getName(), f);
        }
        for (Field f : fields) {
            try {
                String flag;
                Hint hint = f.getAnnotation(Hint.class);
                if (hint == null) continue;
                f.setAccessible(true);
                Object target = ConfigObjectMapper.getField(module, f);
                if (target == null || !(flag = hint.value()).isEmpty() && cfm.getFlag(flag) == !hint.negate()) continue;
                String key = hint.key();
                ArrayList<Object> extraList = new ArrayList<Object>(hint.content().length);
                for (String c : hint.content()) {
                    if (c.isEmpty()) continue;
                    Field extraField = (Field)fieldsByName.get(c);
                    if (extraField == null) {
                        throw new RuntimeException("No field " + c + " referenced in @Hint " + String.valueOf(f));
                    }
                    Object yes = ConfigObjectMapper.getField(module, extraField);
                    extraList.add(yes);
                }
                Object[] extra = extraList.toArray(new Object[0]);
                if (target instanceof TagKey) {
                    TagKey tkey = (TagKey)target;
                    this.applyTag(tkey, key, extra);
                    continue;
                }
                if (target instanceof Iterable) {
                    Iterable iter = (Iterable)target;
                    this.applyIterable(iter, key, extra);
                    continue;
                }
                this.applyObject(target, key, extra);
            }
            catch (Exception e) {
                throw new RuntimeException("Problem applying annotation hint " + f.getName() + " from module " + module.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
    }

    @Override
    public RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }
}

