/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.item.ext;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IZetaItemExtensions {
    default public InteractionResult onItemUseFirstZeta(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public boolean isRepairableZeta(ItemStack stack) {
        return false;
    }

    default public boolean onEntityItemUpdateZeta(ItemStack stack, ItemEntity ent) {
        return false;
    }

    default public boolean doesSneakBypassUseZeta(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }

    default public boolean canEquipZeta(ItemStack stack, EquipmentSlot equipmentSlot, Entity ent) {
        return false;
    }

    default public boolean isBookEnchantableZeta(ItemStack stack, ItemStack book) {
        return true;
    }

    @Nullable
    default public String getArmorTextureZeta(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return null;
    }

    default public int getMaxDamageZeta(ItemStack stack) {
        return stack.m_41720_().m_41462_();
    }

    default public boolean canShearZeta(ItemStack stack) {
        return stack.m_41720_() instanceof ShearsItem;
    }

    default public int getEnchantmentValueZeta(ItemStack stack) {
        return stack.m_41720_().m_6473_();
    }

    default public boolean canApplyAtEnchantingTableZeta(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    default public int getEnchantmentLevelZeta(ItemStack stack, Enchantment enchantment) {
        return EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)stack);
    }

    default public Map<Enchantment, Integer> getAllEnchantmentsZeta(ItemStack stack) {
        return EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
    }

    default public boolean shouldCauseReequipAnimationZeta(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }

    default public int getBurnTimeZeta(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        return 0;
    }

    default public <T extends LivingEntity> int damageItemZeta(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return amount;
    }

    default public boolean isEnderMaskZeta(ItemStack stack, Player player, EnderMan enderboy) {
        return stack.m_41720_() == Items.f_42047_;
    }

    default public boolean canElytraFlyZeta(ItemStack stack, LivingEntity entity) {
        return stack.m_41720_() instanceof ElytraItem && ElytraItem.m_41140_((ItemStack)stack);
    }

    default public int getDefaultTooltipHideFlagsZeta(@NotNull ItemStack stack) {
        return 0;
    }
}

