/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.fluid;

import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.fluid.IFluidTankUpdater;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public class FluidTankBase<T extends MantleBlockEntity>
extends FluidTank {
    protected T parent;

    public FluidTankBase(int capacity, T parent) {
        super(capacity);
        this.parent = parent;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            int filled = Math.min(this.capacity, resource.getAmount());
            this.fluid = new FluidStack(resource, filled);
            this.onContentsChanged();
            return filled;
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        if (filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    public void onContentsChanged() {
        if (this.parent instanceof IFluidTankUpdater) {
            ((IFluidTankUpdater)this.parent).onTankContentsChanged();
        }
        this.parent.m_6596_();
        Level level = this.parent.m_58904_();
        if (level != null && !level.f_46443_) {
            TinkerNetwork.getInstance().sendToClientsAround(new FluidUpdatePacket(this.parent.m_58899_(), this.getFluid()), (LevelAccessor)level, this.parent.m_58899_());
        }
    }
}

