/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.math.IntMath;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;

public class IncrementalModifierEntry
extends ModifierEntry {
    private final int amount;
    private final int needed;
    private final float effectiveLevel;

    protected IncrementalModifierEntry(LazyModifier modifier, int level, int amount, int needed) {
        super(modifier, level);
        this.amount = Math.max(0, amount);
        this.needed = Math.max(0, needed);
        this.effectiveLevel = amount >= needed ? (float)level : IncrementalModifierEntry.scaleLevel(level, amount, needed);
    }

    public static ModifierEntry of(LazyModifier modifier, int level, int amount, int needed) {
        if (needed == 0 || amount >= needed) {
            return new ModifierEntry(modifier, level);
        }
        if (amount <= 0) {
            return new ModifierEntry(modifier, level - 1);
        }
        return new IncrementalModifierEntry(modifier, level, amount, needed);
    }

    public static ModifierEntry of(ModifierId modifier, int level, int amount, int needed) {
        return IncrementalModifierEntry.of(new LazyModifier(modifier), level, amount, needed);
    }

    public static ModifierEntry of(Modifier modifier, int level, int amount, int needed) {
        return IncrementalModifierEntry.of(new LazyModifier(modifier), level, amount, needed);
    }

    @Override
    public int getAmount(int fallback) {
        return this.amount;
    }

    @Override
    public int intEffectiveLevel() {
        return this.level - 1;
    }

    @Override
    public Component getDisplayName() {
        Component name = super.getDisplayName();
        if (this.amount < this.needed) {
            return IncrementalModifierEntry.addAmountToName(name, this.amount, this.needed);
        }
        return name;
    }

    @Override
    public ModifierEntry addAmount(int amount, int needed) {
        if (needed <= 0 || amount <= 0) {
            return this;
        }
        if (amount >= needed) {
            return new ModifierEntry(this.modifier, this.level);
        }
        if (needed == this.needed) {
            amount += this.amount;
        } else {
            int gcd = IntMath.gcd((int)needed, (int)this.needed);
            int newMultiplier = this.needed / gcd;
            amount = this.amount * needed / gcd + amount * newMultiplier;
            needed *= newMultiplier;
        }
        return IncrementalModifierEntry.of(this.modifier, this.level, amount, needed);
    }

    @Override
    public ModifierEntry withLevel(int level) {
        return new IncrementalModifierEntry(this.modifier, level, this.amount, this.needed);
    }

    @Override
    public ModifierEntry merge(ModifierEntry other) {
        if (!this.getId().equals((Object)other.getId())) {
            throw new IllegalArgumentException("Modifiers do not match, have " + this.getId() + " but was given " + other.getId());
        }
        return this.withLevel(this.level + other.intEffectiveLevel()).addAmount(other.getAmount(0), other.getNeeded());
    }

    @Override
    public CompoundTag serializeToNBT() {
        CompoundTag tag = super.serializeToNBT();
        tag.m_128405_("amount", this.amount);
        tag.m_128405_("needed", this.needed);
        tag.m_128350_("effective", this.effectiveLevel);
        return tag;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncrementalModifierEntry entry = (IncrementalModifierEntry)o;
        return this.matches(entry.getId()) && this.level == entry.level && this.amount == entry.amount && this.needed == entry.needed;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * super.hashCode() + this.amount) + this.needed;
    }

    @Override
    public String toString() {
        return "IncrementalModifierEntry{" + this.modifier.getId() + ",level=" + this.level + ",amount=" + this.amount + "/" + this.needed + "}";
    }

    public static float scaleLevel(float level, int amount, int neededPerLevel) {
        if (amount < neededPerLevel) {
            return level + (float)(amount - neededPerLevel) / (float)neededPerLevel;
        }
        return level;
    }

    public static Component addAmountToName(Component name, int amount, int neededPerLevel) {
        return name.m_6881_().m_130946_(": " + amount + " / " + neededPerLevel);
    }

    @Override
    public int getNeeded() {
        return this.needed;
    }

    @Override
    public float getEffectiveLevel() {
        return this.effectiveLevel;
    }
}

