/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;

public interface TinkerSuggestionProvider {
    public static <T> void filterResources(String defaultDomain, Iterable<T> resources, String input, Function<T, ResourceLocation> idGetter, Consumer<T> resultConsumer) {
        boolean hasNamespace = input.indexOf(58) > -1;
        for (T resource : resources) {
            ResourceLocation location = idGetter.apply(resource);
            if (hasNamespace) {
                String locationStr = location.toString();
                if (!SharedSuggestionProvider.m_82949_((String)input, (String)locationStr)) continue;
                resultConsumer.accept(resource);
                continue;
            }
            if (!SharedSuggestionProvider.m_82949_((String)input, (String)location.m_135827_()) && (!defaultDomain.equals(location.m_135827_()) || !SharedSuggestionProvider.m_82949_((String)input, (String)location.m_135815_()))) continue;
            resultConsumer.accept(resource);
        }
    }

    public static CompletableFuture<Suggestions> suggestResource(String defaultDomain, Iterable<ResourceLocation> resources, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        TinkerSuggestionProvider.filterResources(defaultDomain, resources, remaining, loc -> loc, loc -> builder.suggest(loc.toString()));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestResource(String defaultDomain, Stream<ResourceLocation> resources, SuggestionsBuilder builder) {
        return TinkerSuggestionProvider.suggestResource(defaultDomain, resources::iterator, builder);
    }

    public static <T> CompletableFuture<Suggestions> suggestResource(String defaultDomain, Iterable<T> resources, SuggestionsBuilder builder, Function<T, ResourceLocation> idGetter, Function<T, Message> tooltip) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        TinkerSuggestionProvider.filterResources(defaultDomain, resources, remaining, idGetter, resource -> builder.suggest(((ResourceLocation)idGetter.apply(resource)).toString(), (Message)tooltip.apply(resource)));
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> suggestResource(String defaultDomain, Stream<T> resources, SuggestionsBuilder builder, Function<T, ResourceLocation> idGetter, Function<T, Message> tooltip) {
        return TinkerSuggestionProvider.suggestResource(defaultDomain, resources::iterator, builder, idGetter, tooltip);
    }
}

