/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.world.block.FoliageType;

public class SlimeLeavesBlock
extends LeavesBlock {
    private final FoliageType foliageType;

    public SlimeLeavesBlock(BlockBehaviour.Properties properties, FoliageType foliageType) {
        super(properties);
        this.foliageType = foliageType;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = SlimeLeavesBlock.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.m_61143_((Property)f_54418_) != i) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return stateIn;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        worldIn.m_7731_(pos, SlimeLeavesBlock.m_54435_(state, (LevelAccessor)worldIn, pos), 3);
    }

    private static BlockState m_54435_(BlockState state, LevelAccessor world, BlockPos pos) {
        int i = 7;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutableBlockPos.m_122190_((Vec3i)pos).m_122173_(direction);
            i = Math.min(i, SlimeLeavesBlock.getDistance(world.m_8055_((BlockPos)mutableBlockPos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(BlockState neighbor) {
        if (neighbor.m_204336_(TinkerTags.Blocks.SLIMY_LOGS)) {
            return 0;
        }
        return neighbor.m_60734_() instanceof SlimeLeavesBlock ? (Integer)neighbor.m_61143_((Property)f_54418_) : 7;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return SlimeLeavesBlock.m_54435_((BlockState)this.m_49966_().m_61124_((Property)f_54419_, (Comparable)Boolean.TRUE), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public FoliageType getFoliageType() {
        return this.foliageType;
    }
}

