/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.ModelPartAnimator;
import com.faboslav.friendsandfoes.common.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.util.animation.AnimationMath;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class GlareEntityModel<T extends GlareEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_ROOT = "root";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_EYES = "eyes";
    private static final String MODEL_TOP_AZALEA = "topAzalea";
    private static final String MODEL_BOTTOM_AZALEA = "bottomAzalea";
    private static final String MODEL_SECOND_LAYER = "secondLayer";
    private static final String MODEL_THIRD_LAYER = "thirdLayer";
    private static final String MODEL_FOURTH_LAYER = "fourthLayer";
    private final ModelPart head;
    private final ModelPart eyes;
    private final ModelPart topAzalea;
    private final ModelPart bottomAzalea;
    private final ModelPart secondLayer;
    private final ModelPart thirdLayer;
    private final ModelPart fourthLayer;
    private final ModelPart[] layers;

    public GlareEntityModel(ModelPart root) {
        super(root);
        this.head = this.root.m_171324_(MODEL_PART_HEAD);
        this.eyes = this.head.m_171324_(MODEL_PART_EYES);
        this.topAzalea = this.head.m_171324_(MODEL_TOP_AZALEA);
        this.bottomAzalea = this.head.m_171324_(MODEL_BOTTOM_AZALEA);
        this.secondLayer = this.bottomAzalea.m_171324_(MODEL_SECOND_LAYER);
        this.thirdLayer = this.secondLayer.m_171324_(MODEL_THIRD_LAYER);
        this.fourthLayer = this.thirdLayer.m_171324_(MODEL_FOURTH_LAYER);
        this.layers = new ModelPart[]{this.secondLayer, this.thirdLayer, this.fourthLayer};
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.m_171576_();
        root.m_171599_(MODEL_PART_HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, 0.0f, -3.0f, 12.0f, 9.0f, 9.0f, new CubeDeformation(-0.02f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition head = root.m_171597_(MODEL_PART_HEAD);
        head.m_171599_(MODEL_PART_EYES, CubeListBuilder.m_171558_().m_171514_(33, 0).m_171488_(2.0f, -1.0f, -0.3f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(33, 0).m_171488_(-4.0f, -1.0f, -0.3f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-3.0f));
        head.m_171599_(MODEL_TOP_AZALEA, CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-7.0f, 0.0f, -7.0f, 14.0f, 8.0f, 14.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_(MODEL_BOTTOM_AZALEA, CubeListBuilder.m_171558_().m_171514_(18, 101).m_171480_().m_171488_(-7.0f, 0.75f, -7.0f, 14.0f, 0.0f, 14.0f, new CubeDeformation(-0.01f)).m_171555_(false).m_171514_(0, 40).m_171488_(-7.0f, -4.0f, -7.0f, 14.0f, 10.0f, 14.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition bottomAzalea = head.m_171597_(MODEL_BOTTOM_AZALEA);
        bottomAzalea.m_171599_(MODEL_SECOND_LAYER, CubeListBuilder.m_171558_().m_171514_(0, 64).m_171488_(-6.0f, 0.0f, -6.0f, 12.0f, 7.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition secondLayer = bottomAzalea.m_171597_(MODEL_SECOND_LAYER);
        secondLayer.m_171599_(MODEL_THIRD_LAYER, CubeListBuilder.m_171558_().m_171514_(0, 83).m_171488_(-5.0f, 0.0f, -5.0f, 10.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition thirdLayer = secondLayer.m_171597_(MODEL_THIRD_LAYER);
        thirdLayer.m_171599_(MODEL_FOURTH_LAYER, CubeListBuilder.m_171558_().m_171514_(0, 100).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)128);
    }

    public void setAngles(T glare, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateEyes(glare);
        this.animateFloating(glare, animationProgress);
        float movementForce = Mth.m_14031_((float)(limbAngle * 0.1f)) * limbDistance * 0.75f;
        float absMovementForce = Math.abs(movementForce);
        if (absMovementForce >= 0.001f) {
            this.head.f_104203_ = AnimationMath.toRadians(40.0f * absMovementForce);
            this.head.f_104205_ = AnimationMath.toRadians(15.0f * movementForce);
            for (ModelPart layer : this.layers) {
                layer.f_104203_ = AnimationMath.toRadians(30.0f * absMovementForce);
                layer.f_104205_ = AnimationMath.toRadians(15.0f * movementForce);
            }
        } else {
            this.head.f_104203_ = AnimationMath.toRadians(0.5f * AnimationMath.sin(animationProgress * 0.125f));
            this.head.f_104205_ = AnimationMath.toRadians(0.5f * AnimationMath.cos(animationProgress * 0.125f));
            for (ModelPart layer : this.layers) {
                layer.f_104203_ = AnimationMath.toRadians(0.75f * AnimationMath.sin(animationProgress * 0.1f));
                layer.f_104205_ = AnimationMath.toRadians(0.75f * AnimationMath.cos(animationProgress * 0.1f));
            }
        }
    }

    public void animateModel(T glare, float limbAngle, float limbDistance, float tickDelta) {
    }

    private void animateFloating(T glare, float animationProgress) {
        float horizontalFloatingOffset;
        float verticalFloatingOffset;
        float horizontalFloatingSpeed;
        float verticalFloatingSpeed = ((GlareEntity)glare).isGrumpy() ? 0.3f : 0.1f;
        float f = horizontalFloatingSpeed = ((GlareEntity)glare).isGrumpy() ? 0.15f : 0.05f;
        if (((GlareEntity)glare).m_21827_()) {
            verticalFloatingOffset = 0.5f;
            horizontalFloatingOffset = 0.5f;
        } else {
            verticalFloatingOffset = 1.5f;
            horizontalFloatingOffset = 1.0f;
        }
        float targetPivotY = ((GlareEntity)glare).m_21827_() ? 3.0f : 0.11f;
        GlareEntityModel.animateModelPartYPositionBasedOnTicks(glare, this.root, targetPivotY, 10);
        if (((GlareEntity)glare).isGrumpy()) {
            ModelPartAnimator.setXPosition(this.root, AnimationMath.sin(animationProgress, 0.5f));
            ModelPartAnimator.setYPosition(this.root, AnimationMath.absSin(animationProgress, 0.1f));
            ModelPartAnimator.setYRotation(this.root, AnimationMath.sin(animationProgress, 0.05f));
        }
        float verticalFloatingProgress = AnimationMath.sin(animationProgress * verticalFloatingSpeed) * verticalFloatingOffset;
        float horizontalFloatingProgress = AnimationMath.cos(animationProgress * horizontalFloatingSpeed) * horizontalFloatingOffset;
        this.head.f_104201_ = verticalFloatingProgress;
        this.head.f_104200_ = horizontalFloatingProgress;
    }

    private void animateEyes(T glare) {
        Vec2 targetEyesPositionOffset = ((GlareEntity)glare).getTargetEyesPositionOffset();
        GlareEntityModel.animateModelPartPositionBasedOnTicks(glare, this.eyes, this.eyes.f_104200_ + targetEyesPositionOffset.f_82470_, this.eyes.f_104201_ + targetEyesPositionOffset.f_82471_, this.eyes.f_104202_, 10);
    }
}

