/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.TuffGolemAnimations;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.ai.brain.TuffGolemBrain;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.pose.TuffGolemEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class TuffGolemEntity
extends AbstractGolem
implements AnimatedEntity {
    private static final EntityDataAccessor<String> COLOR = SynchedEntityData.m_135353_(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Pose> PREV_POSE = SynchedEntityData.m_135353_(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135045_);
    private static final EntityDataAccessor<Integer> POSE_TICKS = SynchedEntityData.m_135353_(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_GLUED = SynchedEntityData.m_135353_(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<CompoundTag> HOME = SynchedEntityData.m_135353_(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final float MOVEMENT_SPEED = 0.225f;
    private static final float MOVEMENT_SPEED_WITH_ITEM = 0.175f;
    private static final int TUFF_HEAL_AMOUNT = 5;
    private static final int INACTIVE_TICKS_AFTER_SPAWN = 200;
    private static final String COLOR_NBT_NAME = "Color";
    private static final String PREV_POSE_NBT_NAME = "PrevPose";
    private static final String POSE_NBT_NAME = "Pose";
    private static final String IS_GLUED_NBT_NAME = "IsGlued";
    private static final String HOME_NBT_NAME = "Home";
    private static final String HOME_NBT_NAME_X = "x";
    private static final String HOME_NBT_NAME_Y = "y";
    private static final String HOME_NBT_NAME_Z = "z";
    private static final String HOME_NBT_NAME_YAW = "yaw";
    private int inactiveTicksAfterSpawn = 0;
    private AnimationContextTracker animationContextTracker;

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
                this.animationContextTracker.add(keyframeAnimation);
            }
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<KeyframeAnimation> getAnimations() {
        return TuffGolemAnimations.ANIMATIONS;
    }

    @Override
    public KeyframeAnimation getMovementAnimation() {
        if (this.isHoldingItem()) {
            return TuffGolemAnimations.WALK_WITH_ITEM;
        }
        return TuffGolemAnimations.WALK;
    }

    @Override
    public int getKeyframeAnimationTicks() {
        return (Integer)this.f_19804_.m_135370_(POSE_TICKS);
    }

    @Override
    public void setKeyframeAnimationTicks(int keyframeAnimationTicks) {
        this.f_19804_.m_135381_(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    public TuffGolemEntity(EntityType<? extends TuffGolemEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        SpawnGroupData superEntityData = super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
        if (spawnReason == MobSpawnType.SPAWN_EGG || spawnReason == MobSpawnType.COMMAND) {
            float randomSpawnYaw = 90.0f * (float)this.m_217043_().m_216332_(0, 3);
            this.setSpawnYaw(randomSpawnYaw);
        }
        this.setPrevPose(TuffGolemEntityPose.STANDING.get());
        this.setPoseWithoutPrevPose(TuffGolemEntityPose.STANDING.get());
        this.setHome(this.getNewHome());
        TuffGolemBrain.setSleepCooldown(this);
        this.inactiveTicksAfterSpawn = 200;
        return superEntityData;
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return TuffGolemBrain.create(dynamic);
    }

    public Brain<TuffGolemEntity> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("tuffGolemBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("tuffGolemActivityUpdate");
        TuffGolemBrain.updateActivities(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createTuffGolemAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.225f).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)Color.RED.getName());
        this.f_19804_.m_135372_(PREV_POSE, (Object)TuffGolemEntityPose.STANDING.get());
        this.f_19804_.m_135372_(POSE_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_GLUED, (Object)false);
        this.f_19804_.m_135372_(HOME, (Object)new CompoundTag());
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_(COLOR_NBT_NAME, this.getColor().getName());
        nbt.m_128359_(PREV_POSE_NBT_NAME, this.getPrevPose().name());
        nbt.m_128359_(POSE_NBT_NAME, this.m_20089_().name());
        nbt.m_128379_(IS_GLUED_NBT_NAME, this.isGlued());
        nbt.m_128365_(HOME_NBT_NAME, (Tag)this.getHome());
    }

    public void m_7378_(CompoundTag nbt) {
        String savedPose;
        String prevSavedPose;
        super.m_7378_(nbt);
        this.setColor(Color.fromName(nbt.m_128461_(COLOR_NBT_NAME)));
        this.setGlued(nbt.m_128471_(IS_GLUED_NBT_NAME));
        this.setHome(nbt.m_128469_(HOME_NBT_NAME));
        if (this.isAtHomePos()) {
            this.setSpawnYaw(this.getHomeYaw());
        }
        if ((prevSavedPose = nbt.m_128461_(PREV_POSE_NBT_NAME)) != "") {
            this.setPrevPose(Pose.valueOf((String)nbt.m_128461_(PREV_POSE_NBT_NAME)));
        }
        if ((savedPose = nbt.m_128461_(POSE_NBT_NAME)) != "") {
            this.setPoseWithoutPrevPose(Pose.valueOf((String)nbt.m_128461_(POSE_NBT_NAME)));
            Pose entityPose = Pose.valueOf((String)nbt.m_128461_(POSE_NBT_NAME));
            if (!(this.m_9236_().m_5776_() || entityPose != TuffGolemEntityPose.SLEEPING.get() && entityPose != TuffGolemEntityPose.SLEEPING_WITH_ITEM.get())) {
                this.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                this.m_6274_().m_21936_(MemoryModuleType.f_26371_);
                TuffGolemBrain.resetSleepCooldown(this);
            } else {
                this.setPoseWithoutPrevPose(entityPose);
            }
        }
    }

    private SoundEvent getGlueOnSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_GLUE_ON.get();
    }

    private void playGlueOnSound() {
        this.m_5496_(this.getGlueOnSound(), 1.0f, 1.0f);
    }

    private SoundEvent getGlueOffSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_GLUE_OFF.get();
    }

    private void playGlueOffSound() {
        this.m_5496_(this.getGlueOffSound(), 1.0f, 1.0f);
    }

    public SoundEvent getMoveSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_MOVE.get();
    }

    public void playMoveSound() {
        this.m_5496_(this.getMoveSound(), 1.0f, 1.05f + this.m_217043_().m_188501_() * 0.05f);
    }

    private SoundEvent getRepairSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_REPAIR.get();
    }

    private void playRepairSound() {
        this.m_5496_(this.getRepairSound(), 1.0f, 1.0f + (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f);
    }

    public SoundEvent getWakeSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_WAKE.get();
    }

    public void playWakeSound() {
        this.m_5496_(this.getWakeSound(), 1.0f, 1.05f + this.m_217043_().m_188501_() * 0.05f);
    }

    public SoundEvent getSleepSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_SLEEP.get();
    }

    public void playSleepSound() {
        this.m_5496_(this.getSleepSound(), 1.0f, 1.05f + this.m_217043_().m_188501_() * 0.05f);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_HURT.get();
    }

    protected void m_6677_(DamageSource source) {
        this.f_21363_ = -this.m_8100_();
        this.m_5496_(this.m_7975_(source), 2.0f, 0.7f + this.m_217043_().m_188501_() * 0.15f);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.isInSleepingPose() || state.m_278721_()) {
            return;
        }
        BlockState blockState = this.m_9236_().m_8055_(pos.m_7494_());
        SoundType blockSoundGroup = blockState.m_204336_(BlockTags.f_144271_) ? blockState.m_60827_() : state.m_60827_();
        this.m_5496_(FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_STEP.get(), blockSoundGroup.m_56773_(), 0.75f + this.m_217043_().m_188501_() * 0.15f);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item itemInHand = itemStack.m_41720_();
        boolean interactionResult = false;
        if (itemInHand == Items.f_151048_) {
            interactionResult = this.tryToInteractMobWithTuff(player, itemStack);
        } else if (itemInHand instanceof DyeItem) {
            interactionResult = this.tryToInteractMobWithDye(player, itemStack);
        } else if (itemInHand instanceof HoneycombItem) {
            interactionResult = this.tryToInteractMobWithHoneycomb(player, itemStack);
        } else if (itemInHand instanceof AxeItem) {
            interactionResult = this.tryToInteractMobWithAxe(player, hand, itemStack);
        }
        if (!interactionResult) {
            interactionResult = this.tryToInteractMobWithItem(player, itemStack);
        }
        if (interactionResult) {
            this.m_146852_(GameEvent.f_223708_, (Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    private boolean tryToInteractMobWithTuff(Player player, ItemStack itemStack) {
        if (this.m_21223_() >= this.m_21233_()) {
            return false;
        }
        this.m_5634_(5.0f);
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.playRepairSound();
        return true;
    }

    private boolean tryToInteractMobWithDye(Player player, ItemStack itemStack) {
        Color usedColor = Color.fromDyeColor(((DyeItem)itemStack.m_41720_()).m_41089_());
        if (this.getColor() == usedColor) {
            return false;
        }
        this.setColor(usedColor);
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.m_5496_(SoundEvents.f_144133_, 1.0f, 1.0f);
        return true;
    }

    private boolean tryToInteractMobWithHoneycomb(Player player, ItemStack itemStack) {
        if (this.isGlued()) {
            return false;
        }
        this.setGlued(true);
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.playGlueOnSound();
        ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.f_175828_, 7, 1.0);
        return true;
    }

    private boolean tryToInteractMobWithAxe(Player player, InteractionHand hand, ItemStack itemStack) {
        if (!this.isGlued()) {
            return false;
        }
        this.setGlued(false);
        this.playGlueOffSound();
        ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.f_175829_, 7, 1.0);
        if (!this.m_9236_().m_5776_() && !player.m_150110_().f_35937_) {
            itemStack.m_41622_(1, (LivingEntity)player, playerEntity -> player.m_21190_(hand));
        }
        return true;
    }

    private boolean tryToInteractMobWithItem(Player player, ItemStack itemStack) {
        if (this.m_6844_(EquipmentSlot.MAINHAND).m_41720_() == Items.f_41852_ && itemStack.m_41720_() == Items.f_41852_ || itemStack.m_41720_() instanceof SpawnEggItem || this.isAnyKeyframeAnimationRunning()) {
            return false;
        }
        MovementUtil.stopMovement((Mob)this);
        if (this.isHoldingItem()) {
            if (!player.m_150110_().f_35937_) {
                this.m_19983_(this.m_6844_(EquipmentSlot.MAINHAND));
            }
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            this.startStanding();
        } else {
            ItemStack itemsStackToBeEquipped = itemStack.m_41777_();
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            itemsStackToBeEquipped.m_41764_(1);
            this.m_8061_(EquipmentSlot.MAINHAND, itemsStackToBeEquipped);
            this.startStandingWithItem();
        }
        return true;
    }

    public void setColor(Color color) {
        this.f_19804_.m_135381_(COLOR, (Object)color.getName());
    }

    public Color getColor() {
        return Color.fromName((String)this.f_19804_.m_135370_(COLOR));
    }

    public void m_20124_(Pose pose) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.setPrevPose(this.m_20089_());
        super.m_20124_(pose);
    }

    public void setPoseWithoutPrevPose(Pose pose) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        super.m_20124_(pose);
    }

    public void setPrevPose(Pose pose) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.f_19804_.m_135381_(PREV_POSE, (Object)pose);
    }

    public Pose getPrevPose() {
        return (Pose)this.f_19804_.m_135370_(PREV_POSE);
    }

    public boolean isInPose(TuffGolemEntityPose pose) {
        return this.m_20089_() == pose.get();
    }

    public boolean wasInPose(TuffGolemEntityPose pose) {
        return this.getPrevPose() == pose.get();
    }

    public boolean isInStandingPose() {
        return this.isInPose(TuffGolemEntityPose.STANDING) || this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM);
    }

    public boolean isInSleepingPose() {
        return this.isInPose(TuffGolemEntityPose.SLEEPING) || this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM);
    }

    public boolean isInHoldingItemPose() {
        return this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM) || this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM);
    }

    public void setGlued(boolean isGlued) {
        this.f_19804_.m_135381_(IS_GLUED, (Object)isGlued);
    }

    public boolean isGlued() {
        return (Boolean)this.f_19804_.m_135370_(IS_GLUED);
    }

    public CompoundTag getNewHome() {
        CompoundTag home = new CompoundTag();
        home.m_128347_(HOME_NBT_NAME_X, this.m_20182_().m_7096_());
        home.m_128347_(HOME_NBT_NAME_Y, this.m_20182_().m_7098_());
        home.m_128347_(HOME_NBT_NAME_Z, this.m_20182_().m_7094_());
        home.m_128350_(HOME_NBT_NAME_YAW, this.f_20883_);
        return home;
    }

    public void setHome(CompoundTag home) {
        this.f_19804_.m_135381_(HOME, (Object)home);
    }

    public CompoundTag getHome() {
        return (CompoundTag)this.f_19804_.m_135370_(HOME);
    }

    public Vec3 getHomePos() {
        return new Vec3(this.getHome().m_128459_(HOME_NBT_NAME_X), this.getHome().m_128459_(HOME_NBT_NAME_Y), this.getHome().m_128459_(HOME_NBT_NAME_Z));
    }

    public float getHomeYaw() {
        return this.getHome().m_128457_(HOME_NBT_NAME_YAW);
    }

    public boolean isAtHomePos() {
        return this.m_20238_(this.getHomePos()) < 0.1;
    }

    public boolean isCloseToHomePos(float distance) {
        return this.m_20238_(this.getHomePos()) < (double)distance;
    }

    public boolean isAtHomeYaw() {
        return this.f_20907_ == (double)this.getHomeYaw() && this.f_19859_ == this.getHomeYaw() && this.m_146908_() == this.getHomeYaw() && this.f_20884_ == this.getHomeYaw() && this.m_213816_() == this.getHomeYaw() && this.f_20886_ == this.getHomeYaw() && this.m_6080_() == this.getHomeYaw();
    }

    public boolean isAtHome() {
        return this.isAtHomePos() && this.isAtHomeYaw();
    }

    public boolean isHoldingItem() {
        return this.m_6844_(EquipmentSlot.MAINHAND).m_41720_() != Items.f_41852_;
    }

    public boolean isShowingItem() {
        return this.isHoldingItem() && this.isInHoldingItemPose();
    }

    public boolean isNotImmobilized() {
        return this.getKeyframeAnimationTicks() == 0 && this.inactiveTicksAfterSpawn == 0 && !this.isGlued() && !this.isInSleepingPose();
    }

    public void startSleeping() {
        if (this.isInPose(TuffGolemEntityPose.SLEEPING)) {
            return;
        }
        this.playSleepSound();
        this.m_20124_(TuffGolemEntityPose.SLEEPING.get());
    }

    public void startSleepingWithItem() {
        if (this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
            return;
        }
        this.playSleepSound();
        this.m_20124_(TuffGolemEntityPose.SLEEPING_WITH_ITEM.get());
    }

    public void startStanding() {
        if (this.isInPose(TuffGolemEntityPose.STANDING)) {
            return;
        }
        if (this.isInSleepingPose()) {
            this.playWakeSound();
        } else {
            this.playMoveSound();
        }
        this.m_20124_(TuffGolemEntityPose.STANDING.get());
    }

    public void startStandingWithItem() {
        if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
            return;
        }
        if (this.isInSleepingPose()) {
            this.playWakeSound();
        } else {
            this.playMoveSound();
        }
        this.m_20124_(TuffGolemEntityPose.STANDING_WITH_ITEM.get());
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_() && !FriendsAndFoes.getConfig().enableTuffGolem) {
            this.m_146870_();
        }
        if (!this.m_9236_().m_5776_() && this.inactiveTicksAfterSpawn > 0) {
            --this.inactiveTicksAfterSpawn;
        }
        this.updateKeyframeAnimations();
        super.m_8119_();
    }

    public boolean m_6094_() {
        return !this.m_5803_();
    }

    private void updateKeyframeAnimations() {
        KeyframeAnimation keyframeAnimationToStart;
        if (!this.m_9236_().m_5776_()) {
            this.updateKeyframeAnimationTicks();
        }
        if ((keyframeAnimationToStart = this.getKeyframeAnimationByPose()) != null && !this.isKeyframeAnimationRunning(keyframeAnimationToStart)) {
            if (!this.m_9236_().m_5776_()) {
                this.setKeyframeAnimationTicks(keyframeAnimationToStart.getAnimationLengthInTicks());
            }
            this.startKeyframeAnimation(keyframeAnimationToStart);
        }
    }

    @Nullable
    private KeyframeAnimation getKeyframeAnimationByPose() {
        Pose prevPose = this.getPrevPose();
        Pose pose = this.m_20089_();
        if (pose == prevPose) {
            return null;
        }
        KeyframeAnimation keyframeAnimation = null;
        if (this.wasInPose(TuffGolemEntityPose.STANDING)) {
            if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
                keyframeAnimation = TuffGolemAnimations.SHOW_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.SLEEPING)) {
                keyframeAnimation = TuffGolemAnimations.SLEEP;
            }
        } else if (this.wasInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
            if (this.isInPose(TuffGolemEntityPose.STANDING)) {
                keyframeAnimation = TuffGolemAnimations.HIDE_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
                keyframeAnimation = TuffGolemAnimations.SLEEP_WITH_ITEM;
            }
        } else if (this.wasInPose(TuffGolemEntityPose.SLEEPING)) {
            if (this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
                keyframeAnimation = TuffGolemAnimations.SHOW_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
                keyframeAnimation = TuffGolemAnimations.WAKE_AND_SHOW_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING)) {
                keyframeAnimation = TuffGolemAnimations.WAKE;
            }
        } else if (this.wasInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
            if (this.isInPose(TuffGolemEntityPose.SLEEPING)) {
                keyframeAnimation = TuffGolemAnimations.HIDE_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING)) {
                keyframeAnimation = TuffGolemAnimations.WAKE_AND_HIDE_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
                keyframeAnimation = TuffGolemAnimations.WAKE_WITH_ITEM;
            }
        }
        return keyframeAnimation;
    }

    private void startKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        for (KeyframeAnimation keyframeAnimation : TuffGolemAnimations.ANIMATIONS) {
            if (keyframeAnimation == keyframeAnimationToStart) continue;
            this.stopKeyframeAnimation(keyframeAnimation);
        }
        this.startKeyframeAnimation(keyframeAnimationToStart, this.f_19797_);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker = source.m_7639_();
        if (attacker instanceof LightningBolt || source == this.m_269291_().m_269555_()) {
            return false;
        }
        if (!this.m_9236_().m_5776_() && this.isInSleepingPose()) {
            if (this.isHoldingItem()) {
                this.startStandingWithItem();
            } else {
                this.startStanding();
            }
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6573_(Player player) {
        return super.m_6573_(player) && !this.isInSleepingPose();
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 0.45, 0.0);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.8f;
    }

    public float m_6113_() {
        return this.isHoldingItem() ? 0.175f : 0.225f;
    }

    protected void m_7625_(DamageSource source, boolean causedByPlayer) {
        if (this.isHoldingItem()) {
            this.m_19983_(this.m_6844_(EquipmentSlot.MAINHAND));
        }
        super.m_7625_(source, causedByPlayer);
    }

    public float getMovementSpeedModifier() {
        if (this.isHoldingItem()) {
            return 1.0f;
        }
        return 0.7777778f;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public void setSpawnYaw(float yaw) {
        this.f_20907_ = yaw;
        this.f_19859_ = yaw;
        this.m_146922_(yaw);
        this.f_20884_ = yaw;
        this.m_5618_(yaw);
        this.f_20886_ = yaw;
        this.m_5616_(yaw);
    }

    public static enum Color {
        RED("red"),
        BLACK("black"),
        BLUE("blue"),
        BROWN("brown"),
        CYAN("cyan"),
        GRAY("gray"),
        GREEN("green"),
        LIGHT_BLUE("light_blue"),
        LIGHT_GRAY("light_gray"),
        LIME("lime"),
        MAGENTA("magenta"),
        ORANGE("orange"),
        PINK("pink"),
        PURPLE("purple"),
        WHITE("white"),
        YELLOW("yellow");

        private final String name;

        private Color(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static Color fromName(String name) {
            Color[] colors;
            for (Color color : colors = Color.values()) {
                if (!color.name.equals(name)) continue;
                return color;
            }
            return RED;
        }

        public static Color fromDyeColor(DyeColor dyeColor) {
            return switch (dyeColor) {
                case DyeColor.BLACK -> BLACK;
                case DyeColor.BLUE -> BLUE;
                case DyeColor.BROWN -> BROWN;
                case DyeColor.CYAN -> CYAN;
                case DyeColor.GRAY -> GRAY;
                case DyeColor.GREEN -> GREEN;
                case DyeColor.LIGHT_BLUE -> LIGHT_BLUE;
                case DyeColor.LIGHT_GRAY -> LIGHT_GRAY;
                case DyeColor.LIME -> LIME;
                case DyeColor.MAGENTA -> MAGENTA;
                case DyeColor.ORANGE -> ORANGE;
                case DyeColor.PINK -> PINK;
                case DyeColor.PURPLE -> PURPLE;
                case DyeColor.WHITE -> WHITE;
                case DyeColor.YELLOW -> YELLOW;
                default -> RED;
            };
        }

        public static Color fromWool(Block block) {
            if (block == Blocks.f_50109_) {
                return BLACK;
            }
            if (block == Blocks.f_50105_) {
                return BLUE;
            }
            if (block == Blocks.f_50106_) {
                return BROWN;
            }
            if (block == Blocks.f_50103_) {
                return CYAN;
            }
            if (block == Blocks.f_50101_) {
                return GRAY;
            }
            if (block == Blocks.f_50107_) {
                return GREEN;
            }
            if (block == Blocks.f_50097_) {
                return LIGHT_BLUE;
            }
            if (block == Blocks.f_50102_) {
                return LIGHT_GRAY;
            }
            if (block == Blocks.f_50099_) {
                return LIME;
            }
            if (block == Blocks.f_50096_) {
                return MAGENTA;
            }
            if (block == Blocks.f_50042_) {
                return ORANGE;
            }
            if (block == Blocks.f_50100_) {
                return PINK;
            }
            if (block == Blocks.f_50104_) {
                return PURPLE;
            }
            if (block == Blocks.f_50041_) {
                return WHITE;
            }
            if (block == Blocks.f_50098_) {
                return YELLOW;
            }
            return RED;
        }
    }
}

