/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class CrabLayEggTask
extends Behavior<CrabEntity> {
    private static final float WITHING_DISTANCE = 2.0f;

    public CrabLayEggTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), MemoryStatus.VALUE_PRESENT, FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), MemoryStatus.VALUE_PRESENT), 100);
    }

    protected boolean shouldRun(ServerLevel world, CrabEntity crab) {
        return crab.getBurrowSpotPos() != null && crab.isBurrowSpotAccessible(crab.getBurrowSpotPos().m_122646_()) && crab.getBurrowSpotPos().m_122646_().m_203195_((Position)crab.m_20182_(), 2.0) && !crab.m_21573_().m_26572_();
    }

    protected void run(ServerLevel world, CrabEntity crab, long time) {
    }

    protected boolean shouldKeepRunning(ServerLevel world, CrabEntity crab, long time) {
        return true;
    }

    protected void keepRunning(ServerLevel world, CrabEntity crab, long time) {
        GlobalPos burrowSpotPos = crab.getBurrowSpotPos();
        if (burrowSpotPos == null || time % 5L != 0L) {
            return;
        }
        world.m_46796_(2001, burrowSpotPos.m_122646_(), Block.m_49956_((BlockState)world.m_8055_(burrowSpotPos.m_122646_().m_7495_())));
    }

    protected void finishRunning(ServerLevel world, CrabEntity crab, long time) {
        GlobalPos burrowSpotPos = crab.getBurrowSpotPos();
        if (burrowSpotPos != null) {
            world.m_5594_(null, burrowSpotPos.m_122646_(), SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + world.f_46441_.m_188501_() * 0.2f);
            world.m_7731_(burrowSpotPos.m_122646_(), (BlockState)FriendsAndFoesBlocks.CRAB_EGG.get().m_49966_().m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)Integer.valueOf(crab.m_217043_().m_188503_(4) + 1)), 3);
        }
        crab.setHasEgg(false);
        crab.m_27601_(600);
        crab.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get());
    }
}

