/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.mob;

import com.faboslav.variantsandventures.common.entity.ai.GelidSnowballRangedAttackGoal;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public final class GelidEntity
extends Zombie {
    public GelidEntity(EntityType<? extends Zombie> entityType, Level world) {
        super(entityType, world);
    }

    public static boolean canSpawn(EntityType<Stray> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return GelidEntity.m_219013_(type, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && (spawnReason == MobSpawnType.SPAWNER || world.m_45527_(pos));
    }

    public static AttributeSupplier.Builder createGelidAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 2.0).m_22266_(Attributes.f_22287_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new GelidSnowballRangedAttackGoal(this, 10.0f));
        super.m_8099_();
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        this.m_8061_(EquipmentSlot.OFFHAND, Items.f_42452_.m_7968_());
    }

    protected SoundEvent m_7515_() {
        return VariantsAndVenturesSoundEvents.ENTITY_GELID_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return VariantsAndVenturesSoundEvents.ENTITY_GELID_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return VariantsAndVenturesSoundEvents.ENTITY_GELID_DEATH.get();
    }

    protected SoundEvent m_7660_() {
        return VariantsAndVenturesSoundEvents.ENTITY_GELID_STEP.get();
    }

    public void throwSnowball(LivingEntity target, float pullProgress) {
        ItemStack itemStack = this.m_21120_(InteractionHand.OFF_HAND);
        Item itemInHand = itemStack.m_41720_();
        if (itemInHand != Items.f_42452_) {
            return;
        }
        itemStack.m_41774_(1);
        Snowball snowballEntity = new Snowball(this.m_9236_(), (LivingEntity)this);
        double d = target.m_20188_() - (double)1.1f;
        double e = target.m_20185_() - this.m_20185_();
        double f = d - snowballEntity.m_20186_();
        double g = target.m_20189_() - this.m_20189_();
        double h = Math.sqrt(e * e + g * g) * (double)0.2f;
        snowballEntity.m_6686_(e, f + h, g, 1.6f, 7.0f);
        this.m_5496_(SoundEvents.f_12479_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_6674_(InteractionHand.OFF_HAND);
        this.m_9236_().m_7967_((Entity)snowballEntity);
    }

    public boolean m_7327_(Entity target) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(VariantsAndVenturesSoundEvents.ENTITY_GELID_ATTACK.get(), 1.0f, this.m_6100_());
        boolean attackResult = super.m_7327_(target);
        if (attackResult && this.m_21205_().m_41619_() && target instanceof LivingEntity && target.m_142079_()) {
            float difficulty = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
            target.m_146917_(140 * (int)difficulty);
        }
        return attackResult;
    }
}

