/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.init;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.entity.mob.GelidEntity;
import com.faboslav.variantsandventures.common.entity.mob.MurkEntity;
import com.faboslav.variantsandventures.common.entity.mob.ThicketEntity;
import com.faboslav.variantsandventures.common.entity.mob.VerdantEntity;
import com.faboslav.variantsandventures.common.events.lifecycle.AddSpawnBiomeModificationsEvent;
import com.faboslav.variantsandventures.common.events.lifecycle.RegisterEntityAttributesEvent;
import com.faboslav.variantsandventures.common.events.lifecycle.RegisterEntitySpawnRestrictionsEvent;
import com.faboslav.variantsandventures.common.init.registry.ResourcefulRegistries;
import com.faboslav.variantsandventures.common.init.registry.ResourcefulRegistry;
import com.faboslav.variantsandventures.common.tag.VariantsAndVenturesTags;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;

public final class VariantsAndVenturesEntityTypes {
    public static final ResourcefulRegistry<EntityType<?>> ENTITY_TYPES = ResourcefulRegistries.create(BuiltInRegistries.f_256780_, "variantsandventures");
    public static boolean previousUseChoiceTypeRegistrations = SharedConstants.f_136182_;
    public static final Supplier<EntityType<GelidEntity>> GELID;
    public static final Supplier<EntityType<MurkEntity>> MURK;
    public static final Supplier<EntityType<ThicketEntity>> THICKET;
    public static final Supplier<EntityType<VerdantEntity>> VERDANT;

    public static void registerEntityAttributes(RegisterEntityAttributesEvent event) {
        event.register(GELID.get(), GelidEntity.createGelidAttributes());
        event.register(MURK.get(), MurkEntity.createMurkAttributes());
        event.register(THICKET.get(), ThicketEntity.m_34328_());
        event.register(VERDANT.get(), VerdantEntity.m_32166_());
    }

    public static void registerEntitySpawnRestrictions(RegisterEntitySpawnRestrictionsEvent event) {
        event.register(MURK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MurkEntity::canSpawn);
    }

    public static void addSpawnBiomeModifications(AddSpawnBiomeModificationsEvent event) {
        if (VariantsAndVentures.getConfig().enableMurk && VariantsAndVentures.getConfig().enableMurkSpawns) {
            event.add(VariantsAndVenturesTags.HAS_MURK, MobCategory.MONSTER, MURK.get(), 4, 1, 1);
        }
    }

    static {
        SharedConstants.f_136182_ = false;
        GELID = ENTITY_TYPES.register("gelid", () -> EntityType.Builder.m_20704_(GelidEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20714_(new Block[]{Blocks.f_152499_}).m_20702_(8).m_20712_(VariantsAndVentures.makeStringID("gelid")));
        MURK = ENTITY_TYPES.register("murk", () -> EntityType.Builder.m_20704_(MurkEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8).m_20712_(VariantsAndVentures.makeStringID("murk")));
        THICKET = ENTITY_TYPES.register("thicket", () -> EntityType.Builder.m_20704_(ThicketEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(8).m_20712_(VariantsAndVentures.makeStringID("thicket")));
        VERDANT = ENTITY_TYPES.register("verdant", () -> EntityType.Builder.m_20704_(VerdantEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8).m_20712_(VariantsAndVentures.makeStringID("verdant")));
        SharedConstants.f_136182_ = previousUseChoiceTypeRegistrations;
    }
}

