/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.animal;

import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModBiomeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class SheepColorSpawnRules {
    private static final SheepColorSpawnConfiguration TEMPERATE_SPAWN_CONFIGURATION = new SheepColorSpawnConfiguration(SheepColorSpawnRules.weighted((SimpleWeightedRandomList<SheepColorProvider>)SheepColorSpawnRules.builder().m_146271_((Object)SheepColorSpawnRules.single(DyeColor.BLACK), 5).m_146271_((Object)SheepColorSpawnRules.single(DyeColor.GRAY), 5).m_146271_((Object)SheepColorSpawnRules.single(DyeColor.LIGHT_GRAY), 5).m_146271_((Object)SheepColorSpawnRules.single(DyeColor.BROWN), 3).m_146271_((Object)SheepColorSpawnRules.commonColors(DyeColor.WHITE), 82).m_146270_()));
    private static final SheepColorSpawnConfiguration WARM_SPAWN_CONFIGURATION = new SheepColorSpawnConfiguration(SheepColorSpawnRules.weighted((SimpleWeightedRandomList<SheepColorProvider>)SheepColorSpawnRules.builder().m_146271_((Object)SheepColorSpawnRules.single(DyeColor.GRAY), 5).m_146271_((Object)SheepColorSpawnRules.single(DyeColor.LIGHT_GRAY), 5).m_146271_((Object)SheepColorSpawnRules.single(DyeColor.WHITE), 5).m_146271_((Object)SheepColorSpawnRules.single(DyeColor.BLACK), 3).m_146271_((Object)SheepColorSpawnRules.commonColors(DyeColor.BROWN), 82).m_146270_()));
    private static final SheepColorSpawnConfiguration COLD_SPAWN_CONFIGURATION = new SheepColorSpawnConfiguration(SheepColorSpawnRules.weighted((SimpleWeightedRandomList<SheepColorProvider>)SheepColorSpawnRules.builder().m_146271_((Object)SheepColorSpawnRules.single(DyeColor.LIGHT_GRAY), 5).m_146271_((Object)SheepColorSpawnRules.single(DyeColor.GRAY), 5).m_146271_((Object)SheepColorSpawnRules.single(DyeColor.WHITE), 5).m_146271_((Object)SheepColorSpawnRules.single(DyeColor.BROWN), 3).m_146271_((Object)SheepColorSpawnRules.commonColors(DyeColor.BLACK), 82).m_146270_()));

    private static SheepColorProvider commonColors(DyeColor color) {
        return SheepColorSpawnRules.weighted((SimpleWeightedRandomList<SheepColorProvider>)SheepColorSpawnRules.builder().m_146271_((Object)SheepColorSpawnRules.single(color), 499).m_146271_((Object)SheepColorSpawnRules.single(DyeColor.PINK), 1).m_146270_());
    }

    public static DyeColor getRandomSheepColor(DyeColor original, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)VanillaBackport.COMMON_CONFIG.hasFarmAnimalVariants.get()).booleanValue()) {
            return original;
        }
        SheepColorSpawnConfiguration config = SheepColorSpawnRules.getSheepColorConfiguration((Holder<Biome>)level.m_204166_(pos));
        return config.colors().get(random);
    }

    private static SheepColorSpawnConfiguration getSheepColorConfiguration(Holder<Biome> biome) {
        if (biome.m_203656_(ModBiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS)) {
            return WARM_SPAWN_CONFIGURATION;
        }
        return biome.m_203656_(ModBiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS) ? COLD_SPAWN_CONFIGURATION : TEMPERATE_SPAWN_CONFIGURATION;
    }

    private static SheepColorProvider weighted(SimpleWeightedRandomList<SheepColorProvider> colors) {
        if (colors.m_146337_()) {
            throw new IllegalArgumentException("List must be non-empty");
        }
        return random -> ((SheepColorProvider)colors.m_216820_(random).orElseThrow(IllegalStateException::new)).get(random);
    }

    private static SheepColorProvider single(DyeColor color) {
        return random -> color;
    }

    private static SimpleWeightedRandomList.Builder<SheepColorProvider> builder() {
        return SimpleWeightedRandomList.m_146263_();
    }

    static interface SheepColorProvider {
        public DyeColor get(RandomSource var1);
    }

    record SheepColorSpawnConfiguration(SheepColorProvider colors) {
    }
}

