/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.registries;

import com.blackgear.platform.core.helper.BlockRegistry;
import com.blackgear.vanillabackport.client.registries.ModParticles;
import com.blackgear.vanillabackport.client.registries.ModSoundTypes;
import com.blackgear.vanillabackport.common.level.blocks.ActualBushBlock;
import com.blackgear.vanillabackport.common.level.blocks.CactusFlowerBlock;
import com.blackgear.vanillabackport.common.level.blocks.CreakingHeartBlock;
import com.blackgear.vanillabackport.common.level.blocks.DriedGhastBlock;
import com.blackgear.vanillabackport.common.level.blocks.EyeblossomBlock;
import com.blackgear.vanillabackport.common.level.blocks.EyeblossomFlowerPotBlock;
import com.blackgear.vanillabackport.common.level.blocks.FireflyBushBlock;
import com.blackgear.vanillabackport.common.level.blocks.HangingMossBlock;
import com.blackgear.vanillabackport.common.level.blocks.LeafLitterBlock;
import com.blackgear.vanillabackport.common.level.blocks.MossyCarpetBlock;
import com.blackgear.vanillabackport.common.level.blocks.PaleMossBlock;
import com.blackgear.vanillabackport.common.level.blocks.ParticleLeavesBlock;
import com.blackgear.vanillabackport.common.level.blocks.ResinClumpBlock;
import com.blackgear.vanillabackport.common.level.blocks.ShortDryGrassBlock;
import com.blackgear.vanillabackport.common.level.blocks.TallDryGrassBlock;
import com.blackgear.vanillabackport.common.registries.ModBlockSetTypes;
import com.blackgear.vanillabackport.common.registries.ModWoodTypes;
import com.blackgear.vanillabackport.common.worldgen.grower.PaleOakTreeGrower;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class ModBlocks {
    public static final BlockRegistry BLOCKS = BlockRegistry.create((String)"minecraft");
    public static final Supplier<Block> PALE_OAK_LEAVES = BLOCKS.register("pale_oak_leaves", properties -> new ParticleLeavesBlock(50, (Supplier<? extends ParticleOptions>)ModParticles.PALE_OAK_LEAVES, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283856_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_((arg_0, arg_1, arg_2, arg_3) -> ((BlockRegistry)BLOCKS).ocelotOrParrot(arg_0, arg_1, arg_2, arg_3)).m_60960_((arg_0, arg_1, arg_2) -> ((BlockRegistry)BLOCKS).never(arg_0, arg_1, arg_2)).m_60971_((arg_0, arg_1, arg_2) -> ((BlockRegistry)BLOCKS).never(arg_0, arg_1, arg_2)).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_((arg_0, arg_1, arg_2) -> ((BlockRegistry)BLOCKS).never(arg_0, arg_1, arg_2)));
    public static final Supplier<Block> PALE_OAK_PLANKS = BLOCKS.register("pale_oak_planks", BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_());
    public static final Supplier<Block> PALE_OAK_STAIRS = BLOCKS.register("pale_oak_stairs", properties -> new StairBlock(PALE_OAK_PLANKS.get().m_49966_(), properties), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_());
    public static final Supplier<Block> PALE_OAK_SLAB = BLOCKS.register("pale_oak_slab", SlabBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_());
    public static final Supplier<Block> PALE_OAK_FENCE = BLOCKS.register("pale_oak_fence", FenceBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_());
    public static final Supplier<Block> PALE_OAK_FENCE_GATE = BLOCKS.register("pale_oak_fence_gate", properties -> new FenceGateBlock(properties, ModWoodTypes.PALE_OAK), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_278183_());
    public static final Supplier<Block> PALE_OAK_DOOR = BLOCKS.register("pale_oak_door", properties -> new DoorBlock(properties, ModBlockSetTypes.PALE_OAK), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_278183_().m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> PALE_OAK_WOOD = BLOCKS.register("pale_oak_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_());
    public static final Supplier<Block> PALE_OAK_LOG = BLOCKS.register("pale_oak_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.f_283942_, MapColor.f_283947_, SoundType.f_56736_));
    public static final Supplier<Block> STRIPPED_PALE_OAK_WOOD = BLOCKS.register("stripped_pale_oak_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_());
    public static final Supplier<Block> STRIPPED_PALE_OAK_LOG = BLOCKS.register("stripped_pale_oak_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.f_283942_, MapColor.f_283942_, SoundType.f_56736_));
    public static final Supplier<Block> PALE_MOSS_BLOCK = BLOCKS.register("pale_moss_block", PaleMossBlock::new, BlockBehaviour.Properties.m_284310_().m_278183_().m_284180_(MapColor.f_283779_).m_60978_(0.1f).m_60918_(SoundType.f_154669_).m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> PALE_MOSS_CARPET = BLOCKS.register("pale_moss_carpet", MossyCarpetBlock::new, BlockBehaviour.Properties.m_284310_().m_278183_().m_284180_(MapColor.f_283779_).m_60978_(0.1f).m_60918_(SoundType.f_154669_).m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> PALE_HANGING_MOSS = BLOCKS.register("pale_hanging_moss", HangingMossBlock::new, BlockBehaviour.Properties.m_284310_().m_278183_().m_284180_(MapColor.f_283779_).m_60910_().m_60918_(SoundType.f_154668_).m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> OPEN_EYEBLOSSOM = BLOCKS.register("open_eyeblossom", properties -> new EyeblossomBlock(EyeblossomBlock.Type.OPEN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY).m_60977_());
    public static final Supplier<Block> CLOSED_EYEBLOSSOM = BLOCKS.register("closed_eyeblossom", properties -> new EyeblossomBlock(EyeblossomBlock.Type.CLOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY).m_60977_());
    public static final Supplier<Block> PALE_OAK_SAPLING = BLOCKS.register("pale_oak_sapling", properties -> new SaplingBlock((AbstractTreeGrower)new PaleOakTreeGrower(), properties), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_).m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> POTTED_OPEN_EYEBLOSSOM = BLOCKS.registerNoItem("potted_open_eyeblossom", properties -> new EyeblossomFlowerPotBlock(OPEN_EYEBLOSSOM.get(), (BlockBehaviour.Properties)properties), ModBlocks.flowerPotProperties().m_60977_());
    public static final Supplier<Block> POTTED_CLOSED_EYEBLOSSOM = BLOCKS.registerNoItem("potted_closed_eyeblossom", properties -> new EyeblossomFlowerPotBlock(CLOSED_EYEBLOSSOM.get(), (BlockBehaviour.Properties)properties), ModBlocks.flowerPotProperties().m_60977_());
    public static final Supplier<Block> POTTED_PALE_OAK_SAPLING = BLOCKS.registerNoItem("potted_pale_oak_sapling", properties -> new FlowerPotBlock(PALE_OAK_SAPLING.get(), properties), ModBlocks.flowerPotProperties());
    public static final Supplier<Block> CREAKING_HEART = BLOCKS.register("creaking_heart", CreakingHeartBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60978_(10.0f).m_60918_(ModSoundTypes.CREAKING_HEART));
    public static final Pair<Supplier<Block>, Supplier<Block>> PALE_OAK_SIGN = ModBlocks.sign("pale_oak", ModWoodTypes.PALE_OAK, MapColor.f_283942_);
    public static final Pair<Supplier<Block>, Supplier<Block>> PALE_OAK_HANGING_SIGN = ModBlocks.hangingSign("pale_oak", ModWoodTypes.PALE_OAK, MapColor.f_283942_);
    public static final Supplier<Block> PALE_OAK_PRESSURE_PLATE = BLOCKS.register("pale_oak_pressure_plate", properties -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, properties, ModBlockSetTypes.PALE_OAK), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(0.5f).m_278183_().m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> PALE_OAK_TRAPDOOR = BLOCKS.register("pale_oak_trapdoor", properties -> new TrapDoorBlock(properties, ModBlockSetTypes.PALE_OAK), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_60922_((arg_0, arg_1, arg_2, arg_3) -> ((BlockRegistry)BLOCKS).never(arg_0, arg_1, arg_2, arg_3)).m_278183_());
    public static final Supplier<Block> PALE_OAK_BUTTON = BLOCKS.register("pale_oak_button", properties -> new ButtonBlock(properties, ModBlockSetTypes.PALE_OAK, 30, true), ModBlocks.buttonProperties());
    public static final Supplier<Block> RESIN_CLUMP = BLOCKS.register("resin_clump", ResinClumpBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_280170_().m_60910_().m_60918_(ModSoundTypes.RESIN).m_278183_().m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> RESIN_BLOCK = BLOCKS.register("resin_block", BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(ModSoundTypes.RESIN));
    public static final Supplier<Block> RESIN_BRICKS = BLOCKS.register("resin_bricks", BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60918_(ModSoundTypes.RESIN_BRICKS).m_60913_(1.5f, 6.0f));
    public static final Supplier<Block> RESIN_BRICK_STAIRS = BLOCKS.register("resin_brick_stairs", properties -> new StairBlock(RESIN_BRICKS.get().m_49966_(), properties), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60918_(ModSoundTypes.RESIN_BRICKS).m_60913_(1.5f, 6.0f));
    public static final Supplier<Block> RESIN_BRICK_SLAB = BLOCKS.register("resin_brick_slab", SlabBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60918_(ModSoundTypes.RESIN_BRICKS).m_60913_(1.5f, 6.0f));
    public static final Supplier<Block> RESIN_BRICK_WALL = BLOCKS.register("resin_brick_wall", WallBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60918_(ModSoundTypes.RESIN_BRICKS).m_60913_(1.5f, 6.0f));
    public static final Supplier<Block> CHISELED_RESIN_BRICKS = BLOCKS.register("chiseled_resin_bricks", BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60918_(ModSoundTypes.RESIN_BRICKS).m_60913_(1.5f, 6.0f));
    public static final Supplier<Block> DRIED_GHAST = BLOCKS.register("dried_ghast", DriedGhastBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60966_().m_60918_(ModSoundTypes.DRIED_GHAST).m_60955_().m_60977_());
    public static final Supplier<Block> BUSH = BLOCKS.register("bush", ActualBushBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_280170_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_278183_().m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> FIREFLY_BUSH = BLOCKS.register("firefly_bush", FireflyBushBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_278183_().m_60953_(state -> 2).m_60910_().m_60966_().m_60918_(SoundType.f_56757_).m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> WILDFLOWERS = BLOCKS.register("wildflowers", PinkPetalsBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60918_(SoundType.f_271137_).m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> LEAF_LITTER = BLOCKS.register("leaf_litter", LeafLitterBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_280170_().m_60910_().m_60918_(ModSoundTypes.LEAF_LITTER).m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> CACTUS_FLOWER = BLOCKS.register("cactus_flower", CactusFlowerBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283765_).m_60910_().m_60966_().m_278183_().m_60918_(ModSoundTypes.CACTUS_FLOWER).m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> SHORT_DRY_GRASS = BLOCKS.register("short_dry_grass", ShortDryGrassBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280170_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_278183_().m_222979_(BlockBehaviour.OffsetType.XYZ).m_278166_(PushReaction.DESTROY));
    public static final Supplier<Block> TALL_DRY_GRASS = BLOCKS.register("tall_dry_grass", TallDryGrassBlock::new, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280170_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_278183_().m_222979_(BlockBehaviour.OffsetType.XYZ).m_278166_(PushReaction.DESTROY));

    private static BlockBehaviour.Properties logProperties(MapColor topColor, MapColor sideColor, SoundType sound) {
        return BlockBehaviour.Properties.m_284310_().m_284495_(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : sideColor).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(sound).m_278183_();
    }

    private static BlockBehaviour.Properties buttonProperties() {
        return BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY);
    }

    private static BlockBehaviour.Properties flowerPotProperties() {
        return BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY);
    }

    public static Pair<Supplier<Block>, Supplier<Block>> sign(String name, WoodType woodType, MapColor color) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_278183_();
        Supplier standing = BLOCKS.registerNoItem(name + "_sign", () -> new StandingSignBlock(properties, woodType));
        Supplier wall = BLOCKS.registerNoItem(name + "_wall_sign", () -> ModBlocks.lambda$sign$17(properties, (Supplier)standing, woodType));
        BLOCKS.registerItem(name + "_sign", () -> ModBlocks.lambda$sign$18((Supplier)standing, (Supplier)wall));
        return new Pair((Object)standing, (Object)wall);
    }

    public static Pair<Supplier<Block>, Supplier<Block>> hangingSign(String name, WoodType woodType, MapColor color) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_278183_();
        Supplier ceiling = BLOCKS.registerNoItem(name + "_hanging_sign", () -> new CeilingHangingSignBlock(properties, woodType));
        Supplier wall = BLOCKS.registerNoItem(name + "_wall_hanging_sign", () -> ModBlocks.lambda$hangingSign$20(properties, (Supplier)ceiling, woodType));
        BLOCKS.registerItem(name + "_hanging_sign", () -> ModBlocks.lambda$hangingSign$21((Supplier)ceiling, (Supplier)wall));
        return new Pair((Object)ceiling, (Object)wall);
    }

    private static /* synthetic */ Item lambda$hangingSign$21(Supplier ceiling, Supplier wall) {
        return new HangingSignItem((Block)ceiling.get(), (Block)wall.get(), new Item.Properties().m_41487_(16));
    }

    private static /* synthetic */ Block lambda$hangingSign$20(BlockBehaviour.Properties properties, Supplier ceiling, WoodType woodType) {
        return new WallHangingSignBlock(properties.m_60916_((Block)ceiling.get()), woodType);
    }

    private static /* synthetic */ Item lambda$sign$18(Supplier standing, Supplier wall) {
        return new SignItem(new Item.Properties().m_41487_(16), (Block)standing.get(), (Block)wall.get());
    }

    private static /* synthetic */ Block lambda$sign$17(BlockBehaviour.Properties properties, Supplier standing, WoodType woodType) {
        return new WallSignBlock(properties.m_60916_((Block)standing.get()), woodType);
    }
}

