/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.util;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CollisionUtils {
    public static boolean intersects(AABB box, BlockPos pos) {
        return box.m_82314_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
    }

    public static boolean collidedWithFluid(LivingEntity entity, FluidState state, BlockPos pos, Vec3 origin, Vec3 target) {
        AABB box = CollisionUtils.getFluidAABB(state, (BlockGetter)entity.m_9236_(), pos);
        return box != null && CollisionUtils.collidedWithShapeMovingFrom(entity, origin, target, List.of(box));
    }

    public static boolean collidedWithShapeMovingFrom(LivingEntity entity, Vec3 origin, Vec3 target, List<AABB> boxes) {
        AABB box = entity.f_19815_.m_20393_(origin);
        Vec3 distance = target.m_82546_(origin);
        return CollisionUtils.collidedAlongVector(box, distance, boxes);
    }

    @Nullable
    public static AABB getFluidAABB(FluidState state, BlockGetter level, BlockPos pos) {
        if (state.m_76178_()) {
            return null;
        }
        float fluidHeight = state.m_76155_(level, pos);
        return new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, (double)((float)pos.m_123342_() + fluidHeight), (double)pos.m_123343_() + 1.0);
    }

    public static boolean collidedAlongVector(AABB entityBox, Vec3 origin, List<AABB> obstacles) {
        Vec3 center = entityBox.m_82399_();
        Vec3 distance = center.m_82549_(origin);
        for (AABB obstacle : obstacles) {
            AABB box = obstacle.m_82377_(entityBox.m_82362_() * 0.5, entityBox.m_82376_() * 0.5, entityBox.m_82385_() * 0.5);
            if (box.m_82390_(distance) || box.m_82390_(center)) {
                return true;
            }
            if (!box.m_82371_(center, distance).isPresent()) continue;
            return true;
        }
        return false;
    }
}

