/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.teacon.xkdeco.blockentity.WardrobeBlockEntity;
import org.teacon.xkdeco.init.XKDecoEntityTypes;

public final class WardrobeBlock
extends AbstractChestBlock<WardrobeBlockEntity> {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty DOUBLE = BooleanProperty.m_61465_((String)"double");
    public static final VoxelShape SHAPE_NORTH_OPEN = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH_OPEN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    public static final VoxelShape SHAPE_WEST_OPEN = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST_OPEN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);

    public WardrobeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_278166_(PushReaction.BLOCK), () -> XKDecoEntityTypes.WARDROBE.getOrCreate());
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, HINGE, HALF, DOUBLE});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape voxelShape;
        if (!((Boolean)pState.m_61143_((Property)OPEN)).booleanValue()) {
            voxelShape = Shapes.m_83144_();
        } else {
            switch ((Direction)pState.m_61143_((Property)FACING)) {
                case NORTH: {
                    voxelShape = SHAPE_NORTH_OPEN;
                    break;
                }
                case SOUTH: {
                    voxelShape = SHAPE_SOUTH_OPEN;
                    break;
                }
                case WEST: {
                    voxelShape = SHAPE_WEST_OPEN;
                    break;
                }
                case EAST: {
                    voxelShape = SHAPE_EAST_OPEN;
                    break;
                }
                default: {
                    throw new IllegalStateException("Block %s has an invalid state property: %s=%s".formatted(pState.toString(), FACING.m_61708_(), pState.m_61143_((Property)FACING)));
                }
            }
        }
        return voxelShape;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        if (blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(pContext)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)this.getHinge(pContext))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)DOUBLE, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_ && pPlayer.m_7500_()) {
            WardrobeBlock.preventCreativeDropFromBottomPart(pLevel, pPos, pState, pPlayer);
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        DoubleBlockHalf currentHalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (pFacing.m_122434_() == Direction.Axis.Y && currentHalf == DoubleBlockHalf.LOWER == (pFacing == Direction.UP)) {
            if (pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(HALF) != currentHalf) {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)FACING, (Comparable)((Direction)pFacingState.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)pFacingState.m_61143_((Property)OPEN)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)pFacingState.m_61143_(HINGE)))).m_61124_((Property)DOUBLE, (Comparable)((Boolean)pFacingState.m_61143_((Property)DOUBLE)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> m_5641_(BlockState pState, Level pLevel, BlockPos pPos, boolean pOverride) {
        return DoubleBlockCombiner.Combiner::m_6502_;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_61143_(HALF) == DoubleBlockHalf.UPPER;
    }

    public int m_7753_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return this.m_7420_(pState, pLevel, pPos) ? 0 : 15;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return null;
    }

    private DoorHingeSide getHinge(BlockPlaceContext pContext) {
        BlockPos clickPos = pContext.m_8083_();
        Direction facing = pContext.m_8125_();
        int stepX = facing.m_122429_();
        int stepZ = facing.m_122431_();
        Vec3 clickLocation = pContext.m_43720_();
        double xDiff = clickLocation.f_82479_ - (double)clickPos.m_123341_();
        double zDiff = clickLocation.f_82481_ - (double)clickPos.m_123343_();
        if (!(stepX < 0 && zDiff < 0.5 || stepX > 0 && zDiff > 0.5 || stepZ < 0 && xDiff > 0.5 || stepZ > 0 && xDiff < 0.5)) {
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public static void preventCreativeDropFromBottomPart(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = pLevel.m_8055_(blockpos = pPos.m_7495_())).m_60713_(pState.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            pLevel.m_7731_(blockpos, blockstate1, 35);
            pLevel.m_5898_(pPlayer, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }
}

