/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.xml.builders;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.queries.spans.SpanOrQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanTermQuery;
import guideme.internal.shaded.lucene.queryparser.xml.DOMUtils;
import guideme.internal.shaded.lucene.queryparser.xml.ParserException;
import guideme.internal.shaded.lucene.queryparser.xml.builders.SpanBuilderBase;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class SpanOrTermsBuilder
extends SpanBuilderBase {
    private final Analyzer analyzer;

    public SpanOrTermsBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public SpanQuery getSpanQuery(Element e) throws ParserException {
        SpanOrQuery spanOrQuery;
        block9: {
            String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
            String value = DOMUtils.getNonBlankTextOrFail(e);
            ArrayList<SpanTermQuery> clausesList = new ArrayList<SpanTermQuery>();
            TokenStream ts = this.analyzer.tokenStream(fieldName, value);
            try {
                TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
                ts.reset();
                while (ts.incrementToken()) {
                    SpanTermQuery stq = new SpanTermQuery(new Term(fieldName, BytesRef.deepCopyOf(termAtt.getBytesRef())));
                    clausesList.add(stq);
                }
                ts.end();
                spanOrQuery = new SpanOrQuery(clausesList.toArray(new SpanQuery[clausesList.size()]));
                if (ts == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ts != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new ParserException("IOException parsing value:" + value, ioe);
                }
            }
            ts.close();
        }
        return spanOrQuery;
    }
}

