/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import org.jspecify.annotations.Nullable;

public final class RegistryWrappers {
    public static final RegistryWrapper<Item> ITEMS = PlatformHelper.get().wrap(Registries.f_256913_);
    public static final RegistryWrapper<Block> BLOCKS = PlatformHelper.get().wrap(Registries.f_256747_);
    public static final RegistryWrapper<BlockEntityType<?>> BLOCK_ENTITY_TYPES = PlatformHelper.get().wrap(Registries.f_256922_);
    public static final RegistryWrapper<Fluid> FLUIDS = PlatformHelper.get().wrap(Registries.f_256808_);
    public static final RegistryWrapper<Enchantment> ENCHANTMENTS = PlatformHelper.get().wrap(Registries.f_256762_);
    public static final RegistryWrapper<MobEffect> MOB_EFFECTS = PlatformHelper.get().wrap(Registries.f_256929_);
    public static final RegistryWrapper<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = PlatformHelper.get().wrap(Registries.f_256982_);
    public static final RegistryWrapper<RecipeSerializer<?>> RECIPE_SERIALIZERS = PlatformHelper.get().wrap(Registries.f_256764_);
    public static final RegistryWrapper<MenuType<?>> MENU = PlatformHelper.get().wrap(Registries.f_256798_);

    private RegistryWrappers() {
    }

    public static <K> void writeKey(FriendlyByteBuf buf, RegistryWrapper<K> registry, K object) {
        buf.m_130085_(registry.getKey(object));
    }

    public static <K> K readKey(FriendlyByteBuf buf, RegistryWrapper<K> registry) {
        ResourceLocation id = buf.m_130281_();
        return registry.get(id);
    }

    public static interface RegistryWrapper<T>
    extends IdMap<T> {
        public ResourceLocation getKey(T var1);

        public T get(ResourceLocation var1);

        public @Nullable T tryGet(ResourceLocation var1);

        default public Stream<T> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }
    }
}

