/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.event;

import com.blamejared.crafttweaker.CraftTweakerCommon;
import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.action.villager.ActionTradeBase;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.attribute.ItemAttributeModifierBase;
import com.blamejared.crafttweaker.api.util.sequence.SequenceManager;
import com.blamejared.crafttweaker.api.util.sequence.SequenceType;
import com.blamejared.crafttweaker.api.villager.CTVillagerTrades;
import com.blamejared.crafttweaker.impl.logging.CraftTweakerLog4jEditor;
import com.blamejared.crafttweaker.impl.script.ScriptReloadListener;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="crafttweaker")
public class CTCommonEventHandler {
    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            SequenceManager.tick(SequenceType.SERVER_THREAD_LEVEL);
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            SequenceManager.tick(SequenceType.CLIENT_THREAD_LEVEL);
        }
    }

    @SubscribeEvent
    public static void blockInteract(PlayerInteractEvent.RightClickBlock e) {
        if (Services.EVENT.onBlockInteract(e.getEntity(), e.getHand(), e.getHitVec())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void entityInteract(PlayerInteractEvent.EntityInteract e) {
        if (Services.EVENT.onEntityInteract(e.getEntity(), e.getHand(), e.getTarget())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void attribute(ItemAttributeModifierEvent e) {
        Services.EVENT.applyAttributeModifiers((ItemAttributeModifierBase)e);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void wanderingTradesTweaker(WandererTradesEvent e) {
        CTVillagerTrades.ACTION_WANDERING_TRADES.forEach(IUndoableAction::undo);
        CTVillagerTrades.ACTION_WANDERING_TRADES.forEach(actionTradeBase -> {
            List trades;
            switch (actionTradeBase.getLevel()) {
                case 1: {
                    List list = e.getGenericTrades();
                    break;
                }
                case 2: {
                    List list = e.getRareTrades();
                    break;
                }
                default: {
                    List list = trades = null;
                }
            }
            if (trades != null) {
                actionTradeBase.apply(trades);
            }
        });
        CTVillagerTrades.ACTION_WANDERING_TRADES.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void villagerTradesTweaker(VillagerTradesEvent e) {
        List<ActionTradeBase> collect = CTVillagerTrades.ACTIONS_VILLAGER_TRADES.stream().filter(actionTradeBase -> actionTradeBase.getProfession() == e.getType()).toList();
        collect.forEach(IUndoableAction::undo);
        collect.forEach(actionTradeBase -> actionTradeBase.apply((List)e.getTrades().computeIfAbsent(actionTradeBase.getLevel(), value -> new ArrayList())));
        CTVillagerTrades.ACTIONS_VILLAGER_TRADES.removeAll(collect);
    }

    @SubscribeEvent
    public static void burnTimeTweaker(FurnaceFuelBurnTimeEvent e) {
        RecipeType recipeType = e.getRecipeType() != null ? e.getRecipeType() : RecipeType.f_44108_;
        Services.EVENT.getBurnTimes().getOrDefault(recipeType, List.of()).stream().filter(pair -> ((IIngredient)pair.getFirst()).matches(IItemStack.of(e.getItemStack()))).forEach(pair -> e.setBurnTime(((Integer)pair.getSecond()).intValue()));
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        CraftTweakerLog4jEditor.addPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        CraftTweakerLog4jEditor.removePlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CraftTweakerCommon.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getCommandSelection());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void resourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ScriptReloadListener(event.getServerResources(), CTCommonEventHandler::giveFeedback));
    }

    private static void giveFeedback(MutableComponent msg) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.m_6846_().m_240416_((Component)msg, false);
        } else {
            CraftTweakerCommon.logger().info(msg.getString());
        }
    }
}

