/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zencode.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.openzen.zencode.java.ScriptingEngine;
import org.openzen.zencode.java.module.JavaNativeModule;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.logging.IZSLogger;
import org.openzen.zenscript.codemodel.definition.ZSPackage;

public class JavaNativeLoader {
    private final Class<?>[] classes;
    private final Class<?>[] globals;
    private final Map<String, LoadingModule> modulesByName = new HashMap<String, LoadingModule>();
    private final IZSLogger logger;
    private boolean loaded = false;

    public JavaNativeLoader(Class<?>[] classes, Class<?>[] globals, IZSLogger logger) {
        this.classes = classes;
        this.globals = globals;
        this.logger = logger;
    }

    public LoadingModule addModule(ZSPackage pkg, String name, String basePackage, String ... dependencies) {
        if (this.loaded) {
            throw new IllegalStateException("Already loaded modules!");
        }
        if (this.modulesByName.containsKey(name)) {
            throw new IllegalArgumentException("Module already exists: " + name);
        }
        LoadingModule module = new LoadingModule(pkg, name, basePackage, dependencies);
        this.modulesByName.put(name, module);
        return module;
    }

    public ScriptingEngine load() throws CompileException {
        this.loaded = true;
        this.sortClasses();
        ScriptingEngine engine = new ScriptingEngine();
        for (LoadingModule module : this.modulesByName.values()) {
            this.load(engine, module);
        }
        return engine;
    }

    private void sortClasses() throws CompileException {
        LoadingModule module;
        HashMap<String, LoadingModule> modulesByPackage = new HashMap<String, LoadingModule>();
        for (LoadingModule module2 : this.modulesByName.values()) {
            if (modulesByPackage.containsKey(module2.basePackage)) {
                throw CompileException.internalError("Two modules have the same base package: " + module2.basePackage);
            }
            modulesByPackage.put(module2.basePackage, module2);
        }
        for (Class<?> cls : this.classes) {
            module = this.findModuleByPackage(modulesByPackage, this.getPackageName(cls));
            if (module == null) {
                this.logger.warning("Module not found for class " + cls.getName());
                continue;
            }
            module.classes.add(cls);
        }
        for (Class<?> cls : this.globals) {
            module = this.findModuleByPackage(modulesByPackage, this.getPackageName(cls));
            if (module == null) {
                this.logger.warning("Module not found for class " + cls.getName());
                continue;
            }
            module.globals.add(cls);
        }
    }

    private String getPackageName(Class<?> cls) {
        String name = cls.getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    private LoadingModule findModuleByPackage(Map<String, LoadingModule> modulesByPackage, String packageName) {
        if (modulesByPackage.containsKey(packageName)) {
            return modulesByPackage.get(packageName);
        }
        int index = packageName.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return this.findModuleByPackage(modulesByPackage, packageName.substring(0, index));
    }

    private JavaNativeModule load(ScriptingEngine engine, LoadingModule module) throws CompileException {
        if (module.resolved != null) {
            return module.resolved;
        }
        JavaNativeModule[] dependencies = new JavaNativeModule[module.dependencies.length];
        for (int i = 0; i < dependencies.length; ++i) {
            LoadingModule loadingModule = this.modulesByName.get(module.dependencies[i]);
            if (loadingModule == null) {
                throw CompileException.internalError("Module dependency for " + module.name + " missing: " + module.dependencies[i]);
            }
            dependencies[i] = this.load(engine, loadingModule);
        }
        module.resolved = new JavaNativeModule(this.logger, module.pkg, module.name, module.basePackage, engine.registry, dependencies);
        for (Class<?> clazz : module.classes) {
            module.resolved.addClass(clazz);
        }
        for (Class<?> clazz : module.globals) {
            module.resolved.addGlobals(clazz);
        }
        for (Consumer consumer : module.whenResolved) {
            consumer.accept(module.resolved);
        }
        engine.registerNativeProvided(module.resolved);
        return module.resolved;
    }

    public static class LoadingModule {
        private final ZSPackage pkg;
        private final String name;
        private final String basePackage;
        private final String[] dependencies;
        private final List<Consumer<JavaNativeModule>> whenResolved = new ArrayList<Consumer<JavaNativeModule>>();
        private final List<Class<?>> classes = new ArrayList();
        private final List<Class<?>> globals = new ArrayList();
        private JavaNativeModule resolved;

        private LoadingModule(ZSPackage pkg, String name, String basePackage, String[] dependencies) {
            this.pkg = pkg;
            this.name = name;
            this.basePackage = basePackage;
            this.dependencies = dependencies;
        }

        public void whenLoaded(Consumer<JavaNativeModule> consumer) {
            this.whenResolved.add(consumer);
        }
    }
}

