/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadItem;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadOffhandItem;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpRecharge;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-forge-1.20.1"})
public final class OpRecharge
implements SpellAction {
    @NotNull
    public static final OpRecharge INSTANCE = new OpRecharge();
    private static final int argc = 1;

    private OpRecharge() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        ItemEntity entity = OperatorUtils.getItemEntity(args, 0, this.getArgc());
        CastingEnvironment.HeldItemInfo heldItemInfo = env.getHeldItemToOperateOn(OpRecharge::execute$lambda$0);
        if (heldItemInfo == null) {
            throw MishapBadOffhandItem.Companion.of(ItemStack.f_41583_.m_41777_(), "rechargable", new Object[0]);
        }
        ItemStack handStack = heldItemInfo.component1();
        ADMediaHolder media = IXplatAbstractions.INSTANCE.findMediaHolder(handStack);
        if (media == null || !media.canRecharge()) {
            throw MishapBadOffhandItem.Companion.of(handStack, "rechargable", new Object[0]);
        }
        env.assertEntityInRange((Entity)entity);
        ItemStack itemStack = entity.m_32055_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"entity.item");
        if (!MediaHelper.isMediaItem(itemStack)) {
            throw MishapBadItem.Companion.of(entity, "media");
        }
        Intrinsics.checkNotNullExpressionValue((Object)handStack, (String)"handStack");
        RenderedSpell renderedSpell = new Spell(entity, handStack);
        Vec3 vec3 = entity.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"entity.position()");
        return new SpellAction.Result(renderedSpell, 50000L, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 0.5, 0, 4, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) throws Mishap {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    private static final boolean execute$lambda$0(ItemStack it) {
        ADMediaHolder media = IXplatAbstractions.INSTANCE.findMediaHolder(it);
        return media != null && media.canRecharge() && media.insertMedia(-1L, true) != 0L;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpRecharge$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "itemEntity", "Lnet/minecraft/world/entity/item/ItemEntity;", "stack", "Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/world/entity/item/ItemEntity;Lnet/minecraft/world/item/ItemStack;)V", "getItemEntity", "()Lnet/minecraft/world/entity/item/ItemEntity;", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final ItemEntity itemEntity;
        @NotNull
        private final ItemStack stack;

        public Spell(@NotNull ItemEntity itemEntity, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)itemEntity, (String)"itemEntity");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.itemEntity = itemEntity;
            this.stack = stack;
        }

        @NotNull
        public final ItemEntity getItemEntity() {
            return this.itemEntity;
        }

        @NotNull
        public final ItemStack getStack() {
            return this.stack;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            ADMediaHolder media = IXplatAbstractions.INSTANCE.findMediaHolder(this.stack);
            if (media != null && this.itemEntity.m_6084_()) {
                ItemStack entityStack = this.itemEntity.m_32055_().m_41777_();
                long emptySpace = media.insertMedia(-1L, true);
                Intrinsics.checkNotNullExpressionValue((Object)entityStack, (String)"entityStack");
                long mediaAmt = MediaHelper.extractMedia$default(entityStack, emptySpace, false, false, 12, null);
                media.insertMedia(mediaAmt, false);
                this.itemEntity.m_32045_(entityStack);
                if (entityStack.m_41619_()) {
                    this.itemEntity.m_6074_();
                }
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final ItemEntity component1() {
            return this.itemEntity;
        }

        @NotNull
        public final ItemStack component2() {
            return this.stack;
        }

        @NotNull
        public final Spell copy(@NotNull ItemEntity itemEntity, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)itemEntity, (String)"itemEntity");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return new Spell(itemEntity, stack);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, ItemEntity itemEntity, ItemStack itemStack, int n, Object object) {
            if ((n & 1) != 0) {
                itemEntity = spell.itemEntity;
            }
            if ((n & 2) != 0) {
                itemStack = spell.stack;
            }
            return spell.copy(itemEntity, itemStack);
        }

        @NotNull
        public String toString() {
            return "Spell(itemEntity=" + this.itemEntity + ", stack=" + this.stack + ")";
        }

        public int hashCode() {
            int result = this.itemEntity.hashCode();
            result = result * 31 + this.stack.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.itemEntity, (Object)spell.itemEntity)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stack, (Object)spell.stack);
        }
    }
}

