/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient.brainsweep;

import at.petrak.hexcasting.common.recipe.ingredient.brainsweep.BrainsweepeeIngredient;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class EntityTypeIngredient
extends BrainsweepeeIngredient {
    public final EntityType<?> entityType;

    public EntityTypeIngredient(EntityType<?> entityType) {
        this.entityType = entityType;
    }

    @Override
    public boolean test(Entity entity, ServerLevel level) {
        return entity.m_6095_() == this.entityType;
    }

    @Override
    public Component getName() {
        return this.entityType.m_20676_();
    }

    @Override
    public List<Component> getTooltip(boolean advanced) {
        return List.of(this.entityType.m_20676_(), BrainsweepeeIngredient.getModNameComponent(BuiltInRegistries.f_256780_.m_7981_(this.entityType).m_135827_()));
    }

    @Override
    public Entity exampleEntity(Level level) {
        return this.entityType.m_20615_(level);
    }

    @Override
    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", BrainsweepeeIngredient.Type.ENTITY_TYPE.m_7912_());
        obj.addProperty("entityType", BuiltInRegistries.f_256780_.m_7981_(this.entityType).toString());
        return obj;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(BuiltInRegistries.f_256780_.m_7447_(this.entityType));
    }

    public static EntityTypeIngredient deserialize(JsonObject obj) {
        ResourceLocation typeLoc = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"entityType"));
        if (typeLoc == null || !BuiltInRegistries.f_256780_.m_7804_(typeLoc)) {
            throw new IllegalArgumentException("unknown entity type " + typeLoc);
        }
        return new EntityTypeIngredient((EntityType)BuiltInRegistries.f_256780_.m_7745_(typeLoc));
    }

    public static EntityTypeIngredient read(FriendlyByteBuf buf) {
        int tyId = buf.m_130242_();
        return new EntityTypeIngredient((EntityType)BuiltInRegistries.f_256780_.m_7942_(tyId));
    }

    @Override
    public BrainsweepeeIngredient.Type ingrType() {
        return BrainsweepeeIngredient.Type.ENTITY_TYPE;
    }

    @Override
    public String getSomeKindOfReasonableIDForEmi() {
        ResourceLocation resloc = BuiltInRegistries.f_256780_.m_7981_(this.entityType);
        return resloc.m_135827_() + "//" + resloc.m_135815_();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTypeIngredient that = (EntityTypeIngredient)o;
        return Objects.equals(this.entityType, that.entityType);
    }

    public int hashCode() {
        return Objects.hash(this.entityType);
    }
}

